/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestKernelServicesImpl;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.ModelTestParser;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.server.Services;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KnownVersions;
import org.jboss.as.subsystem.test.ReadTransformedResourceOperation;
import org.jboss.as.subsystem.test.TestModelControllerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.staxmapper.XMLElementWriter;
import org.xnio.IoUtils;

public class KernelServicesImpl
extends ModelTestKernelServicesImpl<KernelServices>
implements KernelServices {
    private final String mainSubsystemName;
    private final ExtensionRegistry extensionRegistry;
    private final boolean registerTransformers;
    private static final AtomicInteger counter = new AtomicInteger();
    private static TransformationTarget.IgnoredTransformationRegistry MOCK_IGNORED_DOMAIN_RESOURCE_REGISTRY = new TransformationTarget.IgnoredTransformationRegistry(){

        public boolean isResourceTransformationIgnored(PathAddress address) {
            return false;
        }

        public boolean isOperationTransformationIgnored(PathAddress address) {
            return false;
        }

        public String getHostName() {
            return null;
        }
    };

    private KernelServicesImpl(ServiceContainer container, ModelTestModelControllerService controllerService, StringConfigurationPersister persister, ManagementResourceRegistration rootRegistration, OperationValidator operationValidator, String mainSubsystemName, ExtensionRegistry extensionRegistry, ModelVersion legacyModelVersion, boolean successfulBoot, Throwable bootError, boolean registerTransformers) {
        super(container, controllerService, persister, rootRegistration, operationValidator, legacyModelVersion, successfulBoot, bootError);
        this.mainSubsystemName = mainSubsystemName;
        this.extensionRegistry = extensionRegistry;
        this.registerTransformers = registerTransformers;
    }

    static KernelServicesImpl create(String mainSubsystemName, AdditionalInitialization additionalInit, ExtensionRegistry controllerExtensionRegistry, List<ModelNode> bootOperations, ModelTestParser testParser, Extension mainExtension, ModelVersion legacyModelVersion, boolean registerTransformers, boolean persistXml) throws Exception {
        ControllerInitializer controllerInitializer = additionalInit.createControllerInitializer();
        PathManagerService pathManager = new PathManagerService(){};
        controllerInitializer.setPathManger(pathManager);
        additionalInit.setupController(controllerInitializer);
        ServiceContainer container = ServiceContainer.Factory.create((String)("test" + counter.incrementAndGet()));
        ServiceTarget target = container.subTarget();
        List<ModelNode> extraOps = controllerInitializer.initializeBootOperations();
        ArrayList<ModelNode> allOps = new ArrayList<ModelNode>();
        if (extraOps != null) {
            allOps.addAll(extraOps);
        }
        allOps.addAll(bootOperations);
        StringConfigurationPersister persister = new StringConfigurationPersister(allOps, (XMLElementWriter)testParser, persistXml);
        controllerExtensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        controllerExtensionRegistry.setPathManager((PathManager)pathManager);
        TestModelControllerService svc = TestModelControllerService.create(mainExtension, controllerInitializer, additionalInit, controllerExtensionRegistry, persister, additionalInit.isValidateOperations(), registerTransformers);
        ServiceBuilder builder = target.addService(Services.JBOSS_SERVER_CONTROLLER, (Service)svc);
        builder.addDependency(PathManagerService.SERVICE_NAME);
        builder.install();
        target.addService(PathManagerService.SERVICE_NAME, (Service)pathManager).install();
        additionalInit.addExtraServices(target);
        svc.waitForSetup();
        KernelServicesImpl kernelServices = new KernelServicesImpl(container, svc, persister, svc.getRootRegistration(), new OperationValidator((ImmutableManagementResourceRegistration)svc.getRootRegistration()), mainSubsystemName, controllerExtensionRegistry, legacyModelVersion, svc.isSuccessfulBoot(), svc.getBootError(), registerTransformers);
        return kernelServices;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(ModelVersion modelVersion, ModelNode operation) throws OperationFailedException {
        this.checkIsMainController();
        PathElement pathElement = PathElement.pathElement((String)"subsystem", (String)this.mainSubsystemName);
        PathAddress opAddr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        if (opAddr.size() > 0 && opAddr.getElement(0).equals(pathElement) || operation.get("operation").asString().equals("composite")) {
            Map<PathAddress, ModelVersion> subsystem = Collections.singletonMap(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{pathElement}), modelVersion);
            TransformationTargetImpl transformationTarget = TransformationTargetImpl.create((TransformerRegistry)this.extensionRegistry.getTransformerRegistry(), (ModelVersion)this.getCoreModelVersionByLegacyModelVersion(modelVersion), subsystem, (TransformationTarget.IgnoredTransformationRegistry)MOCK_IGNORED_DOMAIN_RESOURCE_REGISTRY, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.SERVER);
            Transformers transformers = Transformers.Factory.create((TransformationTarget)transformationTarget);
            TransformationContext transformationContext = this.createTransformationContext((TransformationTarget)transformationTarget);
            return transformers.transformOperation(transformationContext, operation);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public ModelNode readTransformedModel(ModelVersion modelVersion) {
        this.getLegacyServices(modelVersion);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-transformed-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        op.get("subsystem").set(this.mainSubsystemName);
        ModelNode result = this.internalExecute(op, new ReadTransformedResourceOperation(this.getTransformersRegistry(), this.getCoreModelVersionByLegacyModelVersion(modelVersion), modelVersion));
        return ModelTestUtils.checkResultAndGetContents((ModelNode)result);
    }

    @Override
    public ModelNode executeOperation(ModelVersion modelVersion, final OperationTransformer.TransformedOperation op) {
        KernelServices legacy = (KernelServices)this.getLegacyServices(modelVersion);
        ModelNode result = new ModelNode();
        if (op.getTransformedOperation() != null && op.rejectOperation(result = legacy.executeOperation(op.getTransformedOperation(), new ModelController.OperationTransactionControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                if (op.rejectOperation(result)) {
                    transaction.rollback();
                } else {
                    transaction.commit();
                }
            }
        }))) {
            ModelNode newResponse = new ModelNode();
            newResponse.get("outcome").set("failed");
            newResponse.get("failure-description").set(op.getFailureDescription());
            return newResponse;
        }
        OperationResultTransformer resultTransformer = op.getResultTransformer();
        if (resultTransformer != null) {
            result = resultTransformer.transformResult(result);
        }
        return result;
    }

    ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    protected void addLegacyKernelService(ModelVersion modelVersion, KernelServicesImpl legacyServices) {
        super.addLegacyKernelService(modelVersion, (ModelTestKernelServices)legacyServices);
    }

    private ModelNode createSubsystemVersionRegistry(ModelVersion modelVersion) {
        ModelNode subsystems = new ModelNode();
        subsystems.get(this.mainSubsystemName).set(modelVersion.toString());
        return subsystems;
    }

    private ModelVersion getCoreModelVersionByLegacyModelVersion(ModelVersion legacyModelVersion) {
        if (System.getProperty("jboss.test.core.model.version.override") != null) {
            return ModelVersion.fromString((String)System.getProperty("jboss.test.core.model.version.override"));
        }
        ModelVersion coreModelVersion = KnownVersions.getCoreModelVersionForSubsystemVersion(this.mainSubsystemName, legacyModelVersion);
        if (coreModelVersion != null) {
            return coreModelVersion;
        }
        String fileName = this.mainSubsystemName + "-versions-to-as-versions.properties";
        InputStream in = this.getClass().getResourceAsStream("/" + fileName);
        if (in == null) {
            throw new IllegalArgumentException("Version " + legacyModelVersion + " of " + this.mainSubsystemName + " is not a known version. Please add it to " + KnownVersions.class.getName() + ". Or if that is not possible, " + "include a src/test/resources/" + fileName + " file, which maps AS versions to model versions. E.g.:\n1.1.0=7.1.2\n1.2.0=7.1.3");
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)in);
        }
        String asVersion = (String)props.get(legacyModelVersion.toString());
        if (asVersion == null) {
            throw new IllegalArgumentException("src/test/resources/" + fileName + " does not contain an AS mapping for modelversion + " + legacyModelVersion + "'. It needs to map AS versions to model versions. E.g.:\n1.1.0=7.1.2\n1.2.0=7.1.3");
        }
        coreModelVersion = KnownVersions.AS_CORE_MODEL_VERSION_BY_AS_VERSION.get(asVersion);
        if (coreModelVersion == null) {
            throw new IllegalArgumentException("Unknown AS version '" + asVersion + "' determined from src/test/resources/" + fileName + ". Known AS versions are " + KnownVersions.AS_CORE_MODEL_VERSION_BY_AS_VERSION.keySet());
        }
        return coreModelVersion;
    }
}

