package org.jboss.msc.service;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.Thread;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.ServiceName;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-09-02T09:56:51+0200")
public class ServiceLogger_$logger implements ServiceLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServiceLogger_$logger.class.getName();
    public ServiceLogger_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void greeting(final String version) {
        log.logf(FQCN, INFO, null, greeting$str(), version);
    }
    protected String greeting$str() {
        return "JBoss MSC version %s";
    }
    @Override
    public final void startFailed(final org.jboss.msc.service.StartException cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, ERROR, cause, startFailed$str(), serviceName);
    }
    protected String startFailed$str() {
        return "MSC000001: Failed to start %s";
    }
    @Override
    public final void listenerFailed(final Throwable cause, final Object listener) {
        log.logf(FQCN, ERROR, cause, listenerFailed$str(), listener);
    }
    protected String listenerFailed$str() {
        return "MSC000002: Invocation of listener \"%s\" failed";
    }
    @Override
    public final void exceptionAfterComplete(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, WARN, cause, exceptionAfterComplete$str(), serviceName);
    }
    protected String exceptionAfterComplete$str() {
        return "MSC000003: Exception thrown after start was already completed in %s";
    }
    @Override
    public final void stopFailed(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, WARN, cause, stopFailed$str(), serviceName);
    }
    protected String stopFailed$str() {
        return "MSC000004: Failure during stop of %s";
    }
    @Override
    public final void stopServiceMissing(final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, WARN, null, stopServiceMissing$str(), serviceName);
    }
    protected String stopServiceMissing$str() {
        return "MSC000005: Unexpected disappearance of %s during stop";
    }
    @Override
    public final void uninjectFailed(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName, final org.jboss.msc.service.ValueInjection<?> valueInjection) {
        log.logf(FQCN, WARN, cause, uninjectFailed$str(), serviceName, valueInjection);
    }
    protected String uninjectFailed$str() {
        return "MSC000006: Uninjection \"%2$s\" of %1$s failed unexpectedly";
    }
    @Override
    public final void internalServiceError(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, WARN, cause, internalServiceError$str(), serviceName);
    }
    protected String internalServiceError$str() {
        return "MSC000007: An internal service error has occurred while processing an operation on %s";
    }
    @Override
    public final void uncaughtException(final Throwable cause, final Thread thread) {
        log.logf(FQCN, ERROR, cause, uncaughtException$str(), thread);
    }
    protected String uncaughtException$str() {
        return "MSC000008: Worker thread %s threw an uncaught exception";
    }
    @Override
    public final void profileOutputCloseFailed(final IOException cause) {
        log.logf(FQCN, WARN, null, profileOutputCloseFailed$str(), cause);
    }
    protected String profileOutputCloseFailed$str() {
        return "MSC000009: An error occurred while trying to close the profile output file: %s";
    }
    @Override
    public final void mbeanFailed(final Exception e) {
        log.logf(FQCN, ERROR, e, mbeanFailed$str());
    }
    protected String mbeanFailed$str() {
        return "MSC000010: Failed to register MBean with MBeanServer";
    }
    protected String serviceNotStarted$str() {
        return "MSC000011: Service not started";
    }
    @Override
    public final IllegalStateException serviceNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceNotStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void injectFailed(final Throwable cause, final org.jboss.msc.service.ServiceName serviceName) {
        log.logf(FQCN, ERROR, cause, injectFailed$str(), serviceName);
    }
    protected String injectFailed$str() {
        return "MSC000012: Injection failed for service %s";
    }
}
