/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class InMemoryClientExecutor
implements ClientExecutor {
    protected Dispatcher dispatcher;
    protected URI baseUri;

    public InMemoryClientExecutor() {
        this.dispatcher = new SynchronousDispatcher(ResteasyProviderFactory.getInstance());
    }

    public InMemoryClientExecutor(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    @Override
    public ClientRequest createRequest(String uriTemplate) {
        return new ClientRequest(uriTemplate, (ClientExecutor)this);
    }

    @Override
    public ClientRequest createRequest(UriBuilder uriBuilder) {
        return new ClientRequest(uriBuilder, (ClientExecutor)this);
    }

    @Override
    public ClientResponse execute(ClientRequest request) throws Exception {
        MockHttpRequest mockHttpRequest = MockHttpRequest.create(request.getHttpMethod(), new URI(request.getUri()), this.baseUri);
        this.loadHttpMethod(request, mockHttpRequest);
        MockHttpResponse mockResponse = new MockHttpResponse();
        this.dispatcher.invoke(mockHttpRequest, mockResponse);
        return this.createResponse(request, mockResponse);
    }

    protected BaseClientResponse createResponse(ClientRequest request, MockHttpResponse mockResponse) {
        BaseClientResponse.BaseClientResponseStreamFactory streamFactory = InMemoryClientExecutor.createStreamFactory(mockResponse);
        BaseClientResponse response = new BaseClientResponse(streamFactory, this);
        response.setStatus(mockResponse.getStatus());
        this.setHeaders(mockResponse, response);
        response.setProviderFactory(request.getProviderFactory());
        return response;
    }

    protected void setHeaders(MockHttpResponse mockResponse, BaseClientResponse response) {
        MultivaluedMapImpl<String, String> responseHeaders = new MultivaluedMapImpl<String, String>();
        for (Map.Entry entry : mockResponse.getOutputHeaders().entrySet()) {
            ArrayList<String> values = new ArrayList<String>(((List)entry.getValue()).size());
            for (Object value : (List)entry.getValue()) {
                values.add(value.toString());
            }
            responseHeaders.addMultiple((String)entry.getKey(), (Collection<String>)values);
        }
        response.setHeaders(responseHeaders);
    }

    public static BaseClientResponse.BaseClientResponseStreamFactory createStreamFactory(final MockHttpResponse mockResponse) {
        return new BaseClientResponse.BaseClientResponseStreamFactory(){
            InputStream stream;

            @Override
            public InputStream getInputStream() throws IOException {
                if (this.stream == null) {
                    this.stream = new ByteArrayInputStream(mockResponse.getOutput());
                }
                return this.stream;
            }

            @Override
            public void performReleaseConnection() {
            }
        };
    }

    public void loadHttpMethod(ClientRequest request, MockHttpRequest mockHttpRequest) throws Exception {
        if (request.getBody() != null && !request.getFormParameters().isEmpty()) {
            throw new RuntimeException("You cannot send both form parameters and an entity body");
        }
        if (!request.getFormParameters().isEmpty()) {
            this.commitHeaders(request, mockHttpRequest);
            for (Map.Entry formParam : request.getFormParameters().entrySet()) {
                String key = (String)formParam.getKey();
                for (String value : (List)formParam.getValue()) {
                    mockHttpRequest.getFormParameters().add((Object)key, (Object)value);
                }
            }
        } else if (request.getBody() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MediaType bodyContentType = request.getBodyContentType();
            request.getHeadersAsObjects().add((Object)"Content-Type", (Object)bodyContentType.toString());
            request.writeRequestBody(request.getHeadersAsObjects(), baos);
            this.commitHeaders(request, mockHttpRequest);
            mockHttpRequest.content(baos.toByteArray());
            mockHttpRequest.contentType(bodyContentType);
        } else {
            this.commitHeaders(request, mockHttpRequest);
        }
    }

    public void commitHeaders(ClientRequest request, MockHttpRequest mockHttpRequest) {
        MultivaluedMap headers = mockHttpRequest.getHttpHeaders().getRequestHeaders();
        headers.putAll(request.getHeaders());
    }

    private void setBody(ClientRequest request, MockHttpRequest mockHttpRequest) throws IOException {
        if (request.getBody() == null) {
            return;
        }
    }

    public Registry getRegistry() {
        return this.dispatcher.getRegistry();
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void close() {
    }
}

