/*
 * Decompiled with CFR 0.152.
 */
package org.xnio._private;

import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.Channel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngineResult;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.xnio.IoFuture;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.FixedLengthOverflowException;
import org.xnio.channels.FixedLengthUnderflowException;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.WriteTimeoutException;

@MessageLogger(projectCode="XNIO")
public interface Messages
extends BasicLogger {
    public static final Messages msg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio");
    public static final Messages futureMsg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio.future");
    public static final Messages optionParseMsg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio.option.parse");
    public static final Messages closeMsg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio.safe-close");
    public static final Messages listenerMsg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio.listener");

    @Message(value="XNIO version %s")
    @LogMessage(level=Logger.Level.INFO)
    public void greeting(String var1);

    @Message(id=0, value="Method parameter '%s' cannot be null")
    public IllegalArgumentException nullParameter(String var1);

    @Message(id=1, value="Method parameter '%s' must be greater than %d")
    public IllegalArgumentException minRange(String var1, int var2);

    @Message(id=2, value="Unsupported socket address %s")
    public IllegalArgumentException badSockType(Class<? extends SocketAddress> var1);

    @Message(id=3, value="Method parameter '%s' contains disallowed null value at index %d")
    public IllegalArgumentException nullArrayIndex(String var1, int var2);

    @Message(id=4, value="Bind address %s is not the same type as destination address %s")
    public IllegalArgumentException mismatchSockType(Class<? extends SocketAddress> var1, Class<? extends SocketAddress> var2);

    @Message(id=5, value="No such field named \"%s\" in %s")
    public IllegalArgumentException noField(String var1, Class<?> var2);

    @Message(id=6, value="Class \"%s\" not found in %s")
    public IllegalArgumentException optionClassNotFound(String var1, ClassLoader var2);

    @Message(id=7, value="Field named \"%s\" is not accessible (public) in %s")
    public IllegalArgumentException fieldNotAccessible(String var1, Class<?> var2);

    @Message(id=8, value="Field named \"%s\" is not static in %s")
    public IllegalArgumentException fieldNotStatic(String var1, Class<?> var2);

    @Message(id=9, value="Copy with negative count is not supported")
    public UnsupportedOperationException copyNegative();

    @Message(id=10, value="Invalid option '%s' in property '%s': %s")
    @LogMessage(level=Logger.Level.WARN)
    public void invalidOptionInProperty(String var1, String var2, Throwable var3);

    @Message(id=12, value="Attempt to write to a read-only buffer")
    public ReadOnlyBufferException readOnlyBuffer();

    @Message(id=13, value="Buffer underflow")
    public BufferUnderflowException bufferUnderflow();

    @Message(id=14, value="Buffer overflow")
    public BufferOverflowException bufferOverflow();

    @Message(id=15, value="Parameter '%s' is out of range")
    public IllegalArgumentException parameterOutOfRange(String var1);

    @Message(id=16, value="Mixed direct and heap buffers not allowed")
    public IllegalArgumentException mixedDirectAndHeap();

    @Message(id=17, value="Buffer was already freed")
    public IllegalStateException bufferFreed();

    @Message(id=18, value="Access a thread-local random from the wrong thread")
    public IllegalStateException randomWrongThread();

    @Message(id=19, value="Channel not available from connection")
    public IllegalStateException channelNotAvailable();

    @Message(id=20, value="No parser for this option value type")
    public IllegalArgumentException noOptionParser();

    @Message(id=21, value="Invalid format for property value '%s'")
    public IllegalArgumentException invalidOptionPropertyFormat(String var1);

    @Message(id=22, value="Class %s not found")
    public IllegalArgumentException classNotFound(String var1, @Cause ClassNotFoundException var2);

    @Message(id=23, value="Class %s is not an instance of %s")
    public IllegalArgumentException classNotInstance(String var1, Class<?> var2);

    @Message(id=24, value="Invalid option name '%s'")
    public IllegalArgumentException invalidOptionName(String var1);

    @Message(id=25, value="Invalid null option '%s'")
    public IllegalArgumentException invalidNullOption(String var1);

    @Message(id=26, value="Read with append is not supported")
    public IOException readAppendNotSupported();

    @Message(id=27, value="Requested file open mode requires Java 7 or higher")
    public IOException openModeRequires7();

    @Message(id=28, value="Current thread is not an XNIO I/O thread")
    public IllegalStateException xnioThreadRequired();

    @Message(id=29, value="Compression format not supported")
    public IllegalArgumentException badCompressionFormat();

    @Message(id=30, value="Both channels must come from the same worker")
    public IllegalArgumentException differentWorkers();

    @Message(id=31, value="At least one channel must have a connection")
    public IllegalArgumentException oneChannelMustBeConnection();

    @Message(id=32, value="At least one channel must be an SSL channel")
    public IllegalArgumentException oneChannelMustBeSSL();

    @Message(id=33, value="'%s' is not a valid QOP value")
    public IllegalArgumentException invalidQop(String var1);

    @Message(id=34, value="Failed to instantiate %s")
    public IllegalArgumentException cantInstantiate(Class<?> var1, @Cause Throwable var2);

    @Message(id=35, value="Stream channel was accessed concurrently")
    public ConcurrentStreamChannelAccessException concurrentAccess();

    @Message(id=36, value="Malformed input")
    public CharConversionException malformedInput();

    @Message(id=37, value="Unmappable character")
    public CharConversionException unmappableCharacter();

    @Message(id=38, value="Character decoding problem")
    public CharConversionException characterDecodingProblem();

    @Message(id=40, value="Mismatched IP address type; expected %s but got %s")
    public IllegalArgumentException mismatchAddressType(Class<? extends InetAddress> var1, Class<? extends InetAddress> var2);

    @Message(id=41, value="'%s' is not a valid Strength value")
    public IllegalArgumentException invalidStrength(String var1);

    @Message(id=42, value="Cannot add unresolved address '%s'")
    public IllegalArgumentException addressUnresolved(InetSocketAddress var1);

    @Message(id=100, value="'https' URL scheme chosen but no SSL provider given")
    public IllegalArgumentException missingSslProvider();

    @Message(id=101, value="Unknown URL scheme '%s' given; must be one of 'http' or 'https'")
    public IllegalArgumentException invalidURLScheme(String var1);

    @Message(id=200, value="Unexpected extra SASL challenge data received")
    public SaslException extraChallenge();

    @Message(id=201, value="Unexpected extra SASL response data received")
    public SaslException extraResponse();

    @Message(id=300, value="Socket buffer is too small")
    public IllegalArgumentException socketBufferTooSmall();

    @Message(id=301, value="Application buffer is too small")
    public IllegalArgumentException appBufferTooSmall();

    @Message(id=302, value="SSLEngine required a bigger send buffer but our buffer was already big enough")
    public IOException wrongBufferExpansion();

    @Message(id=303, value="Unexpected wrap result status: %s")
    public IOException unexpectedWrapResult(SSLEngineResult.Status var1);

    @Message(id=304, value="Unexpected handshake status: %s")
    public IOException unexpectedHandshakeStatus(SSLEngineResult.HandshakeStatus var1);

    @Message(id=305, value="Unexpected unwrap result status: %s")
    public IOException unexpectedUnwrapResult(SSLEngineResult.Status var1);

    @Message(id=306, value="SSL connection is not from this provider")
    public IllegalArgumentException notFromThisProvider();

    @Message(id=800, value="Read timed out")
    public ReadTimeoutException readTimeout();

    @Message(id=801, value="Write timed out")
    public WriteTimeoutException writeTimeout();

    @Message(id=802, value="Write past the end of a fixed-length channel")
    public FixedLengthOverflowException fixedOverflow();

    @Message(id=803, value="Close before all bytes were written to a fixed-length channel (%d bytes remaining)")
    public FixedLengthUnderflowException fixedUnderflow(long var1);

    @Message(id=804, value="Received an invalid message length of %d")
    public IOException recvInvalidMsgLength(int var1);

    @Message(id=805, value="Writes have been shut down")
    public EOFException writeShutDown();

    @Message(id=806, value="Transmitted message is too large")
    public IOException txMsgTooLarge();

    @Message(id=807, value="Unflushed data truncated")
    public IOException unflushedData();

    @Message(id=808, value="I/O operation was interrupted")
    public InterruptedIOException interruptedIO();

    public InterruptedIOException interruptedIO(@Field int var1);

    @Message(id=809, value="Cannot flush due to insufficient buffer space")
    public IOException flushSmallBuffer();

    @Message(id=810, value="Deflater doesn't need input, but won't produce output")
    public IOException deflaterState();

    @Message(id=811, value="Inflater needs dictionary")
    public IOException inflaterNeedsDictionary();

    @Message(id=812, value="Connection closed unexpectedly")
    public EOFException connectionClosedEarly();

    @Message(id=813, value="The stream is closed")
    public IOException streamClosed();

    @Message(id=814, value="Mark not set")
    public IOException markNotSet();

    @Message(id=816, value="Redirect encountered establishing connection")
    public String redirect();

    @Message(id=900, value="Method '%s' is not supported on this implementation")
    public UnsupportedOperationException unsupported(String var1);

    @Message(id=1000, value="Blocking I/O is not allowed on the current thread")
    public IllegalStateException blockingNotAllowed();

    @Message(id=1001, value="No XNIO provider found")
    public IllegalArgumentException noProviderFound();

    @Message(id=1002, value="Operation was cancelled")
    public CancellationException opCancelled();

    @Message(id=1003, value="Running IoFuture notifier %s failed")
    @LogMessage(level=Logger.Level.WARN)
    public void notifierFailed(@Cause Throwable var1, IoFuture.Notifier<?, ?> var2);

    @Message(id=1004, value="Operation timed out")
    public TimeoutException opTimedOut();

    @Message(id=1005, value="Not allowed to read non-XNIO properties")
    public SecurityException propReadForbidden();

    @Message(id=1006, value="Failed to invoke file watch callback")
    @LogMessage(level=Logger.Level.ERROR)
    public void failedToInvokeFileWatchCallback(@Cause Throwable var1);

    @Message(id=1007, value="A channel event listener threw an exception")
    @LogMessage(level=Logger.Level.ERROR)
    public void listenerException(@Cause Throwable var1);

    @Message(id=1008, value="A channel exception handler threw an exception")
    @LogMessage(level=Logger.Level.ERROR)
    public void exceptionHandlerException(@Cause Throwable var1);

    @Message(id=1009, value="Failed to accept a connection on %s: %s")
    @LogMessage(level=Logger.Level.ERROR)
    public void acceptFailed(AcceptingChannel<? extends ConnectedChannel> var1, IOException var2);

    @Message(id=1010, value="Failed to submit task to executor: %s (closing %s)")
    @LogMessage(level=Logger.Level.ERROR)
    public void executorSubmitFailed(RejectedExecutionException var1, Channel var2);

    @Message(value="Closing resource %s")
    @LogMessage(level=Logger.Level.TRACE)
    public void closingResource(Object var1);

    @Message(value="Closing resource %s failed")
    @LogMessage(level=Logger.Level.TRACE)
    public void resourceCloseFailed(@Cause Throwable var1, Object var2);

    @Message(value="Shutting down reads on %s failed")
    @LogMessage(level=Logger.Level.TRACE)
    public void resourceReadShutdownFailed(@Cause Throwable var1, Object var2);
}

