/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.config.ConfigCustomizer;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ConfigCustomizerFactory;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

class SqlObjectCustomizerFactory
implements ConfigCustomizerFactory {
    static final ConfigCustomizerFactory FACTORY = new SqlObjectCustomizerFactory();

    SqlObjectCustomizerFactory() {
    }

    public Collection<ConfigCustomizer> forExtensionType(Class<?> sqlObjectType) {
        ConfigurerMethod forType = (configurer, config, annotation) -> configurer.configureForType(config, annotation, sqlObjectType);
        return SqlObjectCustomizerFactory.buildConfigCustomizer(Stream.concat(JdbiClassUtils.superTypes(sqlObjectType), Stream.of(sqlObjectType)), forType);
    }

    public Collection<ConfigCustomizer> forExtensionMethod(Class<?> sqlObjectType, Method method) {
        ConfigurerMethod forMethod = (configurer, config, annotation) -> configurer.configureForMethod(config, annotation, sqlObjectType, method);
        return SqlObjectCustomizerFactory.buildConfigCustomizer(Stream.of(method), forMethod);
    }

    private static Collection<ConfigCustomizer> buildConfigCustomizer(Stream<AnnotatedElement> elements, ConfigurerMethod consumer) {
        return elements.flatMap(ae -> Arrays.stream(ae.getAnnotations())).filter(a -> a.annotationType().isAnnotationPresent(ConfiguringAnnotation.class)).map(a -> {
            ConfiguringAnnotation meta = a.annotationType().getAnnotation(ConfiguringAnnotation.class);
            Configurer configurer = (Configurer)JdbiClassUtils.checkedCreateInstance(meta.value());
            return config -> consumer.configure(configurer, config, (Annotation)a);
        }).collect(Collectors.toList());
    }

    private static interface ConfigurerMethod {
        public void configure(Configurer var1, ConfigRegistry var2, Annotation var3);
    }
}

