/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.utils;

import com.alibaba.nacos.client.naming.utils.GenericPoller;
import com.alibaba.nacos.client.naming.utils.Pair;
import com.alibaba.nacos.client.naming.utils.Poller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class Chooser<K, T> {
    private final K uniqueKey;
    private volatile Ref<T> ref;

    public T random() {
        List items = ((Ref)this.ref).items;
        if (items.size() == 0) {
            return null;
        }
        if (items.size() == 1) {
            return (T)items.get(0);
        }
        return (T)items.get(ThreadLocalRandom.current().nextInt(items.size()));
    }

    public T randomWithWeight() {
        Ref<T> ref = this.ref;
        double random = ThreadLocalRandom.current().nextDouble(0.0, 1.0);
        int index = Arrays.binarySearch(((Ref)ref).weights, random);
        if (index >= 0) {
            return (T)((Ref)ref).items.get(index);
        }
        index = -index - 1;
        if (index < ((Ref)ref).weights.length && random < ((Ref)ref).weights[index]) {
            return (T)((Ref)ref).items.get(index);
        }
        return (T)((Ref)ref).items.get(((Ref)ref).items.size() - 1);
    }

    public Chooser(K uniqueKey) {
        this(uniqueKey, new ArrayList<Pair<T>>());
    }

    public Chooser(K uniqueKey, List<Pair<T>> pairs) {
        Ref<T> ref = new Ref<T>(pairs);
        ref.refresh();
        this.uniqueKey = uniqueKey;
        this.ref = ref;
    }

    public K getUniqueKey() {
        return this.uniqueKey;
    }

    public Ref<T> getRef() {
        return this.ref;
    }

    public void refresh(List<Pair<T>> itemsWithWeight) {
        Ref<T> newRef = new Ref<T>(itemsWithWeight);
        newRef.refresh();
        ((Ref)newRef).poller = ((Ref)this.ref).poller.refresh(((Ref)newRef).items);
        this.ref = newRef;
    }

    public int hashCode() {
        return this.uniqueKey.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Chooser otherChooser = (Chooser)other;
        if (this.uniqueKey == null) {
            if (otherChooser.getUniqueKey() != null) {
                return false;
            }
        } else {
            if (otherChooser.getUniqueKey() == null) {
                return false;
            }
            if (!this.uniqueKey.equals(otherChooser.getUniqueKey())) {
                return false;
            }
        }
        if (this.ref == null) {
            return otherChooser.getRef() == null;
        }
        if (otherChooser.getRef() == null) {
            return false;
        }
        return this.ref.equals(otherChooser.getRef());
    }

    public class Ref<T> {
        private List<Pair<T>> itemsWithWeight = new ArrayList<Pair<T>>();
        private final List<T> items = new ArrayList<T>();
        private Poller<T> poller = new GenericPoller<T>(this.items);
        private double[] weights;

        public Ref(List<Pair<T>> itemsWithWeight) {
            this.itemsWithWeight = itemsWithWeight;
        }

        public void refresh() {
            Double originWeightSum = 0.0;
            for (Pair<T> item : this.itemsWithWeight) {
                double weight = item.weight();
                if (weight <= 0.0) continue;
                this.items.add(item.item());
                if (Double.isInfinite(weight)) {
                    weight = 10000.0;
                }
                if (Double.isNaN(weight)) {
                    weight = 1.0;
                }
                originWeightSum = originWeightSum + weight;
            }
            double[] exactWeights = new double[this.items.size()];
            int index = 0;
            for (Pair<T> item : this.itemsWithWeight) {
                double singleWeight = item.weight();
                if (singleWeight <= 0.0) continue;
                exactWeights[index++] = singleWeight / originWeightSum;
            }
            this.weights = new double[this.items.size()];
            double randomRange = 0.0;
            for (int i = 0; i < index; ++i) {
                this.weights[i] = randomRange + exactWeights[i];
                randomRange += exactWeights[i];
            }
            double doublePrecisionDelta = 1.0E-4;
            if (index == 0 || Math.abs(this.weights[index - 1] - 1.0) < doublePrecisionDelta) {
                return;
            }
            throw new IllegalStateException("Cumulative Weight calculate wrong , the sum of probabilities does not equals 1.");
        }

        public int hashCode() {
            return this.itemsWithWeight.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            if (!other.getClass().getGenericInterfaces()[0].equals(this.getClass().getGenericInterfaces()[0])) {
                return false;
            }
            Ref otherRef = (Ref)other;
            if (this.itemsWithWeight == null) {
                return otherRef.itemsWithWeight == null;
            }
            if (otherRef.itemsWithWeight == null) {
                return false;
            }
            return this.itemsWithWeight.equals(otherRef.itemsWithWeight);
        }
    }
}

