/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.cache.builder;

import com.alibaba.nacos.common.cache.Cache;
import com.alibaba.nacos.common.cache.decorators.AutoExpireCache;
import com.alibaba.nacos.common.cache.decorators.LruCache;
import com.alibaba.nacos.common.cache.decorators.SynchronizedCache;
import com.alibaba.nacos.common.cache.impl.SimpleCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class CacheBuilder<K, V> {
    private static final int DEFAULT_MAXIMUMSIZE = 1024;
    private static final int DEFAULT_INITIALIZE_CAPACITY = 1024;
    private static final int DEFAULT_EXPIRE_NANOS = -1;
    private long expireNanos = -1L;
    private int maximumSize = 1024;
    private int initializeCapacity = 1024;
    private boolean sync = false;
    private boolean lru = false;

    public static CacheBuilder builder() {
        return new CacheBuilder();
    }

    public CacheBuilder expireNanos(long duration, TimeUnit unit) {
        this.checkExpireNanos(duration, unit);
        this.expireNanos = unit.toNanos(duration);
        return this;
    }

    private void checkExpireNanos(long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration cannot be negative");
        }
        if (Objects.isNull((Object)unit)) {
            throw new IllegalArgumentException("unit cannot be null");
        }
    }

    public CacheBuilder<K, V> maximumSize(int maximumSize) {
        if (maximumSize < 0) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        this.maximumSize = maximumSize;
        return this;
    }

    public CacheBuilder<K, V> sync(boolean sync) {
        this.sync = sync;
        return this;
    }

    public CacheBuilder<K, V> lru(boolean lru) {
        this.lru = lru;
        return this;
    }

    public CacheBuilder<K, V> initializeCapacity(int initializeCapacity) {
        if (initializeCapacity < 0) {
            throw new IllegalArgumentException("initializeCapacity cannot be negative");
        }
        this.initializeCapacity = initializeCapacity;
        return this;
    }

    public Cache<K, V> build() {
        Cache cache = new SimpleCache(this.initializeCapacity);
        if (this.lru) {
            cache = new LruCache(cache, this.maximumSize);
        }
        if (this.expireNanos != -1L) {
            cache = new AutoExpireCache(cache, this.expireNanos);
        }
        if (this.sync) {
            cache = new SynchronizedCache(cache);
        }
        return cache;
    }
}

