/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter;

import com.sun.star.lang.XComponent;
import com.sun.star.util.XRefreshable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.filter.UnmodifiableFilterChain;
import org.jodconverter.local.office.utils.Lo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshFilter.class);
    public static final RefreshFilter REFRESH = new RefreshFilter(false);
    public static final RefreshFilter LAST_REFRESH = new RefreshFilter(true);
    public static final FilterChain CHAIN = new UnmodifiableFilterChain(LAST_REFRESH);
    private final boolean lastFilter;

    public RefreshFilter() {
        this(false);
    }

    public RefreshFilter(boolean lastFilter) {
        this.lastFilter = lastFilter;
    }

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        Lo.qiOptional(XRefreshable.class, document).ifPresent(XRefreshable::refresh);
        if (!this.lastFilter) {
            LOGGER.debug("Applying the RefreshFilter");
            chain.doFilter(context, document);
        }
    }
}

