/**
 * Copyright (c) 2014-2016, Data Geekery GmbH, contact@datageekery.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jooq.lambda;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;

/**
 * @author Lukas Eder
 */
class WindowSpecificationImpl<T> implements WindowSpecification<T> {

    private final Function<? super T, ?> partition;
    private final Comparator<? super T> order;
    private final long lower;
    private final long upper;

    WindowSpecificationImpl(Function<? super T, ?> partition, Comparator<? super T> order, long lower, long upper) {
        this.partition = partition;
        this.order = order;
        this.lower = lower;
        this.upper = upper;
    }
    
    @Override
    public Function<? super T, ?> partition() {
        return partition;
    }

    @Override
    public Optional<Comparator<? super T>> order() {
        return Optional.ofNullable(order);
    }

    @Override
    public long lower() {
        return lower;
    }

    @Override
    public long upper() {
        return upper;
    }
}
