/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.NoopAnnotator;
import org.jsonschema2pojo.SourceType;
import org.jsonschema2pojo.cli.ClassConverter;

public class Arguments
implements GenerationConfig {
    @Parameter(names={"-h", "--help"}, description="Print help information and exit")
    private boolean showHelp = false;
    @Parameter(names={"-p", "--package"}, description="A java package used for generated types")
    private String targetPackage;
    @Parameter(names={"-t", "--target"}, description="The target directory into which generated types will be written", required=true)
    private File targetDirectory;
    @Parameter(names={"-s", "--source"}, description="The source file(s) or directory(ies) from which JSON Schema will be read", required=true, converter=FileConverter.class)
    private List<File> sourcePaths;
    @Parameter(names={"-b", "--generate-builders"}, description="Generate builder-style methods as well as setters")
    private boolean generateBuilderMethods = false;
    @Parameter(names={"-P", "--use-primitives"}, description="Use primitives instead of wrapper types for bean properties")
    private boolean usePrimitives = false;
    @Parameter(names={"-d", "--word-delimiters"}, description="The characters that should be considered as word delimiters when creating Java Bean property names from JSON property names")
    private String propertyWordDelimiters = "- _";
    @Parameter(names={"-l", "--long-integers"}, description="Use long (or Long) instead of int (or Integer) when the JSON Schema type 'integer' is encountered")
    private boolean useLongIntegers = false;
    @Parameter(names={"-f", "--float-numbers"}, description="Use float (or Float) instead of double (or Double) when the JSON Schema type 'number' is encountered")
    private boolean useFloatNumbers = false;
    @Parameter(names={"-E", "--omit-hashcode-and-equals"}, description="Omit hashCode and equals methods in the generated Java types")
    private boolean omitHashcodeAndEquals = false;
    @Parameter(names={"-S", "--omit-tostring"}, description="Omit the toString method in the generated Java types")
    private boolean omitToString = false;
    @Parameter(names={"-a", "--annotation-style"})
    private AnnotationStyle annotationStyle = AnnotationStyle.JACKSON;
    @Parameter(names={"-A", "--custom-annotator"}, description="The fully qualified class name of referring to a custom annotator class that implements org.jsonschema2pojo.Annotator and will be used in addition to the --annotation-style. If you want to use a custom annotator alone, set --annotation-style to none", converter=ClassConverter.class)
    private Class<? extends Annotator> customAnnotator = NoopAnnotator.class;
    @Parameter(names={"-303", "--jsr303-annotations"}, description="Add JSR-303 annotations to generated Java types.")
    private boolean includeJsr303Annotations = false;
    @Parameter(names={"-T", "--source-type"})
    private SourceType sourceType = SourceType.JSONSCHEMA;
    @Parameter(names={"-R", "--remove-old-output"}, description="Whether to empty the target directory before generation occurs, to clear out all source files that have been generated previously (indiscriminately deletes all files and folders).")
    private boolean removeOldOutput = false;
    @Parameter(names={"-e", "--output-encoding"}, description="The character encoding that should be used when writing the generated Java source files")
    private String outputEncoding = "UTF-8";
    @Parameter(names={"-j", "--joda-dates"}, description="Whether to use org.joda.time.DateTime instead of java.util.Date when adding date type fields to generated Java types.")
    private boolean useJodaDates = false;
    private static final int EXIT_OKAY = 0;
    private static final int EXIT_ERROR = 1;

    public Arguments parse(String[] args) {
        JCommander jCommander = new JCommander((Object)this);
        jCommander.setProgramName("jsonschema2pojo");
        try {
            jCommander.parse(args);
            if (this.showHelp) {
                jCommander.usage();
                this.exit(0);
            }
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            jCommander.usage();
            this.exit(1);
        }
        return this;
    }

    public Iterator<File> getSource() {
        return this.sourcePaths.iterator();
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilderMethods;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public char[] getPropertyWordDelimiters() {
        return StringUtils.defaultString((String)this.propertyWordDelimiters).toCharArray();
    }

    public boolean isUseLongIntegers() {
        return this.useLongIntegers;
    }

    public boolean isUseDoubleNumbers() {
        return !this.useFloatNumbers;
    }

    public boolean isIncludeHashcodeAndEquals() {
        return !this.omitHashcodeAndEquals;
    }

    public boolean isIncludeToString() {
        return !this.omitToString;
    }

    public AnnotationStyle getAnnotationStyle() {
        return this.annotationStyle;
    }

    public Class<? extends Annotator> getCustomAnnotator() {
        return this.customAnnotator;
    }

    public boolean isIncludeJsr303Annotations() {
        return this.includeJsr303Annotations;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public boolean isRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean isUseJodaDates() {
        return this.useJodaDates;
    }

    protected void exit(int status) {
        System.exit(status);
    }
}

