/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.apache;

import java.time.Duration;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.LdapException;
import org.ldaptive.LdapURL;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.apache.ApacheLdapConnection;
import org.ldaptive.provider.apache.ApacheLdapProviderConfig;

public class ApacheLdapConnectionFactory
extends AbstractProviderConnectionFactory<ApacheLdapProviderConfig> {
    private final LdapConnectionConfig ldapConnectionConfig;
    private final boolean useStartTLS;
    private final Duration responseTimeOut;

    public ApacheLdapConnectionFactory(String url, ConnectionStrategy strategy, ApacheLdapProviderConfig config, LdapConnectionConfig lcc, boolean tls, Duration timeOut) {
        super(url, strategy, (ProviderConfig)config);
        this.ldapConnectionConfig = lcc;
        this.useStartTLS = tls;
        this.responseTimeOut = timeOut;
    }

    protected ApacheLdapConnection createInternal(String url) throws LdapException {
        LdapURL ldapUrl = new LdapURL(url);
        this.ldapConnectionConfig.setLdapHost(ldapUrl.getLastEntry().getHostname());
        this.ldapConnectionConfig.setLdapPort(ldapUrl.getLastEntry().getPort());
        ApacheLdapConnection conn = null;
        boolean closeConn = false;
        try {
            LdapNetworkConnection lc = new LdapNetworkConnection(this.ldapConnectionConfig);
            conn = new ApacheLdapConnection(lc, (ApacheLdapProviderConfig)this.getProviderConfig());
            lc.connect();
            if (this.useStartTLS) {
                lc.startTls();
            }
            if (this.responseTimeOut != null) {
                lc.setTimeOut(this.responseTimeOut.toMillis());
            }
        }
        catch (LdapOperationException e) {
            closeConn = true;
            throw new ConnectionException((Exception)((Object)e), ResultCode.valueOf((int)e.getResultCode().getValue()));
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            closeConn = true;
            throw new ConnectionException((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            closeConn = true;
            throw e;
        }
        finally {
            if (closeConn) {
                try {
                    if (conn != null) {
                        conn.close(null);
                    }
                }
                catch (LdapException e) {
                    this.logger.debug("Problem tearing down connection", (Throwable)e);
                }
            }
        }
        return conn;
    }
}

