/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.controls.SortKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.LdapAttribute;
import org.ldaptive.SearchEntry;
import org.ldaptive.SortBehavior;
import org.ldaptive.control.ResponseControl;

public class UnboundIDUtils {
    private final SortBehavior sortBehavior;
    private List<String> binaryAttrs;

    public UnboundIDUtils() {
        this.sortBehavior = SortBehavior.getDefaultSortBehavior();
    }

    public UnboundIDUtils(SortBehavior sb) {
        this.sortBehavior = sb;
    }

    public List<String> getBinaryAttributes() {
        return this.binaryAttrs;
    }

    public void setBinaryAttributes(String[] s) {
        if (s != null) {
            this.binaryAttrs = Arrays.asList(s);
        }
    }

    public Attribute fromLdapAttribute(LdapAttribute la) {
        Attribute attribute = la.isBinary() ? new Attribute(la.getName(), (byte[][])la.getBinaryValues().toArray((T[])new byte[la.size()][])) : new Attribute(la.getName(), la.getStringValues());
        return attribute;
    }

    public LdapAttribute toLdapAttribute(Attribute a) {
        boolean isBinary = false;
        if (a.getOptions().contains("binary")) {
            isBinary = true;
        } else if (this.binaryAttrs != null && this.binaryAttrs.contains(a.getName())) {
            isBinary = true;
        }
        LdapAttribute la = new LdapAttribute(this.sortBehavior, isBinary);
        la.setName(a.getName());
        if (isBinary) {
            la.addBinaryValue(a.getValueByteArrays());
        } else {
            la.addStringValue(a.getValues());
        }
        return la;
    }

    public Attribute[] fromLdapAttributes(Collection<LdapAttribute> c) {
        return (Attribute[])c.stream().map(this::fromLdapAttribute).toArray(Attribute[]::new);
    }

    public SearchEntry toSearchEntry(Entry e, ResponseControl[] c, int id) {
        SearchEntry se = new SearchEntry(id, c, this.sortBehavior);
        se.setDn(e.getDN());
        for (Attribute a : e.getAttributes()) {
            se.addAttribute(new LdapAttribute[]{this.toLdapAttribute(a)});
        }
        return se;
    }

    public Modification[] fromAttributeModification(AttributeModification[] am) {
        Modification[] mods = new Modification[am.length];
        for (int i = 0; i < am.length; ++i) {
            Attribute a = this.fromLdapAttribute(am[i].getAttribute());
            mods[i] = am[i].getAttribute().isBinary() ? new Modification(UnboundIDUtils.getModificationType(am[i].getAttributeModificationType()), a.getName(), a.getValueByteArrays()) : new Modification(UnboundIDUtils.getModificationType(am[i].getAttributeModificationType()), a.getName(), a.getValues());
        }
        return mods;
    }

    public static SortKey[] fromSortKey(org.ldaptive.control.SortKey[] sk) {
        SortKey[] keys = null;
        if (sk != null) {
            keys = new SortKey[sk.length];
            for (int i = 0; i < sk.length; ++i) {
                keys[i] = new SortKey(sk[i].getAttributeDescription(), sk[i].getMatchingRuleId(), sk[i].getReverseOrder());
            }
        }
        return keys;
    }

    protected static ModificationType getModificationType(AttributeModificationType am) {
        ModificationType type = null;
        if (am == AttributeModificationType.ADD) {
            type = ModificationType.ADD;
        } else if (am == AttributeModificationType.REMOVE) {
            type = ModificationType.DELETE;
        } else if (am == AttributeModificationType.REPLACE) {
            type = ModificationType.REPLACE;
        }
        return type;
    }
}

