/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.common.BuilderType;
import org.mapstruct.ap.internal.model.source.BeanMapping;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.prism.BuilderPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class BuilderFinisherMethodResolver {
    private static final String DEFAULT_BUILD_METHOD_NAME = "build";

    private BuilderFinisherMethodResolver() {
    }

    public static MethodReference getBuilderFinisherMethod(Method method, BuilderType builderType, MappingBuilderContext ctx) {
        Collection<ExecutableElement> buildMethods = builderType.getBuildMethods();
        if (buildMethods.isEmpty()) {
            return null;
        }
        BuilderPrism builderMapping = BuilderFinisherMethodResolver.builderMappingPrism(method, ctx);
        if (builderMapping == null && buildMethods.size() == 1) {
            return MethodReference.forMethodCall(Collections.first(buildMethods).getSimpleName().toString());
        }
        String buildMethodPattern = DEFAULT_BUILD_METHOD_NAME;
        if (builderMapping != null) {
            buildMethodPattern = builderMapping.buildMethod();
        }
        for (ExecutableElement buildMethod : buildMethods) {
            String methodName = buildMethod.getSimpleName().toString();
            if (!methodName.matches(buildMethodPattern)) continue;
            return MethodReference.forMethodCall(methodName);
        }
        if (builderMapping == null) {
            ctx.getMessager().printMessage((Element)method.getExecutable(), Message.BUILDER_NO_BUILD_METHOD_FOUND_DEFAULT, buildMethodPattern, builderType.getBuilder(), builderType.getBuildingType(), Strings.join(buildMethods, ", "));
        } else {
            ctx.getMessager().printMessage((Element)method.getExecutable(), builderMapping.mirror, Message.BUILDER_NO_BUILD_METHOD_FOUND, buildMethodPattern, builderType.getBuilder(), builderType.getBuildingType(), Strings.join(buildMethods, ", "));
        }
        return null;
    }

    private static BuilderPrism builderMappingPrism(Method method, MappingBuilderContext ctx) {
        BeanMapping beanMapping = method.getMappingOptions().getBeanMapping();
        if (beanMapping != null && beanMapping.getBuilder() != null) {
            return beanMapping.getBuilder();
        }
        return MapperConfiguration.getInstanceOn(ctx.getMapperTypeElement()).getBuilderPrism();
    }
}

