/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor.creation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.conversion.ConversionProvider;
import org.mapstruct.ap.internal.conversion.Conversions;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.HelperMethod;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.SupportingField;
import org.mapstruct.ap.internal.model.SupportingMappingMethod;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.DefaultConversionContext;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMappingMethods;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelectors;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.prism.ReportingPolicyPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Strings;

public class MappingResolverImpl
implements MappingBuilderContext.MappingResolver {
    private final FormattingMessager messager;
    private final Types typeUtils;
    private final TypeFactory typeFactory;
    private final List<Method> sourceModel;
    private final List<MapperReference> mapperReferences;
    private final Conversions conversions;
    private final BuiltInMappingMethods builtInMethods;
    private final MethodSelectors methodSelectors;
    private final Set<SupportingMappingMethod> usedSupportedMappings = new HashSet<SupportingMappingMethod>();

    public MappingResolverImpl(FormattingMessager messager, Elements elementUtils, Types typeUtils, TypeFactory typeFactory, List<Method> sourceModel, List<MapperReference> mapperReferences) {
        this.messager = messager;
        this.typeUtils = typeUtils;
        this.typeFactory = typeFactory;
        this.sourceModel = sourceModel;
        this.mapperReferences = mapperReferences;
        this.conversions = new Conversions(elementUtils, typeFactory);
        this.builtInMethods = new BuiltInMappingMethods(typeFactory);
        this.methodSelectors = new MethodSelectors(typeUtils, elementUtils, typeFactory);
    }

    @Override
    public Assignment getTargetAssignment(Method mappingMethod, Type targetType, String targetPropertyName, FormattingParameters formattingParameters, SelectionParameters selectionParameters, SourceRHS sourceRHS, boolean preferUpdateMapping, AnnotationMirror positionHint) {
        SelectionCriteria criteria = SelectionCriteria.forMappingMethods(selectionParameters, targetPropertyName, preferUpdateMapping);
        ResolvingAttempt attempt = new ResolvingAttempt(this.sourceModel, mappingMethod, formattingParameters, sourceRHS, criteria, positionHint);
        return attempt.getTargetAssignment(sourceRHS.getSourceTypeForMatching(), targetType);
    }

    @Override
    public Set<SupportingMappingMethod> getUsedSupportedMappings() {
        return this.usedSupportedMappings;
    }

    private MapperReference findMapperReference(Method method) {
        for (MapperReference ref : this.mapperReferences) {
            if (!ref.getType().equals(method.getDeclaringMapper())) continue;
            ref.setUsed(ref.isUsed() || !method.isStatic());
            ref.setTypeRequiresImport(true);
            return ref;
        }
        return null;
    }

    private static class ConversionAssignment {
        private final Type sourceType;
        private final Type targetType;
        private final Assignment assignment;

        ConversionAssignment(Type sourceType, Type targetType, Assignment assignment) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.assignment = assignment;
        }

        Assignment getAssignment() {
            return this.assignment;
        }

        void reportMessageWhenNarrowing(FormattingMessager messager, ResolvingAttempt attempt) {
            if (NativeTypes.isNarrowing(this.sourceType.getFullyQualifiedName(), this.targetType.getFullyQualifiedName())) {
                ReportingPolicyPrism policy = attempt.mappingMethod.getMapperConfiguration().typeConversionPolicy();
                if (policy == ReportingPolicyPrism.WARN) {
                    this.report(messager, attempt, Message.CONVERSION_LOSSY_WARNING);
                } else if (policy == ReportingPolicyPrism.ERROR) {
                    this.report(messager, attempt, Message.CONVERSION_LOSSY_ERROR);
                }
            }
        }

        private void report(FormattingMessager messager, ResolvingAttempt attempt, Message message) {
            messager.printMessage((Element)attempt.mappingMethod.getExecutable(), attempt.positionHint, message, attempt.sourceRHS.getSourceErrorMessagePart(), this.sourceType.toString(), this.targetType.toString());
        }
    }

    private class ResolvingAttempt {
        private final Method mappingMethod;
        private final List<Method> methods;
        private final SelectionCriteria selectionCriteria;
        private final SourceRHS sourceRHS;
        private final boolean savedPreferUpdateMapping;
        private final FormattingParameters formattingParameters;
        private final AnnotationMirror positionHint;
        private final Set<SupportingMappingMethod> supportingMethodCandidates;

        private ResolvingAttempt(List<Method> sourceModel, Method mappingMethod, FormattingParameters formattingParameters, SourceRHS sourceRHS, SelectionCriteria criteria, AnnotationMirror positionHint) {
            this.mappingMethod = mappingMethod;
            this.methods = this.filterPossibleCandidateMethods(sourceModel);
            this.formattingParameters = formattingParameters == null ? FormattingParameters.EMPTY : formattingParameters;
            this.sourceRHS = sourceRHS;
            this.supportingMethodCandidates = new HashSet<SupportingMappingMethod>();
            this.selectionCriteria = criteria;
            this.savedPreferUpdateMapping = criteria.isPreferUpdateMapping();
            this.positionHint = positionHint;
        }

        private <T extends Method> List<T> filterPossibleCandidateMethods(List<T> candidateMethods) {
            ArrayList<Method> result = new ArrayList<Method>(candidateMethods.size());
            for (Method candidate : candidateMethods) {
                if (!this.isCandidateForMapping(candidate)) continue;
                result.add(candidate);
            }
            return result;
        }

        private Assignment getTargetAssignment(Type sourceType, Type targetType) {
            Assignment referencedMethod = this.resolveViaMethod(sourceType, targetType, false);
            if (referencedMethod != null) {
                referencedMethod.setAssignment(this.sourceRHS);
                return referencedMethod;
            }
            if (sourceType.isAssignableTo(targetType) || this.isAssignableThroughCollectionCopyConstructor(sourceType, targetType)) {
                SourceRHS simpleAssignment = this.sourceRHS;
                return simpleAssignment;
            }
            if (sourceType.isLiteral() && "java.lang.String".equals(sourceType.getFullyQualifiedName()) && targetType.isNative()) {
                return null;
            }
            ConversionAssignment conversion = this.resolveViaConversion(sourceType, targetType);
            if (conversion != null) {
                conversion.reportMessageWhenNarrowing(MappingResolverImpl.this.messager, this);
                conversion.getAssignment().setAssignment(this.sourceRHS);
                return conversion.getAssignment();
            }
            Assignment builtInMethod = this.resolveViaBuiltInMethod(sourceType, targetType);
            if (builtInMethod != null) {
                builtInMethod.setAssignment(this.sourceRHS);
                MappingResolverImpl.this.usedSupportedMappings.addAll(this.supportingMethodCandidates);
                return builtInMethod;
            }
            referencedMethod = this.resolveViaMethodAndMethod(sourceType, targetType);
            if (referencedMethod != null) {
                MappingResolverImpl.this.usedSupportedMappings.addAll(this.supportingMethodCandidates);
                return referencedMethod;
            }
            referencedMethod = this.resolveViaConversionAndMethod(sourceType, targetType);
            if (referencedMethod != null) {
                MappingResolverImpl.this.usedSupportedMappings.addAll(this.supportingMethodCandidates);
                return referencedMethod;
            }
            this.selectionCriteria.setPreferUpdateMapping(false);
            conversion = this.resolveViaMethodAndConversion(sourceType, targetType);
            if (conversion != null) {
                MappingResolverImpl.this.usedSupportedMappings.addAll(this.supportingMethodCandidates);
                return conversion.getAssignment();
            }
            return null;
        }

        private ConversionAssignment resolveViaConversion(Type sourceType, Type targetType) {
            ConversionProvider conversionProvider = MappingResolverImpl.this.conversions.getConversion(sourceType, targetType);
            if (conversionProvider == null) {
                return null;
            }
            DefaultConversionContext ctx = new DefaultConversionContext(MappingResolverImpl.this.typeFactory, MappingResolverImpl.this.messager, sourceType, targetType, this.formattingParameters);
            for (HelperMethod helperMethod : conversionProvider.getRequiredHelperMethods(ctx)) {
                MappingResolverImpl.this.usedSupportedMappings.add(new SupportingMappingMethod(helperMethod));
            }
            Assignment conversion = conversionProvider.to(ctx);
            if (conversion != null) {
                return new ConversionAssignment(sourceType, targetType, conversionProvider.to(ctx));
            }
            return null;
        }

        private Assignment resolveViaMethod(Type sourceType, Type targetType, boolean considerBuiltInMethods) {
            SelectedMethod<Method> matchingSourceMethod = this.getBestMatch(this.methods, sourceType, targetType);
            if (matchingSourceMethod != null) {
                return this.getMappingMethodReference(matchingSourceMethod, targetType);
            }
            if (considerBuiltInMethods) {
                return this.resolveViaBuiltInMethod(sourceType, targetType);
            }
            return null;
        }

        private Assignment resolveViaBuiltInMethod(Type sourceType, Type targetType) {
            SelectedMethod<BuiltInMethod> matchingBuiltInMethod = this.getBestMatch(MappingResolverImpl.this.builtInMethods.getBuiltInMethods(), sourceType, targetType);
            if (matchingBuiltInMethod != null) {
                HashSet<Field> allUsedFields = new HashSet<Field>(MappingResolverImpl.this.mapperReferences);
                SupportingField.addAllFieldsIn(this.supportingMethodCandidates, allUsedFields);
                SupportingMappingMethod supportingMappingMethod = new SupportingMappingMethod(matchingBuiltInMethod.getMethod(), allUsedFields);
                this.supportingMethodCandidates.add(supportingMappingMethod);
                DefaultConversionContext ctx = new DefaultConversionContext(MappingResolverImpl.this.typeFactory, MappingResolverImpl.this.messager, sourceType, targetType, this.formattingParameters);
                MethodReference methodReference = MethodReference.forBuiltInMethod(matchingBuiltInMethod.getMethod(), ctx);
                methodReference.setAssignment(this.sourceRHS);
                return methodReference;
            }
            return null;
        }

        private Assignment resolveViaMethodAndMethod(Type sourceType, Type targetType) {
            ArrayList<Method> methodYCandidates = new ArrayList<Method>(this.methods);
            methodYCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            Assignment methodRefY = null;
            for (Method methodYCandidate : methodYCandidates) {
                methodRefY = this.resolveViaMethod(methodYCandidate.getSourceParameters().get(0).getType(), targetType, true);
                if (methodRefY == null) continue;
                this.selectionCriteria.setPreferUpdateMapping(false);
                Assignment methodRefX = this.resolveViaMethod(sourceType, methodYCandidate.getSourceParameters().get(0).getType(), true);
                this.selectionCriteria.setPreferUpdateMapping(this.savedPreferUpdateMapping);
                if (methodRefX != null) {
                    methodRefY.setAssignment(methodRefX);
                    methodRefX.setAssignment(this.sourceRHS);
                    break;
                }
                this.supportingMethodCandidates.clear();
                methodRefY = null;
            }
            return methodRefY;
        }

        private Assignment resolveViaConversionAndMethod(Type sourceType, Type targetType) {
            ArrayList<Method> methodYCandidates = new ArrayList<Method>(this.methods);
            methodYCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            Assignment methodRefY = null;
            for (Method methodYCandidate : methodYCandidates) {
                methodRefY = this.resolveViaMethod(methodYCandidate.getSourceParameters().get(0).getType(), targetType, true);
                if (methodRefY == null) continue;
                Type targetTypeX = methodYCandidate.getSourceParameters().get(0).getType();
                ConversionAssignment conversionXRef = this.resolveViaConversion(sourceType, targetTypeX);
                if (conversionXRef != null) {
                    methodRefY.setAssignment(conversionXRef.getAssignment());
                    conversionXRef.getAssignment().setAssignment(this.sourceRHS);
                    conversionXRef.reportMessageWhenNarrowing(MappingResolverImpl.this.messager, this);
                    break;
                }
                this.supportingMethodCandidates.clear();
                methodRefY = null;
            }
            return methodRefY;
        }

        private ConversionAssignment resolveViaMethodAndConversion(Type sourceType, Type targetType) {
            ArrayList<Method> methodXCandidates = new ArrayList<Method>(this.methods);
            methodXCandidates.addAll(MappingResolverImpl.this.builtInMethods.getBuiltInMethods());
            ConversionAssignment conversionYRef = null;
            for (Method methodXCandidate : methodXCandidates) {
                Assignment methodRefX;
                if (methodXCandidate.getMappingTargetParameter() != null || (methodRefX = this.resolveViaMethod(sourceType, methodXCandidate.getReturnType(), true)) == null) continue;
                conversionYRef = this.resolveViaConversion(methodXCandidate.getReturnType(), targetType);
                if (conversionYRef != null) {
                    conversionYRef.getAssignment().setAssignment(methodRefX);
                    methodRefX.setAssignment(this.sourceRHS);
                    conversionYRef.reportMessageWhenNarrowing(MappingResolverImpl.this.messager, this);
                    break;
                }
                this.supportingMethodCandidates.clear();
                conversionYRef = null;
            }
            return conversionYRef;
        }

        private boolean isCandidateForMapping(Method methodCandidate) {
            return this.isCreateMethodForMapping(methodCandidate) || this.isUpdateMethodForMapping(methodCandidate);
        }

        private boolean isCreateMethodForMapping(Method methodCandidate) {
            return methodCandidate.getSourceParameters().size() == 1 && !methodCandidate.getReturnType().isVoid() && methodCandidate.getMappingTargetParameter() == null && !methodCandidate.isLifecycleCallbackMethod();
        }

        private boolean isUpdateMethodForMapping(Method methodCandidate) {
            return methodCandidate.getSourceParameters().size() == 1 && methodCandidate.getMappingTargetParameter() != null && !methodCandidate.isLifecycleCallbackMethod();
        }

        private <T extends Method> SelectedMethod<T> getBestMatch(List<T> methods, Type sourceType, Type returnType) {
            List<SelectedMethod<T>> candidates = MappingResolverImpl.this.methodSelectors.getMatchingMethods(this.mappingMethod, methods, java.util.Collections.singletonList(sourceType), returnType, this.selectionCriteria);
            if (candidates.size() > 1) {
                if (this.sourceRHS.getSourceErrorMessagePart() != null) {
                    MappingResolverImpl.this.messager.printMessage((Element)this.mappingMethod.getExecutable(), this.positionHint, Message.GENERAL_AMBIGIOUS_MAPPING_METHOD, this.sourceRHS.getSourceErrorMessagePart(), returnType, Strings.join(candidates, ", "));
                } else {
                    MappingResolverImpl.this.messager.printMessage((Element)this.mappingMethod.getExecutable(), this.positionHint, Message.GENERAL_AMBIGIOUS_FACTORY_METHOD, returnType, Strings.join(candidates, ", "));
                }
            }
            if (!candidates.isEmpty()) {
                return Collections.first(candidates);
            }
            return null;
        }

        private Assignment getMappingMethodReference(SelectedMethod<Method> method, Type targetType) {
            MapperReference mapperReference = MappingResolverImpl.this.findMapperReference(method.getMethod());
            return MethodReference.forMapperReference(method.getMethod(), mapperReference, method.getParameterBindings());
        }

        private boolean isAssignableThroughCollectionCopyConstructor(Type sourceType, Type targetType) {
            boolean bothCollectionOrMap = false;
            if (sourceType.isCollectionType() && targetType.isCollectionType() || sourceType.isMapType() && targetType.isMapType()) {
                bothCollectionOrMap = true;
            }
            if (bothCollectionOrMap) {
                return this.hasCompatibleCopyConstructor(sourceType, targetType.getImplementationType() != null ? targetType.getImplementationType() : targetType);
            }
            return false;
        }

        private boolean hasCompatibleCopyConstructor(Type sourceType, Type targetType) {
            if (targetType.isPrimitive()) {
                return false;
            }
            List<ExecutableElement> targetTypeConstructors = ElementFilter.constructorsIn(targetType.getTypeElement().getEnclosedElements());
            for (ExecutableElement constructor : targetTypeConstructors) {
                if (constructor.getParameters().size() != 1) continue;
                ExecutableType typedConstructor = (ExecutableType)MappingResolverImpl.this.typeUtils.asMemberOf((DeclaredType)targetType.getTypeMirror(), constructor);
                TypeMirror parameterType = Collections.first(typedConstructor.getParameterTypes());
                if (parameterType.getKind() == TypeKind.DECLARED) {
                    DeclaredType p = (DeclaredType)parameterType;
                    ArrayList<TypeMirror> typeArguments = new ArrayList<TypeMirror>(p.getTypeArguments().size());
                    for (TypeMirror typeMirror : p.getTypeArguments()) {
                        typeArguments.add(MappingResolverImpl.this.typeFactory.getTypeBound(typeMirror));
                    }
                    parameterType = MappingResolverImpl.this.typeUtils.getDeclaredType((TypeElement)p.asElement(), typeArguments.toArray(new TypeMirror[typeArguments.size()]));
                }
                if (!MappingResolverImpl.this.typeUtils.isAssignable(sourceType.getTypeMirror(), parameterType)) continue;
                return true;
            }
            return false;
        }
    }
}

