/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.Operation;
import org.modeshape.schematic.internal.document.MutableDocument;

public class PutOperation
extends Operation {
    protected final String fieldName;
    protected final Object oldValue;
    protected final Object newValue;

    public PutOperation(Path parentPath, String fieldName, Object oldValue, Object newValue) {
        super(parentPath, HashCode.compute(parentPath, fieldName, newValue));
        this.fieldName = fieldName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public PutOperation clone() {
        return new PutOperation(this.getParentPath(), this.fieldName, this.cloneValue(this.oldValue), this.cloneValue(this.newValue));
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        if (this.oldValue == null) {
            parent.remove(this.fieldName);
        } else {
            parent.put(this.fieldName, this.oldValue);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        parent.put(this.fieldName, this.newValue);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PutOperation) {
            PutOperation other = (PutOperation)obj;
            return this.equalsIfNotNull(this.fieldName, other.fieldName) && this.equalsIfNotNull(this.newValue, other.newValue) && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }

    public String toString() {
        return "Put at '" + this.parentPath + "' the '" + this.fieldName + "' field value '" + this.newValue + (this.oldValue != null ? "' (replaces '" + this.oldValue + "')" : "'");
    }
}

