/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.ArrayOperation;
import org.modeshape.schematic.internal.document.BasicArray;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;

public class RemoveAllValuesOperation
extends ArrayOperation {
    protected final Collection<?> values;
    protected transient int[] actualIndexes;

    public RemoveAllValuesOperation(Path path, Collection<?> values) {
        super(path, HashCode.compute(path, values));
        this.values = values;
    }

    @Override
    public RemoveAllValuesOperation clone() {
        return new RemoveAllValuesOperation(this.getParentPath(), this.cloneValues(this.values));
    }

    public Collection<?> getValuesToRemove() {
        return this.values;
    }

    public synchronized List<Array.Entry> getRemovedEntries() {
        ArrayList<Array.Entry> entries = new ArrayList<Array.Entry>(this.values.size());
        Iterator<?> valueIter = this.values.iterator();
        for (int i = 0; i != this.actualIndexes.length; ++i) {
            int index = this.actualIndexes[i];
            Object value = valueIter.next();
            entries.add(new BasicArray.BasicEntry(index, value));
        }
        return entries;
    }

    @Override
    public synchronized void rollback(MutableDocument delegate) {
        if (this.actualIndexes != null) {
            MutableArray array = this.mutableParent(delegate);
            int i = 0;
            for (Object value : this.values) {
                int index;
                if ((index = this.actualIndexes[i++]) == -1) continue;
                array.add(index, value);
            }
        }
    }

    @Override
    public synchronized void replay(MutableDocument delegate) {
        if (!this.values.isEmpty()) {
            this.actualIndexes = new int[this.values.size()];
            int i = 0;
            MutableArray array = this.mutableParent(delegate);
            for (Object value : this.values) {
                int actualIndex = array.indexOf(value);
                array.remove(actualIndex);
                this.actualIndexes[i++] = actualIndex;
            }
        } else {
            this.actualIndexes = null;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "Remove at '" + this.parentPath + "' the values: " + this.values;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoveAllValuesOperation) {
            RemoveAllValuesOperation other = (RemoveAllValuesOperation)obj;
            return this.equalsIfNotNull(this.values, other.values) && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }
}

