/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.ArrayOperation;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;

public class RemoveValueOperation
extends ArrayOperation {
    protected final Object value;
    protected transient int actualIndex = -1;

    public RemoveValueOperation(Path parentPath, Object value) {
        super(parentPath, HashCode.compute(parentPath, value));
        this.value = value;
    }

    @Override
    public RemoveValueOperation clone() {
        return new RemoveValueOperation(this.getParentPath(), this.cloneValue(this.value));
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.actualIndex > -1) {
            MutableArray array = this.mutableParent(delegate);
            array.add(this.actualIndex, this.value);
        }
    }

    public Object getRemovedValue() {
        return this.value;
    }

    public int getActualIndex() {
        return this.actualIndex;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.actualIndex = array.indexOf(this.value);
        array.remove(this.actualIndex);
    }

    public String toString() {
        return "Remove at '" + this.parentPath + "' the value '" + this.value + "'";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoveValueOperation) {
            RemoveValueOperation other = (RemoveValueOperation)obj;
            return this.equalsIfNotNull(this.value, other.value) && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }
}

