/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce3;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.reduce3.BaseReduce3Op;
import org.nd4j.linalg.api.ops.impl.reduce3.CosineSimilarity;

public class CosineDistance
extends BaseReduce3Op {
    public CosineDistance(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int ... dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public CosineDistance() {
    }

    public CosineDistance(INDArray x, INDArray y, INDArray z) {
        this(x, y, z, null);
    }

    public CosineDistance(INDArray x, INDArray y, INDArray z, int ... dimension) {
        super(x, y, z, dimension);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public CosineDistance(INDArray x, INDArray y, int ... dimension) {
        this(x, y, null, dimension);
    }

    public CosineDistance(INDArray x, INDArray y, INDArray z, boolean allDistances, int ... dimension) {
        this(x, y, z, dimension);
        this.isComplex = allDistances;
    }

    public CosineDistance(INDArray x, INDArray y, boolean allDistances, int ... dimension) {
        this(x, y, null, allDistances, dimension);
    }

    public CosineDistance(INDArray x, INDArray y, INDArray z, boolean keepDims, boolean allDistances, int ... dimensions) {
        super(x, y, z, keepDims, allDistances, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    @Override
    public int opNum() {
        return 5;
    }

    @Override
    public String opName() {
        return "cosinedistance";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        List<SDVariable> diff = CosineSimilarity.doDiff(this.sameDiff, this.larg(), this.rarg(), i_v1.get(0), this.keepDims, this.dimensions);
        return Arrays.asList(this.sameDiff.math.neg(diff.get(0)), this.sameDiff.math.neg(diff.get(1)));
    }
}

