/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.factory.Nd4j;

public class RGBtoGrayscaleDataSetPreProcessor
implements DataSetPreProcessor {
    private static final float RED_RATIO = 0.3f;
    private static final float GREEN_RATIO = 0.59f;
    private static final float BLUE_RATIO = 0.11f;

    @Override
    public void preProcess(DataSet dataSet) {
        Preconditions.checkNotNull((Object)dataSet, (String)"Encountered null dataSet");
        if (dataSet.isEmpty()) {
            return;
        }
        INDArray originalFeatures = dataSet.getFeatures();
        long[] originalShape = originalFeatures.shape();
        INDArray result = Nd4j.create(originalShape[0], originalShape[2], originalShape[3]);
        long numExamples = originalShape[0];
        for (long n = 0L; n < numExamples; ++n) {
            INDArray itemFeatures = originalFeatures.slice(n, 0);
            INDArray R = itemFeatures.slice(0L, 0);
            INDArray G = itemFeatures.slice(1L, 0);
            INDArray B = itemFeatures.slice(2L, 0);
            R.muli(Float.valueOf(0.3f));
            G.muli(Float.valueOf(0.59f));
            B.muli(Float.valueOf(0.11f));
            R.addi(G).addi(B);
            result.putSlice((int)n, R);
        }
        dataSet.setFeatures(result);
    }
}

