/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.IntPredicate;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.FileIsMappedException;
import org.neo4j.io.pagecache.impl.muninn.BackgroundThreadExecutor;
import org.neo4j.io.pagecache.impl.muninn.CacheLiveLockException;
import org.neo4j.io.pagecache.impl.muninn.EvictionTask;
import org.neo4j.io.pagecache.impl.muninn.FileMapping;
import org.neo4j.io.pagecache.impl.muninn.FreePage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.impl.muninn.VictimPageReference;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.unsafe.impl.internal.dragons.MemoryManager;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class MuninnPageCache
implements PageCache {
    public static final byte ZERO_BYTE = (byte)(FeatureToggles.flag(MuninnPageCache.class, (String)"brandedZeroByte", (boolean)false) ? 15 : 0);
    private static final int pagesToKeepFree = FeatureToggles.getInteger(MuninnPageCache.class, (String)"pagesToKeepFree", (int)30);
    private static final int cooperativeEvictionLiveLockThreshold = FeatureToggles.getInteger(MuninnPageCache.class, (String)"cooperativeEvictionLiveLockThreshold", (int)100);
    private static final IOException oomException = new IOException("OutOfMemoryError encountered in the page cache background eviction thread");
    private static final long freelistOffset = UnsafeUtil.getFieldOffset(MuninnPageCache.class, (String)"freelist");
    private static final FreePage shutdownSignal = new FreePage(0L);
    private static final AtomicInteger pageCacheIdCounter = new AtomicInteger();
    private static final Executor backgroundThreadExecutor = BackgroundThreadExecutor.INSTANCE;
    private static final List<OpenOption> ignoredOpenOptions = Arrays.asList(StandardOpenOption.APPEND, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
    private final int pageCacheId;
    private final PageSwapperFactory swapperFactory;
    private final int cachePageSize;
    private final int keepFree;
    private final PageCacheTracer pageCacheTracer;
    private final PageCursorTracerSupplier pageCursorTracerSupplier;
    private final VersionContextSupplier versionContextSupplier;
    final PageList pages;
    final long victimPage;
    private volatile Object freelist;
    private volatile FileMapping mappedFiles;
    private volatile Thread evictionThread;
    private volatile boolean evictorParked;
    private volatile IOException evictorException;
    private volatile boolean closed;
    private boolean threadsInitialised;
    private boolean printExceptionsOnClose;

    public MuninnPageCache(PageSwapperFactory swapperFactory, int maxPages, int cachePageSize, PageCacheTracer pageCacheTracer, PageCursorTracerSupplier pageCursorTracerSupplier, VersionContextSupplier versionContextSupplier) {
        MuninnPageCache.verifyHacks();
        MuninnPageCache.verifyCachePageSizeIsPowerOfTwo(cachePageSize);
        MuninnPageCache.verifyMinimumPageCount(maxPages, cachePageSize);
        this.pageCacheId = pageCacheIdCounter.incrementAndGet();
        this.swapperFactory = swapperFactory;
        this.cachePageSize = cachePageSize;
        this.keepFree = Math.min(pagesToKeepFree, maxPages / 2);
        this.pageCacheTracer = pageCacheTracer;
        this.pageCursorTracerSupplier = pageCursorTracerSupplier;
        this.versionContextSupplier = versionContextSupplier;
        this.printExceptionsOnClose = true;
        long alignment = swapperFactory.getRequiredBufferAlignment();
        long expectedMaxMemory = (long)maxPages * (long)cachePageSize;
        MemoryManager memoryManager = new MemoryManager(expectedMaxMemory, alignment);
        this.victimPage = VictimPageReference.getVictimPage(cachePageSize);
        this.pages = new PageList(maxPages, cachePageSize, memoryManager, new SwapperSet(), this.victimPage);
        this.setFreelistHead(new AtomicInteger());
    }

    private static void verifyHacks() {
        UnsafeUtil.assertHasUnsafe();
    }

    private static void verifyCachePageSizeIsPowerOfTwo(int cachePageSize) {
        int exponent = 31 - Integer.numberOfLeadingZeros(cachePageSize);
        if (1 << exponent != cachePageSize) {
            throw new IllegalArgumentException("Cache page size must be a power of two, but was " + cachePageSize);
        }
    }

    private static void verifyMinimumPageCount(int maxPages, int cachePageSize) {
        int minimumPageCount = 2;
        if (maxPages < minimumPageCount) {
            throw new IllegalArgumentException(String.format("Page cache must have at least %s pages (%s bytes of memory), but was given %s pages.", minimumPageCount, minimumPageCount * cachePageSize, maxPages));
        }
    }

    @Override
    public synchronized PagedFile map(File file, int filePageSize, OpenOption ... openOptions) throws IOException {
        this.assertHealthy();
        this.ensureThreadsInitialised();
        if (filePageSize > this.cachePageSize) {
            throw new IllegalArgumentException("Cannot map files with a filePageSize (" + filePageSize + ") that is greater than the cachePageSize (" + this.cachePageSize + ")");
        }
        file = file.getCanonicalFile();
        boolean createIfNotExists = false;
        boolean truncateExisting = false;
        boolean deleteOnClose = false;
        boolean anyPageSize = false;
        for (OpenOption option : openOptions) {
            if (option.equals(StandardOpenOption.CREATE)) {
                createIfNotExists = true;
                continue;
            }
            if (option.equals(StandardOpenOption.TRUNCATE_EXISTING)) {
                truncateExisting = true;
                continue;
            }
            if (option.equals(StandardOpenOption.DELETE_ON_CLOSE)) {
                deleteOnClose = true;
                continue;
            }
            if (option.equals(PageCacheOpenOptions.ANY_PAGE_SIZE)) {
                anyPageSize = true;
                continue;
            }
            if (ignoredOpenOptions.contains(option)) continue;
            throw new UnsupportedOperationException("Unsupported OpenOption: " + option);
        }
        FileMapping current = this.mappedFiles;
        while (current != null) {
            if (current.file.equals(file)) {
                MuninnPagedFile pagedFile = current.pagedFile;
                if (pagedFile.pageSize() != filePageSize && !anyPageSize) {
                    String msg = "Cannot map file " + file + " with filePageSize " + filePageSize + " bytes, because it has already been mapped with a filePageSize of " + pagedFile.pageSize() + " bytes.";
                    throw new IllegalArgumentException(msg);
                }
                if (truncateExisting) {
                    throw new UnsupportedOperationException("Cannot truncate a file that is already mapped");
                }
                pagedFile.incrementRefCount();
                pagedFile.markDeleteOnClose(deleteOnClose);
                return pagedFile;
            }
            current = current.next;
        }
        if (filePageSize < 8) {
            throw new IllegalArgumentException("Cannot map files with a filePageSize (" + filePageSize + ") that is less than " + 8 + " bytes");
        }
        MuninnPagedFile pagedFile = new MuninnPagedFile(file, this, filePageSize, this.swapperFactory, this.pageCacheTracer, this.pageCursorTracerSupplier, this.versionContextSupplier, createIfNotExists, truncateExisting);
        pagedFile.incrementRefCount();
        pagedFile.markDeleteOnClose(deleteOnClose);
        current = new FileMapping(file, pagedFile);
        current.next = this.mappedFiles;
        this.mappedFiles = current;
        this.pageCacheTracer.mappedFile(file);
        return pagedFile;
    }

    @Override
    public synchronized Optional<PagedFile> getExistingMapping(File file) throws IOException {
        this.assertHealthy();
        this.ensureThreadsInitialised();
        file = file.getCanonicalFile();
        MuninnPagedFile pagedFile = this.tryGetMappingOrNull(file);
        if (pagedFile != null) {
            pagedFile.incrementRefCount();
            return Optional.of(pagedFile);
        }
        return Optional.empty();
    }

    private MuninnPagedFile tryGetMappingOrNull(File file) throws IOException {
        FileMapping current = this.mappedFiles;
        while (current != null) {
            if (current.file.equals(file)) {
                return current.pagedFile;
            }
            current = current.next;
        }
        return null;
    }

    private void assertNotMapped(File file, FileIsMappedException.Operation operation) throws IOException {
        if (this.tryGetMappingOrNull(file) != null) {
            throw new FileIsMappedException(file, operation);
        }
    }

    @Override
    public synchronized List<PagedFile> listExistingMappings() throws IOException {
        this.assertHealthy();
        this.ensureThreadsInitialised();
        ArrayList<PagedFile> list = new ArrayList<PagedFile>();
        FileMapping current = this.mappedFiles;
        while (current != null) {
            MuninnPagedFile pagedFile = current.pagedFile;
            pagedFile.incrementRefCount();
            list.add(pagedFile);
            current = current.next;
        }
        return list;
    }

    private void ensureThreadsInitialised() throws IOException {
        if (this.threadsInitialised) {
            return;
        }
        this.threadsInitialised = true;
        try {
            backgroundThreadExecutor.execute(new EvictionTask(this));
        }
        catch (Exception e) {
            IOException exception = new IOException(e);
            try {
                this.close();
            }
            catch (Exception closeException) {
                exception.addSuppressed(closeException);
            }
            throw exception;
        }
    }

    synchronized void unmap(MuninnPagedFile file) {
        if (file.decrementRefCount()) {
            FileMapping prev = null;
            FileMapping current = this.mappedFiles;
            while (current != null) {
                if (current.pagedFile == file) {
                    if (prev == null) {
                        this.mappedFiles = current.next;
                    } else {
                        prev.next = current.next;
                    }
                    this.pageCacheTracer.unmappedFile(current.file);
                    this.flushAndCloseWithoutFail(file);
                    break;
                }
                prev = current;
                current = current.next;
            }
        }
    }

    private void flushAndCloseWithoutFail(MuninnPagedFile file) {
        boolean flushedAndClosed = false;
        boolean printedFirstException = false;
        do {
            try {
                file.flushAndForceForClose();
                file.closeSwapper();
                flushedAndClosed = true;
            }
            catch (IOException e) {
                if (!this.printExceptionsOnClose || printedFirstException) continue;
                printedFirstException = true;
                try {
                    e.printStackTrace();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } while (!flushedAndClosed);
    }

    public void setPrintExceptionsOnClose(boolean enabled) {
        this.printExceptionsOnClose = enabled;
    }

    @Override
    public void flushAndForce() throws IOException {
        this.flushAndForce(IOLimiter.unlimited());
    }

    @Override
    public synchronized void flushAndForce(IOLimiter limiter) throws IOException {
        if (limiter == null) {
            throw new IllegalArgumentException("IOLimiter cannot be null");
        }
        this.assertNotClosed();
        this.flushAllPages(limiter);
        this.clearEvictorException();
    }

    private void flushAllPages(IOLimiter limiter) throws IOException {
        try (MajorFlushEvent cacheFlush = this.pageCacheTracer.beginCacheFlush();){
            FileMapping fileMapping = this.mappedFiles;
            while (fileMapping != null) {
                try (MajorFlushEvent fileFlush = this.pageCacheTracer.beginFileFlush(fileMapping.pagedFile.swapper);){
                    FlushEventOpportunity flushOpportunity = fileFlush.flushEventOpportunity();
                    fileMapping.pagedFile.flushAndForceInternal(flushOpportunity, false, limiter);
                }
                fileMapping = fileMapping.next;
            }
            this.syncDevice();
        }
    }

    void syncDevice() throws IOException {
        this.swapperFactory.syncDevice();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        FileMapping files = this.mappedFiles;
        if (files != null) {
            StringBuilder msg = new StringBuilder("Cannot close the PageCache while files are still mapped:");
            while (files != null) {
                int refCount = files.pagedFile.getRefCount();
                msg.append("\n\t");
                msg.append(files.file);
                msg.append(" (").append(refCount);
                msg.append(refCount == 1 ? " mapping)" : " mappings)");
                files = files.next;
            }
            throw new IllegalStateException(msg.toString());
        }
        this.closed = true;
        this.interrupt(this.evictionThread);
        this.evictionThread = null;
        this.swapperFactory.close();
    }

    private void interrupt(Thread thread) {
        if (thread != null) {
            thread.interrupt();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void assertHealthy() throws IOException {
        this.assertNotClosed();
        IOException exception = this.evictorException;
        if (exception != null) {
            throw new IOException("Exception in the page eviction thread", exception);
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("The PageCache has been shut down");
        }
    }

    @Override
    public int pageSize() {
        return this.cachePageSize;
    }

    @Override
    public long maxCachedPages() {
        return this.pages.getPageCount();
    }

    @Override
    public FileSystemAbstraction getCachedFileSystem() {
        return this.swapperFactory.getFileSystemAbstraction();
    }

    int getPageCacheId() {
        return this.pageCacheId;
    }

    long grabFreeAndExclusivelyLockedPage(PageFaultEvent faultEvent) throws IOException {
        FreePage freePage;
        while (true) {
            this.assertHealthy();
            Object current = this.getFreelistHead();
            if (current == null) {
                this.unparkEvictor();
                long pageRef = this.cooperativelyEvict(faultEvent);
                if (pageRef == 0L) continue;
                return pageRef;
            }
            if (current instanceof AtomicInteger) {
                int pageCount = this.pages.getPageCount();
                AtomicInteger counter = (AtomicInteger)current;
                int pageId = counter.get();
                if (pageId < pageCount && counter.compareAndSet(pageId, pageId + 1)) {
                    return this.pages.deref(pageId);
                }
                if (pageId < pageCount) continue;
                this.compareAndSetFreelistHead(current, null);
                continue;
            }
            if (!(current instanceof FreePage)) continue;
            freePage = (FreePage)current;
            if (freePage == shutdownSignal) {
                throw new IllegalStateException("The PageCache has been shut down.");
            }
            if (this.compareAndSetFreelistHead(freePage, freePage.next)) break;
        }
        return freePage.pageRef;
    }

    private long cooperativelyEvict(PageFaultEvent faultEvent) throws IOException {
        long pageRef;
        int iterations = 0;
        int pageCount = this.pages.getPageCount();
        int clockArm = ThreadLocalRandom.current().nextInt(pageCount);
        boolean evicted = false;
        do {
            this.assertHealthy();
            if (this.getFreelistHead() != null) {
                return 0L;
            }
            if (clockArm == pageCount) {
                if (iterations == cooperativeEvictionLiveLockThreshold) {
                    throw this.cooperativeEvictionLiveLock();
                }
                ++iterations;
                clockArm = 0;
            }
            if (this.pages.isLoaded(pageRef = this.pages.deref(clockArm)) && this.pages.decrementUsage(pageRef)) {
                evicted = this.pages.tryEvict(pageRef, faultEvent);
            }
            ++clockArm;
        } while (!evicted);
        return pageRef;
    }

    private CacheLiveLockException cooperativeEvictionLiveLock() {
        return new CacheLiveLockException("Live-lock encountered when trying to cooperatively evict a page during page fault. This happens when we want to access a page that is not in memory, so it has to be faulted in, but there are no free memory pages available to accept the page fault, so we have to evict an existing page, but all the in-memory pages are currently locked by other accesses. If those other access are waiting for our page fault to make progress, then we have a live-lock, and the only way we can get out of it is by throwing this exception. This should be extremely rare, but can happen if the page cache size is tiny and the number of concurrently running transactions is very high. You should be able to get around this problem by increasing the amount of memory allocated to the page cache with the `dbms.memory.pagecache.size` setting. Please contact Neo4j support if you need help tuning your database.");
    }

    private void unparkEvictor() {
        if (this.evictorParked) {
            this.evictorParked = false;
            LockSupport.unpark(this.evictionThread);
        }
    }

    private void parkEvictor(long parkNanos) {
        this.evictorParked = true;
        LockSupport.parkNanos(this, parkNanos);
        this.evictorParked = false;
    }

    private Object getFreelistHead() {
        return UnsafeUtil.getObjectVolatile((Object)this, (long)freelistOffset);
    }

    private boolean compareAndSetFreelistHead(Object expected, Object update) {
        return UnsafeUtil.compareAndSwapObject((Object)this, (long)freelistOffset, (Object)expected, (Object)update);
    }

    private void setFreelistHead(Object newFreelistHead) {
        UnsafeUtil.putObjectVolatile((Object)this, (long)freelistOffset, (Object)newFreelistHead);
    }

    void continuouslySweepPages() {
        this.evictionThread = Thread.currentThread();
        int clockArm = 0;
        while (!this.closed) {
            int pageCountToEvict = this.parkUntilEvictionRequired(this.keepFree);
            EvictionRunEvent evictionRunEvent = this.pageCacheTracer.beginPageEvictions(pageCountToEvict);
            Throwable throwable = null;
            try {
                clockArm = this.evictPages(pageCountToEvict, clockArm, evictionRunEvent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (evictionRunEvent == null) continue;
                if (throwable != null) {
                    try {
                        evictionRunEvent.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                evictionRunEvent.close();
            }
        }
        this.setFreelistHead(shutdownSignal);
    }

    private int parkUntilEvictionRequired(int keepFree) {
        long count;
        long parkNanos = TimeUnit.MILLISECONDS.toNanos(10L);
        while (true) {
            this.parkEvictor(parkNanos);
            if (Thread.interrupted() || this.closed) {
                return 0;
            }
            Object freelistHead = this.getFreelistHead();
            if (freelistHead == null) {
                return keepFree;
            }
            if (freelistHead.getClass() == FreePage.class) {
                int availablePages = ((FreePage)freelistHead).count;
                if (availablePages >= keepFree) continue;
                return keepFree - availablePages;
            }
            if (freelistHead.getClass() != AtomicInteger.class) continue;
            AtomicInteger counter = (AtomicInteger)freelistHead;
            count = this.pages.getPageCount() - counter.get();
            if (count < (long)keepFree) break;
        }
        return count < 0L ? keepFree : (int)((long)keepFree - count);
    }

    int evictPages(int pageCountToEvict, int clockArm, EvictionRunEvent evictionRunEvent) {
        while (pageCountToEvict > 0 && !this.closed) {
            if (clockArm == this.pages.getPageCount()) {
                clockArm = 0;
            }
            if (this.closed) {
                return 0;
            }
            long pageRef = this.pages.deref(clockArm);
            if (this.pages.isLoaded(pageRef) && this.pages.decrementUsage(pageRef)) {
                try {
                    if (this.pages.tryEvict(pageRef, evictionRunEvent)) {
                        this.clearEvictorException();
                        --pageCountToEvict;
                        this.addFreePageToFreelist(pageRef);
                    }
                }
                catch (IOException e) {
                    this.evictorException = e;
                }
                catch (OutOfMemoryError oom) {
                    this.evictorException = oomException;
                }
                catch (Throwable th) {
                    this.evictorException = new IOException("Eviction thread encountered a problem", th);
                }
            }
            ++clockArm;
        }
        return clockArm;
    }

    void addFreePageToFreelist(long pageRef) {
        Object current;
        FreePage freePage = new FreePage(pageRef);
        do {
            if ((current = this.getFreelistHead()) instanceof AtomicInteger && ((AtomicInteger)current).get() > this.pages.getPageCount()) {
                current = null;
            }
            freePage.setNext(current);
        } while (!this.compareAndSetFreelistHead(current, freePage));
    }

    void clearEvictorException() {
        if (this.evictorException != null) {
            this.evictorException = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MuninnPageCache[ \n");
        for (int i = 0; i < this.pages.getPageCount(); ++i) {
            sb.append(' ');
            this.pages.toString(this.pages.deref(i), sb);
            sb.append('\n');
        }
        sb.append(']').append('\n');
        return sb.toString();
    }

    void vacuum(SwapperSet swappers) {
        if (this.getFreelistHead() instanceof AtomicInteger && swappers.countAvailableIds() > 200) {
            return;
        }
        swappers.vacuum((IntPredicate swapperIds) -> {
            int pageCount = this.pages.getPageCount();
            try (EvictionRunEvent evictions = this.pageCacheTracer.beginPageEvictions(0);){
                block11: for (int i = 0; i < pageCount; ++i) {
                    long pageRef = this.pages.deref(i);
                    while (swapperIds.test(this.pages.getSwapperId(pageRef))) {
                        if (!this.pages.tryEvict(pageRef, evictions)) continue;
                        this.addFreePageToFreelist(pageRef);
                        continue block11;
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

