/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.stream.Stream;
import org.neo4j.kernel.api.ExecutingQuery;

interface ExecutingQueryList {
    public static final ExecutingQueryList EMPTY = new Empty();

    public Stream<ExecutingQuery> queries();

    public ExecutingQueryList push(ExecutingQuery var1);

    public ExecutingQueryList remove(ExecutingQuery var1);

    public static class Empty
    implements ExecutingQueryList {
        @Override
        public Stream<ExecutingQuery> queries() {
            return Stream.empty();
        }

        @Override
        public ExecutingQueryList push(ExecutingQuery newExecutingQuery) {
            return new Entry(newExecutingQuery, this);
        }

        @Override
        public ExecutingQueryList remove(ExecutingQuery executingQuery) {
            return this;
        }
    }

    public static class Entry
    implements ExecutingQueryList {
        final ExecutingQuery query;
        final ExecutingQueryList next;

        Entry(ExecutingQuery query, ExecutingQueryList next) {
            this.query = query;
            this.next = next;
        }

        @Override
        public Stream<ExecutingQuery> queries() {
            Stream.Builder<ExecutingQuery> builder = Stream.builder();
            ExecutingQueryList entry = this;
            while (entry != EMPTY) {
                Entry current = entry;
                builder.accept(current.query);
                entry = current.next;
            }
            return builder.build();
        }

        @Override
        public ExecutingQueryList push(ExecutingQuery newExecutingQuery) {
            assert (newExecutingQuery.internalQueryId() > this.query.internalQueryId());
            return new Entry(newExecutingQuery, this);
        }

        @Override
        public ExecutingQueryList remove(ExecutingQuery executingQuery) {
            if (executingQuery.equals(this.query)) {
                return this.next;
            }
            return this.next == EMPTY ? EMPTY : new Entry(this.query, this.next.remove(executingQuery));
        }
    }
}

