/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageCommand;

public class TransactionToApply
implements CommandsToApply,
AutoCloseable {
    public static final long TRANSACTION_ID_NOT_SPECIFIED = 0L;
    private final TransactionRepresentation transactionRepresentation;
    private long transactionId;
    private TransactionToApply nextTransactionInBatch;
    private Commitment commitment;
    private LongConsumer closedCallback;

    public TransactionToApply(TransactionRepresentation transactionRepresentation) {
        this(transactionRepresentation, 0L);
    }

    public TransactionToApply(TransactionRepresentation transactionRepresentation, long transactionId) {
        this.transactionRepresentation = transactionRepresentation;
        this.transactionId = transactionId;
    }

    public void next(TransactionToApply next) {
        this.nextTransactionInBatch = next;
    }

    public Commitment commitment() {
        return this.commitment;
    }

    @Override
    public long transactionId() {
        return this.transactionId;
    }

    @Override
    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        return this.transactionRepresentation.accept(visitor);
    }

    public TransactionRepresentation transactionRepresentation() {
        return this.transactionRepresentation;
    }

    @Override
    public boolean requiresApplicationOrdering() {
        return this.commitment.hasLegacyIndexChanges();
    }

    public void commitment(Commitment commitment, long transactionId) {
        this.commitment = commitment;
        this.transactionId = transactionId;
    }

    @Override
    public TransactionToApply next() {
        return this.nextTransactionInBatch;
    }

    public void onClose(LongConsumer closedCallback) {
        this.closedCallback = closedCallback;
    }

    @Override
    public void close() {
        if (this.closedCallback != null) {
            this.closedCallback.accept(this.transactionId);
        }
    }
}

