/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.RelationshipChangeVisitorAdapter;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.PropertyValueComparison;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.cursor.TxAllPropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxIteratorNodeCursor;
import org.neo4j.kernel.impl.api.cursor.TxIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.cursor.TxLabelCursor;
import org.neo4j.kernel.impl.api.cursor.TxSingleLabelCursor;
import org.neo4j.kernel.impl.api.cursor.TxSingleNodeCursor;
import org.neo4j.kernel.impl.api.cursor.TxSinglePropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxSingleRelationshipCursor;
import org.neo4j.kernel.impl.api.state.GraphState;
import org.neo4j.kernel.impl.api.state.LabelState;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.PropertyChanges;
import org.neo4j.kernel.impl.api.state.RelationshipStateImpl;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.RelationshipDiffSets;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.DiffSetsVisitor;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableRelationshipDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public final class TxState
implements TransactionState,
RelationshipVisitor.Home {
    private Map<Integer, LabelState.Mutable> labelStatesMap;
    private static final LabelState.Defaults LABEL_STATE = new LabelState.Defaults(){

        @Override
        Map<Integer, LabelState.Mutable> getMap(TxState state) {
            return state.labelStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Integer, LabelState.Mutable> map) {
            state.labelStatesMap = map;
        }
    };
    private Map<Long, NodeStateImpl> nodeStatesMap;
    private static final NodeStateImpl.Defaults NODE_STATE = new NodeStateImpl.Defaults(){

        @Override
        Map<Long, NodeStateImpl> getMap(TxState state) {
            return state.nodeStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Long, NodeStateImpl> map) {
            state.nodeStatesMap = map;
        }
    };
    private Map<Long, RelationshipStateImpl> relationshipStatesMap;
    private static final RelationshipStateImpl.Defaults RELATIONSHIP_STATE = new RelationshipStateImpl.Defaults(){

        @Override
        Map<Long, RelationshipStateImpl> getMap(TxState state) {
            return state.relationshipStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Long, RelationshipStateImpl> map) {
            state.relationshipStatesMap = map;
        }
    };
    private Map<Integer, String> createdLabelTokens;
    private Map<Integer, String> createdPropertyKeyTokens;
    private Map<Integer, String> createdRelationshipTypeTokens;
    private GraphState graphState;
    private DiffSets<IndexDescriptor> indexChanges;
    private DiffSets<IndexDescriptor> constraintIndexChanges;
    private DiffSets<PropertyConstraint> constraintsChanges;
    private PropertyChanges propertyChangesForNodes;
    private DiffSets<Long> nodes;
    private RelationshipDiffSets<Long> relationships;
    private PrimitiveLongSet nodesDeletedInTx;
    private PrimitiveLongSet relationshipsDeletedInTx;
    private Map<UniquenessConstraint, Long> createdConstraintIndexesByConstraint;
    private PrimitiveIntObjectMap<Map<DefinedProperty, DiffSets<Long>>> indexUpdates;
    private PrimitiveIntObjectMap<DiffSets<RelationshipPropertyConstraint>> relationshipConstraintChanges;
    private InstanceCache<TxIteratorNodeCursor> iteratorNodeCursor;
    private InstanceCache<TxSingleNodeCursor> singleNodeCursor = new InstanceCache<TxSingleNodeCursor>(){

        @Override
        protected TxSingleNodeCursor create() {
            return new TxSingleNodeCursor((TransactionState)TxState.this, this);
        }
    };
    private InstanceCache<TxIteratorRelationshipCursor> iteratorRelationshipCursor;
    private InstanceCache<TxSingleRelationshipCursor> singleRelationshipCursor;
    private InstanceCache<TxAllPropertyCursor> propertyCursor;
    private InstanceCache<TxSinglePropertyCursor> singlePropertyCursor;
    private InstanceCache<TxLabelCursor> labelCursor;
    private InstanceCache<TxSingleLabelCursor> singleLabelCursor;
    private boolean hasChanges;
    private boolean hasDataChanges;

    public TxState() {
        this.iteratorNodeCursor = new InstanceCache<TxIteratorNodeCursor>(){

            @Override
            protected TxIteratorNodeCursor create() {
                return new TxIteratorNodeCursor((TransactionState)TxState.this, this);
            }
        };
        this.propertyCursor = new InstanceCache<TxAllPropertyCursor>(){

            @Override
            protected TxAllPropertyCursor create() {
                return new TxAllPropertyCursor(this);
            }
        };
        this.singlePropertyCursor = new InstanceCache<TxSinglePropertyCursor>(){

            @Override
            protected TxSinglePropertyCursor create() {
                return new TxSinglePropertyCursor(this);
            }
        };
        this.labelCursor = new InstanceCache<TxLabelCursor>(){

            @Override
            protected TxLabelCursor create() {
                return new TxLabelCursor(this);
            }
        };
        this.singleLabelCursor = new InstanceCache<TxSingleLabelCursor>(){

            @Override
            protected TxSingleLabelCursor create() {
                return new TxSingleLabelCursor(this);
            }
        };
        this.singleRelationshipCursor = new InstanceCache<TxSingleRelationshipCursor>(){

            @Override
            protected TxSingleRelationshipCursor create() {
                return new TxSingleRelationshipCursor((TransactionState)TxState.this, this);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<TxIteratorRelationshipCursor>(){

            @Override
            protected TxIteratorRelationshipCursor create() {
                return new TxIteratorRelationshipCursor((TransactionState)TxState.this, this);
            }
        };
    }

    @Override
    public void accept(TxStateVisitor visitor) throws ConstraintValidationKernelException, CreateConstraintFailureException {
        if (this.nodes != null) {
            this.nodes.accept((DiffSetsVisitor)TxState.createdNodesVisitor(visitor));
        }
        if (this.relationships != null) {
            this.relationships.accept((DiffSetsVisitor)TxState.createdRelationshipsVisitor(this, visitor));
            this.relationships.accept((DiffSetsVisitor)TxState.deletedRelationshipsVisitor(visitor));
        }
        if (this.nodes != null) {
            this.nodes.accept((DiffSetsVisitor)TxState.deletedNodesVisitor(visitor));
        }
        for (NodeState nodeState : this.modifiedNodes()) {
            nodeState.accept(TxState.nodeVisitor(visitor));
        }
        for (RelationshipState relationshipState : this.modifiedRelationships()) {
            relationshipState.accept(TxState.relVisitor(visitor));
        }
        if (this.graphState != null) {
            this.graphState.accept(TxState.graphPropertyVisitor(visitor));
        }
        if (this.indexChanges != null) {
            this.indexChanges.accept((DiffSetsVisitor)TxState.indexVisitor(visitor, false));
        }
        if (this.constraintIndexChanges != null) {
            this.constraintIndexChanges.accept((DiffSetsVisitor)TxState.indexVisitor(visitor, true));
        }
        if (this.constraintsChanges != null) {
            this.constraintsChanges.accept((DiffSetsVisitor)TxState.constraintsVisitor(visitor));
        }
        if (this.createdLabelTokens != null) {
            for (Map.Entry entry : this.createdLabelTokens.entrySet()) {
                visitor.visitCreatedLabelToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
        if (this.createdPropertyKeyTokens != null) {
            for (Map.Entry entry : this.createdPropertyKeyTokens.entrySet()) {
                visitor.visitCreatedPropertyKeyToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
        if (this.createdRelationshipTypeTokens != null) {
            for (Map.Entry entry : this.createdRelationshipTypeTokens.entrySet()) {
                visitor.visitCreatedRelationshipTypeToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
    }

    private static DiffSetsVisitor<Long> deletedNodesVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitRemoved(Long element) {
                visitor.visitDeletedNode(element);
            }
        };
    }

    private static DiffSetsVisitor<Long> createdNodesVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitAdded(Long element) {
                visitor.visitCreatedNode(element);
            }
        };
    }

    private static DiffSetsVisitor<Long> deletedRelationshipsVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitRemoved(Long id) {
                visitor.visitDeletedRelationship(id);
            }
        };
    }

    private static DiffSetsVisitor<Long> createdRelationshipsVisitor(ReadableTransactionState tx, final TxStateVisitor visitor) {
        return new RelationshipChangeVisitorAdapter(tx){

            @Override
            protected void visitAddedRelationship(long relationshipId, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
                visitor.visitCreatedRelationship(relationshipId, type, startNode, endNode);
            }
        };
    }

    private static DiffSetsVisitor<PropertyConstraint> constraintsVisitor(TxStateVisitor visitor) {
        return new ConstraintDiffSetsVisitor(visitor);
    }

    private static DiffSetsVisitor<IndexDescriptor> indexVisitor(final TxStateVisitor visitor, final boolean forConstraint) {
        return new DiffSetsVisitor<IndexDescriptor>(){

            @Override
            public void visitAdded(IndexDescriptor element) {
                visitor.visitAddedIndex(element, forConstraint);
            }

            @Override
            public void visitRemoved(IndexDescriptor element) {
                visitor.visitRemovedIndex(element, forConstraint);
            }
        };
    }

    private static NodeState.Visitor nodeVisitor(final TxStateVisitor visitor) {
        return new NodeState.Visitor(){

            @Override
            public void visitLabelChanges(long nodeId, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationKernelException {
                visitor.visitNodeLabelChanges(nodeId, added, removed);
            }

            @Override
            public void visitPropertyChanges(long entityId, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
                visitor.visitNodePropertyChanges(entityId, added, changed, removed);
            }
        };
    }

    private static PropertyContainerState.Visitor relVisitor(TxStateVisitor visitor) {
        return visitor::visitRelPropertyChanges;
    }

    private static PropertyContainerState.Visitor graphPropertyVisitor(TxStateVisitor visitor) {
        return (entityId, added, changed, removed) -> visitor.visitGraphPropertyChanges(added, changed, removed);
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Override
    public Iterable<NodeState> modifiedNodes() {
        return NODE_STATE.values(this);
    }

    private DiffSets<Long> getOrCreateLabelStateNodeDiffSets(int labelId) {
        return ((LabelState.Mutable)LABEL_STATE.getOrCreate(this, labelId)).getOrCreateNodeDiffSets();
    }

    @Override
    public ReadableDiffSets<Integer> nodeStateLabelDiffSets(long nodeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).labelDiffSets();
    }

    private DiffSets<Integer> getOrCreateNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getOrCreateLabelDiffSets();
    }

    @Override
    public Iterator<StorageProperty> augmentGraphProperties(Iterator<StorageProperty> original) {
        if (this.graphState != null) {
            return this.graphState.augmentProperties(original);
        }
        return original;
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.isAdded((Object)nodeId);
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.isAdded((Object)relationshipId);
    }

    private void changed() {
        this.hasChanges = true;
    }

    private void dataChanged() {
        this.changed();
        this.hasDataChanges = true;
    }

    @Override
    public void nodeDoCreate(long id) {
        this.nodes().add((Object)id);
        this.dataChanged();
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        NodeStateImpl nodeState;
        if (this.nodes().remove((Object)nodeId)) {
            this.recordNodeDeleted(nodeId);
        }
        if (this.nodeStatesMap != null && (nodeState = this.nodeStatesMap.remove(nodeId)) != null) {
            ReadableDiffSets<Integer> diff = nodeState.labelDiffSets();
            for (Integer label : diff.getAdded()) {
                this.getOrCreateLabelStateNodeDiffSets(label).remove((Object)nodeId);
            }
            nodeState.clearIndexDiffs(nodeId);
            nodeState.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoCreate(long id, int relationshipTypeId, long startNodeId, long endNodeId) {
        this.relationships().add((Object)id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id, relationshipTypeId, Direction.INCOMING);
        }
        this.getOrCreateRelationshipState(id).setMetaData(startNodeId, endNodeId, relationshipTypeId);
        this.dataChanged();
    }

    @Override
    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.nodesDeletedInTx != null && this.nodesDeletedInTx.contains(nodeId);
    }

    @Override
    public boolean nodeModifiedInThisTx(long nodeId) {
        return this.nodeIsAddedInThisTx(nodeId) || this.nodeIsDeletedInThisTx(nodeId) || this.hasNodeState(nodeId);
    }

    @Override
    public void relationshipDoDelete(long id, int type, long startNodeId, long endNodeId) {
        RelationshipStateImpl removed;
        if (this.relationships().remove((Object)id)) {
            this.recordRelationshipDeleted(id);
        }
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id, type, Direction.INCOMING);
        }
        if (this.relationshipStatesMap != null && (removed = this.relationshipStatesMap.remove(id)) != null) {
            removed.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoDeleteAddedInThisTx(long relationshipId) {
        ((RelationshipState)RELATIONSHIP_STATE.get(this, relationshipId)).accept(new RelationshipVisitor<RuntimeException>(){

            @Override
            public void visit(long relId, int type, long startNode, long endNode) {
                TxState.this.relationshipDoDelete(relId, type, startNode, endNode);
            }
        });
    }

    @Override
    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.relationshipsDeletedInTx != null && this.relationshipsDeletedInTx.contains(relationshipId);
    }

    @Override
    public void nodeDoReplaceProperty(long nodeId, Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateNodeState(nodeId).changeProperty(newProperty);
            this.nodePropertyChanges().changeProperty(nodeId, replacedProperty.propertyKeyId(), ((DefinedProperty)replacedProperty).value(), newProperty.value());
        } else {
            NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
            nodeState.addProperty(newProperty);
            this.nodePropertyChanges().addProperty(nodeId, newProperty.propertyKeyId(), newProperty.value());
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateRelationshipState(relationshipId).changeProperty(newProperty);
        } else {
            this.getOrCreateRelationshipState(relationshipId).addProperty(newProperty);
        }
        this.dataChanged();
    }

    @Override
    public void graphDoReplaceProperty(Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateGraphState().changeProperty(newProperty);
        } else {
            this.getOrCreateGraphState().addProperty(newProperty);
        }
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, DefinedProperty removedProperty) {
        this.getOrCreateNodeState(nodeId).removeProperty(removedProperty);
        this.nodePropertyChanges().removeProperty(nodeId, removedProperty.propertyKeyId(), removedProperty.value());
        this.dataChanged();
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, DefinedProperty removedProperty) {
        this.getOrCreateRelationshipState(relationshipId).removeProperty(removedProperty);
        this.dataChanged();
    }

    @Override
    public void graphDoRemoveProperty(DefinedProperty removedProperty) {
        this.getOrCreateGraphState().removeProperty(removedProperty);
        this.dataChanged();
    }

    @Override
    public void nodeDoAddLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).add((Object)nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).add((Object)labelId);
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).remove((Object)nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).remove((Object)labelId);
        this.dataChanged();
    }

    @Override
    public void labelDoCreateForName(String labelName, int id) {
        if (this.createdLabelTokens == null) {
            this.createdLabelTokens = new HashMap<Integer, String>();
        }
        this.createdLabelTokens.put(id, labelName);
        this.changed();
    }

    @Override
    public void propertyKeyDoCreateForName(String propertyKeyName, int id) {
        if (this.createdPropertyKeyTokens == null) {
            this.createdPropertyKeyTokens = new HashMap<Integer, String>();
        }
        this.createdPropertyKeyTokens.put(id, propertyKeyName);
        this.changed();
    }

    @Override
    public void relationshipTypeDoCreateForName(String labelName, int id) {
        if (this.createdRelationshipTypeTokens == null) {
            this.createdRelationshipTypeTokens = new HashMap<Integer, String>();
        }
        this.createdRelationshipTypeTokens.put(id, labelName);
        this.changed();
    }

    @Override
    public NodeState getNodeState(long id) {
        return (NodeState)NODE_STATE.get(this, id);
    }

    @Override
    public RelationshipState getRelationshipState(long id) {
        return (RelationshipState)RELATIONSHIP_STATE.get(this, id);
    }

    @Override
    public Cursor<NodeItem> augmentSingleNodeCursor(Cursor<NodeItem> cursor, long nodeId) {
        return this.hasChanges ? this.singleNodeCursor.get().init(cursor, nodeId) : cursor;
    }

    @Override
    public Cursor<PropertyItem> augmentPropertyCursor(Cursor<PropertyItem> cursor, PropertyContainerState propertyContainerState) {
        return propertyContainerState.hasChanges() ? this.propertyCursor.get().init(cursor, propertyContainerState) : cursor;
    }

    @Override
    public Cursor<PropertyItem> augmentSinglePropertyCursor(Cursor<PropertyItem> cursor, PropertyContainerState propertyContainerState, int propertyKeyId) {
        return propertyContainerState.hasChanges() ? this.singlePropertyCursor.get().init(cursor, propertyContainerState, propertyKeyId) : cursor;
    }

    @Override
    public Cursor<LabelItem> augmentLabelCursor(Cursor<LabelItem> cursor, NodeState nodeState) {
        ReadableDiffSets<Integer> labelDiffSets = nodeState.labelDiffSets();
        if (labelDiffSets.isEmpty()) {
            return cursor;
        }
        return this.labelCursor.get().init(cursor, labelDiffSets);
    }

    @Override
    public Cursor<LabelItem> augmentSingleLabelCursor(Cursor<LabelItem> cursor, NodeState nodeState, int labelId) {
        ReadableDiffSets<Integer> labelDiffSets = nodeState.labelDiffSets();
        if (labelDiffSets.isEmpty()) {
            return cursor;
        }
        return this.singleLabelCursor.get().init(cursor, labelDiffSets, labelId);
    }

    @Override
    public Cursor<RelationshipItem> augmentSingleRelationshipCursor(Cursor<RelationshipItem> cursor, long relationshipId) {
        return this.hasChanges ? this.singleRelationshipCursor.get().init(cursor, relationshipId) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentIteratorRelationshipCursor(Cursor<RelationshipItem> cursor, RelationshipIterator iterator) {
        return this.hasChanges ? this.iteratorRelationshipCursor.get().init(cursor, iterator) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentNodeRelationshipCursor(Cursor<RelationshipItem> cursor, NodeState nodeState, Direction direction, int[] relTypes) {
        if (nodeState.hasChanges()) {
            if (relTypes == null) {
                return this.iteratorRelationshipCursor.get().init(cursor, nodeState.getAddedRelationships(direction));
            }
            return this.iteratorRelationshipCursor.get().init(cursor, nodeState.getAddedRelationships(direction, relTypes));
        }
        return cursor;
    }

    @Override
    public Cursor<NodeItem> augmentNodesGetAllCursor(Cursor<NodeItem> cursor) {
        return this.hasChanges && this.nodes != null && !this.nodes.isEmpty() ? this.iteratorNodeCursor.get().init(cursor, this.nodes.getAdded().iterator()) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentRelationshipsGetAllCursor(Cursor<RelationshipItem> cursor) {
        return this.hasChanges && this.relationships != null && !this.relationships.isEmpty() ? this.iteratorRelationshipCursor.get().init(cursor, PrimitiveLongCollections.toPrimitiveIterator(this.relationships.getAdded().iterator())) : cursor;
    }

    @Override
    public ReadableDiffSets<Long> nodesWithLabelChanged(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).nodeDiffSets();
    }

    @Override
    public void indexRuleDoAdd(IndexDescriptor descriptor) {
        DiffSets<IndexDescriptor> diff = this.indexChangesDiffSets();
        if (diff.unRemove((Object)descriptor)) {
            this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateIndexChanges().unRemove((Object)descriptor);
        } else {
            diff.add((Object)descriptor);
            this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateIndexChanges().add((Object)descriptor);
        }
        this.changed();
    }

    @Override
    public void constraintIndexRuleDoAdd(IndexDescriptor descriptor) {
        this.constraintIndexChangesDiffSets().add((Object)descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateConstraintIndexChanges().add((Object)descriptor);
        this.changed();
    }

    @Override
    public void indexDoDrop(IndexDescriptor descriptor) {
        this.indexChangesDiffSets().remove((Object)descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateIndexChanges().remove((Object)descriptor);
        this.changed();
    }

    @Override
    public void constraintIndexDoDrop(IndexDescriptor descriptor) {
        this.constraintIndexChangesDiffSets().remove((Object)descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateConstraintIndexChanges().remove((Object)descriptor);
        this.changed();
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).indexChanges();
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> constraintIndexDiffSetsByLabel(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).constraintIndexChanges();
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> indexChanges() {
        return ReadableDiffSets.Empty.ifNull(this.indexChanges);
    }

    private DiffSets<IndexDescriptor> indexChangesDiffSets() {
        if (this.indexChanges == null) {
            this.indexChanges = new DiffSets();
        }
        return this.indexChanges;
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> constraintIndexChanges() {
        return ReadableDiffSets.Empty.ifNull(this.constraintIndexChanges);
    }

    private DiffSets<IndexDescriptor> constraintIndexChangesDiffSets() {
        if (this.constraintIndexChanges == null) {
            this.constraintIndexChanges = new DiffSets();
        }
        return this.constraintIndexChanges;
    }

    @Override
    public ReadableDiffSets<Long> addedAndRemovedNodes() {
        return ReadableDiffSets.Empty.ifNull(this.nodes);
    }

    private DiffSets<Long> nodes() {
        if (this.nodes == null) {
            this.nodes = new DiffSets();
        }
        return this.nodes;
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).augmentDegree(direction, degree);
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction, int typeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).augmentDegree(direction, degree, typeId);
    }

    @Override
    public PrimitiveIntIterator nodeRelationshipTypes(long nodeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).relationshipTypes();
    }

    @Override
    public ReadableRelationshipDiffSets<Long> addedAndRemovedRelationships() {
        return ReadableRelationshipDiffSets.Empty.ifNull(this.relationships);
    }

    private RelationshipDiffSets<Long> relationships() {
        if (this.relationships == null) {
            this.relationships = new RelationshipDiffSets(this);
        }
        return this.relationships;
    }

    @Override
    public Iterable<RelationshipState> modifiedRelationships() {
        return RELATIONSHIP_STATE.values(this);
    }

    private LabelState.Mutable getOrCreateLabelState(int labelId) {
        return (LabelState.Mutable)LABEL_STATE.getOrCreate(this, labelId);
    }

    private NodeStateImpl getOrCreateNodeState(long nodeId) {
        return (NodeStateImpl)NODE_STATE.getOrCreate(this, nodeId);
    }

    private RelationshipStateImpl getOrCreateRelationshipState(long relationshipId) {
        return (RelationshipStateImpl)RELATIONSHIP_STATE.getOrCreate(this, relationshipId);
    }

    private GraphState getOrCreateGraphState() {
        if (this.graphState == null) {
            this.graphState = new GraphState();
        }
        return this.graphState;
    }

    @Override
    public void constraintDoAdd(UniquenessConstraint constraint, long indexId) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.createdConstraintIndexesByConstraint().put(constraint, indexId);
        this.getOrCreateLabelState(constraint.label()).getOrCreateConstraintsChanges().add((Object)constraint);
        this.changed();
    }

    @Override
    public void constraintDoAdd(NodePropertyExistenceConstraint constraint) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.getOrCreateLabelState(constraint.label()).getOrCreateConstraintsChanges().add((Object)constraint);
        this.hasChanges = true;
    }

    @Override
    public void constraintDoAdd(RelationshipPropertyExistenceConstraint constraint) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.relationshipConstraintChangesByType(constraint.relationshipType()).add((Object)constraint);
        this.hasChanges = true;
    }

    @Override
    public ReadableDiffSets<NodePropertyConstraint> constraintsChangesForLabelAndProperty(int labelId, int propertyKey) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).nodeConstraintsChanges().filterAdded(item -> item.propertyKey() == propertyKey);
    }

    @Override
    public ReadableDiffSets<NodePropertyConstraint> constraintsChangesForLabel(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).nodeConstraintsChanges();
    }

    @Override
    public ReadableDiffSets<RelationshipPropertyConstraint> constraintsChangesForRelationshipType(int relTypeId) {
        DiffSets changes = null;
        if (this.relationshipConstraintChanges != null) {
            changes = (DiffSets)this.relationshipConstraintChanges.get(relTypeId);
        }
        return ReadableDiffSets.Empty.ifNull(changes);
    }

    @Override
    public ReadableDiffSets<RelationshipPropertyConstraint> constraintsChangesForRelationshipTypeAndProperty(int relTypeId, int propertyKey) {
        return this.constraintsChangesForRelationshipType(relTypeId).filterAdded(constraint -> constraint.propertyKey() == propertyKey);
    }

    @Override
    public ReadableDiffSets<PropertyConstraint> constraintsChanges() {
        return ReadableDiffSets.Empty.ifNull(this.constraintsChanges);
    }

    private DiffSets<PropertyConstraint> constraintsChangesDiffSets() {
        if (this.constraintsChanges == null) {
            this.constraintsChanges = new DiffSets();
        }
        return this.constraintsChanges;
    }

    @Override
    public void constraintDoDrop(NodePropertyConstraint constraint) {
        this.constraintsChangesDiffSets().remove((Object)constraint);
        if (constraint instanceof UniquenessConstraint) {
            this.constraintIndexDoDrop(new IndexDescriptor(constraint.label(), constraint.propertyKey()));
        }
        this.getOrCreateLabelState(constraint.label()).getOrCreateConstraintsChanges().remove((Object)constraint);
        this.changed();
    }

    @Override
    public void constraintDoDrop(RelationshipPropertyConstraint constraint) {
        this.constraintsChangesDiffSets().remove((Object)constraint);
        this.relationshipConstraintChangesByType(constraint.relationshipType()).remove((Object)constraint);
        this.hasChanges = true;
    }

    private DiffSets<RelationshipPropertyConstraint> relationshipConstraintChangesByType(int relTypeId) {
        DiffSets diffSets;
        if (this.relationshipConstraintChanges == null) {
            this.relationshipConstraintChanges = Primitive.intObjectMap();
        }
        if ((diffSets = (DiffSets)this.relationshipConstraintChanges.get(relTypeId)) == null) {
            diffSets = new DiffSets();
            this.relationshipConstraintChanges.put(relTypeId, diffSets);
        }
        return diffSets;
    }

    @Override
    public boolean constraintDoUnRemove(NodePropertyConstraint constraint) {
        if (this.constraintsChangesDiffSets().unRemove((Object)constraint)) {
            this.getOrCreateLabelState(constraint.label()).getOrCreateConstraintsChanges().unRemove((Object)constraint);
            return true;
        }
        return false;
    }

    @Override
    public boolean constraintIndexDoUnRemove(IndexDescriptor index) {
        if (this.constraintIndexChangesDiffSets().unRemove((Object)index)) {
            ((LabelState.Mutable)LABEL_STATE.getOrCreate(this, index.getLabelId())).getOrCreateConstraintIndexChanges().unRemove((Object)index);
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx() {
        if (this.createdConstraintIndexesByConstraint != null && !this.createdConstraintIndexesByConstraint.isEmpty()) {
            return Iterables.map(constraint -> new IndexDescriptor(constraint.label(), constraint.propertyKey()), this.createdConstraintIndexesByConstraint.keySet());
        }
        return Iterables.empty();
    }

    @Override
    public Long indexCreatedForConstraint(UniquenessConstraint constraint) {
        return this.createdConstraintIndexesByConstraint == null ? null : this.createdConstraintIndexesByConstraint.get(constraint);
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForScanOrSeek(IndexDescriptor descriptor, Object value) {
        return ReadableDiffSets.Empty.ifNull(value == null ? this.getIndexUpdatesForScanOrSeek(descriptor.getLabelId(), descriptor.getPropertyKeyId()) : this.getIndexUpdatesForScanOrSeek(descriptor.getLabelId(), false, Property.property(descriptor.getPropertyKeyId(), value)));
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForRangeSeekByNumber(IndexDescriptor descriptor, Number lower, boolean includeLower, Number upper, boolean includeUpper) {
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdatesForRangeSeekByNumber(descriptor, lower, includeLower, upper, includeUpper));
    }

    private ReadableDiffSets<Long> getIndexUpdatesForRangeSeekByNumber(IndexDescriptor descriptor, Number lower, boolean includeLower, Number upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        DefinedProperty selectedUpper;
        boolean selectedIncludeLower;
        DefinedProperty selectedLower;
        TreeMap<DefinedProperty, DiffSets<Long>> sortedUpdates = this.getSortedIndexUpdates(descriptor);
        if (sortedUpdates == null) {
            return null;
        }
        int propertyKeyId = descriptor.getPropertyKeyId();
        if (lower == null) {
            selectedLower = DefinedProperty.numberProperty(propertyKeyId, PropertyValueComparison.SuperType.NUMBER.lowLimit.castValue(Number.class));
            selectedIncludeLower = PropertyValueComparison.SuperType.NUMBER.lowLimit.isInclusive;
        } else {
            selectedLower = Property.numberProperty(propertyKeyId, lower);
            selectedIncludeLower = includeLower;
        }
        if (upper == null) {
            selectedUpper = DefinedProperty.numberProperty(propertyKeyId, PropertyValueComparison.SuperType.NUMBER.highLimit.castValue(Number.class));
            selectedIncludeUpper = PropertyValueComparison.SuperType.NUMBER.highLimit.isInclusive;
        } else {
            selectedUpper = Property.numberProperty(propertyKeyId, upper);
            selectedIncludeUpper = includeUpper;
        }
        DiffSets<Long> diffs = new DiffSets<Long>();
        for (Map.Entry entry : sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper).entrySet()) {
            DiffSets diffSets = (DiffSets)entry.getValue();
            diffs.addAll(diffSets.getAdded().iterator());
            diffs.removeAll(diffSets.getRemoved().iterator());
        }
        return diffs;
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForRangeSeekByString(IndexDescriptor descriptor, String lower, boolean includeLower, String upper, boolean includeUpper) {
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdatesForRangeSeekByString(descriptor, lower, includeLower, upper, includeUpper));
    }

    private ReadableDiffSets<Long> getIndexUpdatesForRangeSeekByString(IndexDescriptor descriptor, String lower, boolean includeLower, String upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        DefinedProperty selectedUpper;
        boolean selectedIncludeLower;
        DefinedProperty selectedLower;
        TreeMap<DefinedProperty, DiffSets<Long>> sortedUpdates = this.getSortedIndexUpdates(descriptor);
        if (sortedUpdates == null) {
            return null;
        }
        int propertyKeyId = descriptor.getPropertyKeyId();
        if (lower == null) {
            selectedLower = DefinedProperty.stringProperty(propertyKeyId, PropertyValueComparison.SuperType.STRING.lowLimit.castValue(String.class));
            selectedIncludeLower = PropertyValueComparison.SuperType.STRING.lowLimit.isInclusive;
        } else {
            selectedLower = DefinedProperty.stringProperty(propertyKeyId, lower);
            selectedIncludeLower = includeLower;
        }
        if (upper == null) {
            selectedUpper = DefinedProperty.booleanProperty(propertyKeyId, PropertyValueComparison.SuperType.STRING.highLimit.castValue(Boolean.class));
            selectedIncludeUpper = PropertyValueComparison.SuperType.STRING.highLimit.isInclusive;
        } else {
            selectedUpper = DefinedProperty.stringProperty(propertyKeyId, upper);
            selectedIncludeUpper = includeUpper;
        }
        DiffSets<Long> diffs = new DiffSets<Long>();
        for (Map.Entry entry : sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper).entrySet()) {
            DiffSets diffSets = (DiffSets)entry.getValue();
            diffs.addAll(diffSets.getAdded().iterator());
            diffs.removeAll(diffSets.getRemoved().iterator());
        }
        return diffs;
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForRangeSeekByPrefix(IndexDescriptor descriptor, String prefix) {
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdatesForRangeSeekByPrefix(descriptor, prefix));
    }

    private ReadableDiffSets<Long> getIndexUpdatesForRangeSeekByPrefix(IndexDescriptor descriptor, String prefix) {
        Map.Entry<DefinedProperty, DiffSets<Long>> entry;
        DefinedProperty key;
        TreeMap<DefinedProperty, DiffSets<Long>> sortedUpdates = this.getSortedIndexUpdates(descriptor);
        if (sortedUpdates == null) {
            return null;
        }
        int propertyKeyId = descriptor.getPropertyKeyId();
        DefinedProperty floor = Property.stringProperty(propertyKeyId, prefix);
        DiffSets<Long> diffs = new DiffSets<Long>();
        Iterator<Map.Entry<DefinedProperty, DiffSets<Long>>> iterator = sortedUpdates.tailMap(floor).entrySet().iterator();
        while (iterator.hasNext() && (key = (entry = iterator.next()).getKey()).propertyKeyId() == propertyKeyId && key.value().toString().startsWith(prefix)) {
            DiffSets<Long> diffSets = entry.getValue();
            diffs.addAll(diffSets.getAdded().iterator());
            diffs.removeAll(diffSets.getRemoved().iterator());
        }
        return diffs;
    }

    private TreeMap<DefinedProperty, DiffSets<Long>> getSortedIndexUpdates(IndexDescriptor descriptor) {
        TreeMap<DefinedProperty, DiffSets<Long>> sortedUpdates;
        if (this.indexUpdates == null) {
            return null;
        }
        Map updates = (Map)this.indexUpdates.get(descriptor.getLabelId());
        if (updates == null) {
            return null;
        }
        if (updates instanceof TreeMap) {
            sortedUpdates = (TreeMap<DefinedProperty, DiffSets<Long>>)updates;
        } else {
            sortedUpdates = new TreeMap<DefinedProperty, DiffSets<Long>>(DefinedProperty.COMPARATOR);
            sortedUpdates.putAll(updates);
            this.indexUpdates.put(descriptor.getLabelId(), sortedUpdates);
        }
        return sortedUpdates;
    }

    @Override
    public void indexDoUpdateProperty(IndexDescriptor descriptor, long nodeId, DefinedProperty propertyBefore, DefinedProperty propertyAfter) {
        DiffSets<Long> after;
        DiffSets<Long> before = this.getIndexUpdatesForScanOrSeek(descriptor.getLabelId(), true, propertyBefore);
        if (before != null) {
            before.remove((Object)nodeId);
            if (before.getRemoved().contains(nodeId)) {
                this.getOrCreateNodeState(nodeId).addIndexDiff(before);
            } else {
                this.getOrCreateNodeState(nodeId).removeIndexDiff(before);
            }
        }
        if ((after = this.getIndexUpdatesForScanOrSeek(descriptor.getLabelId(), true, propertyAfter)) != null) {
            after.add((Object)nodeId);
            if (after.getAdded().contains(nodeId)) {
                this.getOrCreateNodeState(nodeId).addIndexDiff(after);
            } else {
                this.getOrCreateNodeState(nodeId).removeIndexDiff(after);
            }
        }
    }

    private DiffSets<Long> getIndexUpdatesForScanOrSeek(int label, boolean create, DefinedProperty property) {
        DiffSets diffs;
        HashMap updates;
        if (property == null) {
            return null;
        }
        if (this.indexUpdates == null) {
            if (!create) {
                return null;
            }
            this.indexUpdates = Primitive.intObjectMap();
        }
        if ((updates = (HashMap)this.indexUpdates.get(label)) == null) {
            if (!create) {
                return null;
            }
            updates = new HashMap();
            this.indexUpdates.put(label, updates);
        }
        if ((diffs = (DiffSets)updates.get(property)) == null && create) {
            diffs = new DiffSets();
            updates.put(property, diffs);
        }
        return diffs;
    }

    private DiffSets<Long> getIndexUpdatesForScanOrSeek(int label, int propertyKeyId) {
        if (this.indexUpdates == null) {
            return null;
        }
        Map updates = (Map)this.indexUpdates.get(label);
        if (updates == null) {
            return null;
        }
        DiffSets<Long> diffs = new DiffSets<Long>();
        for (Map.Entry entry : updates.entrySet()) {
            if (((DefinedProperty)entry.getKey()).propertyKeyId() != propertyKeyId) continue;
            diffs.addAll(((DiffSets)entry.getValue()).getAdded().iterator());
            diffs.removeAll(((DiffSets)entry.getValue()).getRemoved().iterator());
        }
        return diffs;
    }

    private Map<UniquenessConstraint, Long> createdConstraintIndexesByConstraint() {
        if (this.createdConstraintIndexesByConstraint == null) {
            this.createdConstraintIndexesByConstraint = new HashMap<UniquenessConstraint, Long>();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    private boolean hasNodeState(long nodeId) {
        return this.nodeStatesMap != null && this.nodeStatesMap.containsKey(nodeId);
    }

    private PropertyChanges nodePropertyChanges() {
        return this.propertyChangesForNodes == null ? (this.propertyChangesForNodes = new PropertyChanges()) : this.propertyChangesForNodes;
    }

    @Override
    public PrimitiveLongIterator augmentNodesGetAll(PrimitiveLongIterator committed) {
        return this.addedAndRemovedNodes().augment(committed);
    }

    @Override
    public RelationshipIterator augmentRelationshipsGetAll(RelationshipIterator committed) {
        return this.addedAndRemovedRelationships().augment(committed);
    }

    @Override
    public <EX extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EX> visitor) throws EX {
        return ((RelationshipState)RELATIONSHIP_STATE.get(this, relId)).accept(visitor);
    }

    @Override
    public boolean hasDataChanges() {
        return this.hasDataChanges;
    }

    private void recordNodeDeleted(long id) {
        if (this.nodesDeletedInTx == null) {
            this.nodesDeletedInTx = Primitive.longSet();
        }
        this.nodesDeletedInTx.add(id);
    }

    private void recordRelationshipDeleted(long id) {
        if (this.relationshipsDeletedInTx == null) {
            this.relationshipsDeletedInTx = Primitive.longSet();
        }
        this.relationshipsDeletedInTx.add(id);
    }

    static class ConstraintDiffSetsVisitor
    implements PropertyConstraint.ChangeVisitor,
    DiffSetsVisitor<PropertyConstraint> {
        private final TxStateVisitor visitor;

        ConstraintDiffSetsVisitor(TxStateVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visitAdded(PropertyConstraint element) throws CreateConstraintFailureException {
            element.added(this);
        }

        @Override
        public void visitRemoved(PropertyConstraint element) {
            element.removed(this);
        }

        @Override
        public void visitAddedUniquePropertyConstraint(UniquenessConstraint constraint) {
            this.visitor.visitAddedUniquePropertyConstraint(constraint);
        }

        @Override
        public void visitRemovedUniquePropertyConstraint(UniquenessConstraint constraint) {
            this.visitor.visitRemovedUniquePropertyConstraint(constraint);
        }

        @Override
        public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint constraint) throws CreateConstraintFailureException {
            this.visitor.visitAddedNodePropertyExistenceConstraint(constraint);
        }

        @Override
        public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint constraint) {
            this.visitor.visitRemovedNodePropertyExistenceConstraint(constraint);
        }

        @Override
        public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint constraint) throws CreateConstraintFailureException {
            this.visitor.visitAddedRelationshipPropertyExistenceConstraint(constraint);
        }

        @Override
        public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint constraint) {
            this.visitor.visitRemovedRelationshipPropertyExistenceConstraint(constraint);
        }
    }
}

