/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeConstraintDefinition;

public class NodePropertyExistenceConstraintDefinition
extends NodeConstraintDefinition {
    public NodePropertyExistenceConstraintDefinition(InternalSchemaActions actions, Label label, String propertyKey) {
        super(actions, label, propertyKey);
    }

    public void drop() {
        this.assertInUnterminatedTransaction();
        this.actions.dropNodePropertyExistenceConstraint(this.label, this.propertyKey);
    }

    public ConstraintType getConstraintType() {
        this.assertInUnterminatedTransaction();
        return ConstraintType.NODE_PROPERTY_EXISTENCE;
    }

    @Override
    public String toString() {
        return String.format("ON (%1$s:%2$s) ASSERT exists(%1$s.%3$s)", this.label.name().toLowerCase(), this.label.name(), this.propertyKey);
    }
}

