/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockClient;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;

public class CommunityLockManger
implements Locks {
    private final LockManagerImpl manager = new LockManagerImpl(new RagManager());
    private volatile boolean closed;

    @Override
    public Locks.Client newClient() {
        if (this.closed) {
            throw new IllegalStateException(this + " already closed");
        }
        return new CommunityLockClient(this.manager);
    }

    @Override
    public void accept(Locks.Visitor visitor) {
        this.manager.accept((Visitor<RWLock, RuntimeException>)((Visitor)element -> {
            Object resource = element.resource();
            if (resource instanceof LockResource) {
                LockResource lockResource = (LockResource)resource;
                visitor.visit(lockResource.type(), lockResource.resourceId(), element.describe(), element.maxWaitTime(), System.identityHashCode(lockResource));
            }
            return false;
        }));
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

