/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.pagecache.ConfigurablePageSwapperFactory;
import org.neo4j.kernel.impl.util.OsBeanUtil;
import org.neo4j.logging.Log;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class ConfiguringPageCacheFactory {
    private static final int pageSize = FeatureToggles.getInteger(ConfiguringPageCacheFactory.class, (String)"pageSize", (int)8192);
    private final PageSwapperFactory swapperFactory;
    private final Config config;
    private final PageCacheTracer tracer;
    private final Log log;
    private PageCache pageCache;

    public ConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer tracer, Log log) {
        this.swapperFactory = this.createAndConfigureSwapperFactory(fs, config, log);
        this.config = config;
        this.tracer = tracer;
        this.log = log;
    }

    private PageSwapperFactory createAndConfigureSwapperFactory(FileSystemAbstraction fs, Config config, Log log) {
        String desiredImplementation = config.get(GraphDatabaseSettings.pagecache_swapper);
        if (desiredImplementation != null) {
            for (PageSwapperFactory factory : Service.load(PageSwapperFactory.class)) {
                if (!factory.implementationName().equals(desiredImplementation)) continue;
                factory.setFileSystemAbstraction(fs);
                if (factory instanceof ConfigurablePageSwapperFactory) {
                    ConfigurablePageSwapperFactory configurableFactory = (ConfigurablePageSwapperFactory)factory;
                    configurableFactory.configure(config);
                }
                log.info("Configured " + GraphDatabaseSettings.pagecache_swapper.name() + ": " + desiredImplementation);
                return factory;
            }
            throw new IllegalArgumentException("Cannot find PageSwapperFactory: " + desiredImplementation);
        }
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory();
        factory.setFileSystemAbstraction(fs);
        return factory;
    }

    public synchronized PageCache getOrCreatePageCache() {
        if (this.pageCache == null) {
            this.pageCache = this.createPageCache();
        }
        return this.pageCache;
    }

    protected PageCache createPageCache() {
        int cachePageSize = this.calculatePageSize(this.config, this.swapperFactory);
        int maxPages = this.calculateMaxPages(this.config, cachePageSize);
        return new MuninnPageCache(this.swapperFactory, maxPages, cachePageSize, this.tracer);
    }

    public int calculateMaxPages(Config config, int cachePageSize) {
        long maxHeap;
        Long pageCacheMemorySetting = config.get(GraphDatabaseSettings.pagecache_memory);
        long pageCacheMemory = this.interpretMemorySetting(pageCacheMemorySetting);
        if (pageCacheMemory / (maxHeap = Runtime.getRuntime().maxMemory()) > 100L) {
            this.log.warn("The memory configuration looks unbalanced. It is generally recommended to have at least 10 KiB of heap memory, for every 1 MiB of page cache memory. The current configuration is allocating %s bytes for the page cache, and %s bytes for the heap.", new Object[]{pageCacheMemory, maxHeap});
        }
        long pageCount = pageCacheMemory / (long)cachePageSize;
        return (int)Math.min(2147481647L, pageCount);
    }

    private long interpretMemorySetting(Long pageCacheMemorySetting) {
        if (pageCacheMemorySetting != null) {
            return pageCacheMemorySetting;
        }
        long heuristic = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory();
        this.log.warn("The " + GraphDatabaseSettings.pagecache_memory.name() + " setting has not been configured. It is recommended that this setting is always explicitly configured, to ensure the system has a balanced configuration. Until then, a computed heuristic value of " + heuristic + " bytes will be used instead. ");
        return heuristic;
    }

    public static long defaultHeuristicPageCacheMemory() {
        long maxHeapMemory;
        String defaultMemoryOverride = System.getProperty("dbms.pagecache.memory.default.override");
        if (defaultMemoryOverride != null) {
            return Settings.BYTES.apply(defaultMemoryOverride);
        }
        double ratioOfFreeMem = 0.5;
        String defaultMemoryRatioOverride = System.getProperty("dbms.pagecache.memory.ratio.default.override");
        if (defaultMemoryRatioOverride != null) {
            ratioOfFreeMem = Double.parseDouble(defaultMemoryRatioOverride);
        }
        if (0L < (maxHeapMemory = Runtime.getRuntime().maxMemory()) && maxHeapMemory < Long.MAX_VALUE) {
            try {
                long physicalMemory = OsBeanUtil.getTotalPhysicalMemory();
                if (0L < physicalMemory && physicalMemory < Long.MAX_VALUE && maxHeapMemory < physicalMemory) {
                    long heuristic = (long)((double)(physicalMemory - maxHeapMemory) * ratioOfFreeMem);
                    long min = ByteUnit.mebiBytes((long)32L);
                    long max = Math.min(maxHeapMemory * 70L, ByteUnit.gibiBytes((long)20L));
                    long memory = Math.min(max, Math.max(min, heuristic));
                    return memory;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ByteUnit.gibiBytes((long)2L);
    }

    public int calculatePageSize(Config config, PageSwapperFactory swapperFactory) {
        if (config.get(GraphDatabaseSettings.mapped_memory_page_size).intValue() != 0) {
            this.log.warn("The setting unsupported.dbms.memory.pagecache.pagesize does not have any effect. It is deprecated and will be removed in a future version.");
        }
        if (swapperFactory.isCachePageSizeHintStrict()) {
            return swapperFactory.getCachePageSizeHint();
        }
        return pageSize;
    }

    public void dumpConfiguration() {
        int cachePageSize = this.calculatePageSize(this.config, this.swapperFactory);
        long maxPages = this.calculateMaxPages(this.config, cachePageSize);
        long totalPhysicalMemory = OsBeanUtil.getTotalPhysicalMemory();
        String totalPhysicalMemMb = totalPhysicalMemory == -1L ? "?" : "" + ByteUnit.Byte.toMebiBytes(totalPhysicalMemory);
        long maxVmUsageMb = ByteUnit.Byte.toMebiBytes(Runtime.getRuntime().maxMemory());
        long pageCacheMb = ByteUnit.Byte.toMebiBytes(maxPages * (long)cachePageSize);
        String msg = "Physical mem: " + totalPhysicalMemMb + " MiB, Heap size: " + maxVmUsageMb + " MiB, Page cache size: " + pageCacheMb + " MiB.";
        this.log.info(msg);
    }
}

