/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreHeaderFormat;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.string.UTF8;

public abstract class CommonAbstractStore<RECORD extends AbstractBaseRecord, HEADER extends StoreHeader>
implements RecordStore<RECORD>,
AutoCloseable {
    public static final String UNKNOWN_VERSION = "Unknown";
    protected final Config configuration;
    protected final PageCache pageCache;
    protected final File storageFileName;
    protected final IdType idType;
    protected final IdGeneratorFactory idGeneratorFactory;
    protected final Log log;
    protected PagedFile storeFile;
    protected final String storeVersion;
    protected final RecordFormat<RECORD> recordFormat;
    private IdGenerator idGenerator;
    private boolean storeOk = true;
    private Throwable causeOfStoreNotOk;
    private final String typeDescriptor;
    protected int recordSize;
    private final StoreHeaderFormat<HEADER> storeHeaderFormat;
    private HEADER storeHeader;
    private final OpenOption[] openOptions;

    public CommonAbstractStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, String typeDescriptor, RecordFormat<RECORD> recordFormat, StoreHeaderFormat<HEADER> storeHeaderFormat, String storeVersion, OpenOption ... openOptions) {
        this.storageFileName = fileName;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.idType = idType;
        this.typeDescriptor = typeDescriptor;
        this.recordFormat = recordFormat;
        this.storeHeaderFormat = storeHeaderFormat;
        this.storeVersion = storeVersion;
        this.openOptions = openOptions;
        this.log = logProvider.getLog(this.getClass());
    }

    void initialise(boolean createIfNotExists) {
        try {
            this.checkStorage(createIfNotExists);
            this.loadStorage();
        }
        catch (Exception e) {
            if (this.storeFile != null) {
                try {
                    this.closeStoreFile();
                }
                catch (IOException failureToClose) {
                    e.addSuppressed(failureToClose);
                }
            }
            throw Exceptions.launderedException(e);
        }
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    protected void checkStorage(boolean createIfNotExists) {
        int pageSize = this.pageCache.pageSize();
        try {
            PagedFile ignore = this.pageCache.map(this.storageFileName, pageSize, new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE});
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            if (createIfNotExists) {
                try (PagedFile file = this.pageCache.map(this.storageFileName, pageSize, new OpenOption[]{StandardOpenOption.CREATE});){
                    this.initialiseNewStoreFile(file);
                    return;
                }
                catch (IOException e1) {
                    e.addSuppressed(e1);
                }
            }
            throw new StoreNotFoundException("Store file not found: " + this.storageFileName, e);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open store file: " + this.storageFileName, e);
        }
    }

    protected void initialiseNewStoreFile(PagedFile file) throws IOException {
        if (this.getNumberOfReservedLowIds() > 0) {
            try (PageCursor pageCursor = file.io(0L, 2);){
                if (pageCursor.next()) {
                    do {
                        pageCursor.setOffset(0);
                        this.createHeaderRecord(pageCursor);
                    } while (pageCursor.shouldRetry());
                    if (pageCursor.checkAndClearBoundsFlag()) {
                        throw new UnderlyingStorageException("Out of page bounds when writing header; page size too small: " + this.pageCache.pageSize() + " bytes.");
                    }
                }
            }
        }
        this.recordSize = this.determineRecordSize();
        File idFileName = new File(this.storageFileName.getPath() + ".id");
        this.idGeneratorFactory.create(idFileName, this.getNumberOfReservedLowIds(), true);
    }

    protected void createHeaderRecord(PageCursor cursor) throws IOException {
        int offset = cursor.getOffset();
        this.storeHeaderFormat.writeHeader(cursor);
        cursor.setOffset(offset);
        this.readHeaderAndInitializeRecordFormat(cursor);
    }

    protected void loadStorage() {
        try {
            this.extractHeaderRecord();
            int filePageSize = this.pageCache.pageSize() - this.pageCache.pageSize() % this.getRecordSize();
            this.storeFile = this.pageCache.map(this.getStorageFileName(), filePageSize, this.openOptions);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.loadIdGenerator();
    }

    private void extractHeaderRecord() throws IOException {
        block28: {
            if (this.getNumberOfReservedLowIds() > 0) {
                try (PagedFile pagedFile = this.pageCache.map(this.getStorageFileName(), this.pageCache.pageSize(), new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE});
                     PageCursor pageCursor = pagedFile.io(0L, 1);){
                    if (pageCursor.next()) {
                        do {
                            pageCursor.setOffset(0);
                            this.readHeaderAndInitializeRecordFormat(pageCursor);
                        } while (pageCursor.shouldRetry());
                        if (pageCursor.checkAndClearBoundsFlag()) {
                            throw new UnderlyingStorageException("Out of page bounds when reading header; page size too small: " + this.pageCache.pageSize() + " bytes.");
                        }
                    }
                    break block28;
                }
            }
            this.readHeaderAndInitializeRecordFormat(null);
        }
        this.recordSize = this.determineRecordSize();
    }

    protected long pageIdForRecord(long id) {
        return RecordPageLocationCalculator.pageIdForRecord(id, this.storeFile.pageSize(), this.recordSize);
    }

    protected int offsetForId(long id) {
        return RecordPageLocationCalculator.offsetForId(id, this.storeFile.pageSize(), this.recordSize);
    }

    @Override
    public int getRecordsPerPage() {
        return this.storeFile.pageSize() / this.recordSize;
    }

    public byte[] getRawRecordData(long id) throws IOException {
        byte[] data = new byte[this.recordSize];
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            if (cursor.next()) {
                do {
                    cursor.setOffset(offset);
                    cursor.getBytes(data);
                } while (cursor.shouldRetry());
                this.checkForDecodingErrors(cursor, id, RecordLoad.CHECK);
            }
        }
        return data;
    }

    private void readHeaderAndInitializeRecordFormat(PageCursor cursor) throws IOException {
        this.storeHeader = this.storeHeaderFormat.readHeader(cursor);
    }

    private void loadIdGenerator() {
        try {
            if (this.storeOk) {
                this.openIdGenerator();
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk(e);
        }
        finally {
            if (!this.getStoreOk()) {
                this.log.debug(this.getStorageFileName() + " non clean shutdown detected");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInUse(long id) {
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            boolean recordIsInUse = false;
            if (cursor.next()) {
                do {
                    cursor.setOffset(offset);
                    recordIsInUse = this.isInUse(cursor);
                } while (cursor.shouldRetry());
                this.checkForDecodingErrors(cursor, id, RecordLoad.NORMAL);
            }
            boolean bl = recordIsInUse;
            return bl;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    final void rebuildIdGenerator() {
        boolean fastRebuild;
        long defraggedCount;
        block16: {
            int blockSize = this.getRecordSize();
            if (blockSize <= 0) {
                throw new InvalidRecordException("Illegal blockSize: " + blockSize);
            }
            this.log.info("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
            this.closeIdGenerator();
            this.createIdGenerator(this.getIdFileName());
            this.openIdGenerator();
            defraggedCount = 0L;
            fastRebuild = this.isOnlyFastIdGeneratorRebuildEnabled(this.configuration);
            try {
                long foundHighId = this.scanForHighId();
                this.setHighId(foundHighId);
                if (fastRebuild) break block16;
                try (PageCursor cursor = this.storeFile.io(0L, 10);){
                    defraggedCount = this.rebuildIdGeneratorSlow(cursor, this.getRecordsPerPage(), blockSize, foundHighId);
                }
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
            }
        }
        this.log.info("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.log.info(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount);
        if (!fastRebuild) {
            this.closeIdGenerator();
            this.openIdGenerator();
        }
    }

    protected boolean isOnlyFastIdGeneratorRebuildEnabled(Config config) {
        return config.get(Configuration.rebuild_idgenerators_fast);
    }

    private long rebuildIdGeneratorSlow(PageCursor cursor, int recordsPerPage, int blockSize, long foundHighId) throws IOException {
        long defragCount = 0L;
        long[] freedBatch = new long[recordsPerPage];
        int startingId = this.getNumberOfReservedLowIds();
        boolean done = false;
        while (!done && cursor.next()) {
            int i;
            int defragged;
            long idPageOffset = cursor.getCurrentPageId() * (long)recordsPerPage;
            block1: do {
                defragged = 0;
                done = false;
                for (i = startingId; i < recordsPerPage; ++i) {
                    int offset = i * blockSize;
                    cursor.setOffset(offset);
                    long recordId = idPageOffset + (long)i;
                    if (recordId >= foundHighId) {
                        done = true;
                        continue block1;
                    }
                    if (!this.isInUse(cursor)) {
                        freedBatch[defragged++] = recordId;
                        continue;
                    }
                    if (!this.isRecordReserved(cursor)) continue;
                    cursor.setOffset(offset);
                    cursor.putByte(Record.NOT_IN_USE.byteValue());
                    cursor.putInt(0);
                    freedBatch[defragged++] = recordId;
                }
            } while (cursor.shouldRetry());
            this.checkIdScanCursorBounds(cursor);
            for (i = 0; i < defragged; ++i) {
                this.freeId(freedBatch[i]);
            }
            defragCount += (long)defragged;
            startingId = 0;
        }
        return defragCount;
    }

    private void checkIdScanCursorBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new UnderlyingStorageException("Out of bounds access on page " + cursor.getCurrentPageId() + " detected while scanning the " + this.storageFileName + " file for deleted records");
        }
    }

    protected void setStoreNotOk(Throwable cause) {
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
        this.idGenerator = null;
    }

    protected boolean getStoreOk() {
        return this.storeOk;
    }

    protected void checkStoreOk() {
        if (!this.storeOk) {
            throw Exceptions.launderedException(this.causeOfStoreNotOk);
        }
    }

    @Override
    public long nextId() {
        if (this.idGenerator == null) {
            throw new IllegalStateException("IdGenerator is not initialized");
        }
        return this.idGenerator.nextId();
    }

    public void freeId(long id) {
        IdGenerator generator = this.idGenerator;
        if (generator != null) {
            generator.freeId(id);
        }
    }

    @Override
    public long getHighId() {
        return this.idGenerator != null ? this.idGenerator.getHighId() : this.scanForHighId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighId(long highId) {
        IdGenerator generator = this.idGenerator;
        if (generator != null) {
            IdGenerator idGenerator = generator;
            synchronized (idGenerator) {
                if (highId > generator.getHighId()) {
                    generator.setHighId(highId);
                }
            }
        }
    }

    public void makeStoreOk() {
        if (!this.storeOk) {
            this.rebuildIdGenerator();
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
    }

    @Override
    public File getStorageFileName() {
        return this.storageFileName;
    }

    private File getIdFileName() {
        return new File(this.getStorageFileName().getPath() + ".id");
    }

    protected void openIdGenerator() {
        this.idGenerator = this.idGeneratorFactory.open(this.getIdFileName(), this.getIdType(), this.scanForHighId(), this.recordFormat.getMaxId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long scanForHighId() {
        try (PageCursor cursor = this.storeFile.io(0L, 1);){
            byte[] expectedLegacyVersionBytes = UTF8.encode((String)(this.typeDescriptor + " " + this.storeVersion));
            long nextPageId = this.storeFile.getLastPageId();
            int recordsPerPage = this.getRecordsPerPage();
            int recordSize = this.getRecordSize();
            long highestId = this.getNumberOfReservedLowIds();
            while (nextPageId >= 0L && cursor.next(nextPageId)) {
                boolean found;
                --nextPageId;
                block15: do {
                    found = false;
                    int currentRecord = recordsPerPage;
                    while (currentRecord-- > 0) {
                        boolean justLegacyStoreTrailer;
                        int offset = currentRecord * recordSize;
                        cursor.setOffset(offset);
                        long recordId = cursor.getCurrentPageId() * (long)recordsPerPage + (long)currentRecord;
                        if (!this.isInUse(cursor) || (justLegacyStoreTrailer = this.isJustLegacyStoreTrailer(cursor, offset, expectedLegacyVersionBytes, recordSize))) continue;
                        highestId = recordId + 1L;
                        found = true;
                        continue block15;
                    }
                } while (cursor.shouldRetry());
                this.checkIdScanCursorBounds(cursor);
                if (!found) continue;
                long l = highestId;
                return l;
            }
            long l = this.getNumberOfReservedLowIds();
            return l;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to find high id by scanning backwards " + this.getStorageFileName(), e);
        }
    }

    private boolean isJustLegacyStoreTrailer(PageCursor cursor, int offset, byte[] expectedVersionBytes, int recordSize) {
        try {
            int i = 0;
            while (i < expectedVersionBytes.length) {
                boolean mismatch = false;
                for (int j = 0; i < expectedVersionBytes.length && j < recordSize; ++i, ++j) {
                    byte b = cursor.getByte(offset + j);
                    if (b == expectedVersionBytes[i]) continue;
                    mismatch = true;
                }
                if (mismatch) continue;
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    protected int determineRecordSize() {
        return this.recordFormat.getRecordSize((StoreHeader)this.storeHeader);
    }

    @Override
    public final int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public int getRecordDataSize() {
        return this.recordSize - this.recordFormat.getRecordHeaderSize();
    }

    private boolean isInUse(PageCursor cursor) {
        return this.recordFormat.isInUse(cursor);
    }

    protected boolean isRecordReserved(PageCursor cursor) {
        return false;
    }

    protected void createIdGenerator(File fileName) {
        this.idGeneratorFactory.create(fileName, 0L, false);
    }

    protected void closeIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.close();
        }
    }

    @Override
    public void flush() {
        try {
            this.storeFile.flushAndForce();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", e);
        }
    }

    protected void assertNotClosed() {
        if (this.storeFile == null) {
            throw new IllegalStateException(this + " for file '" + this.storageFileName + "' is closed");
        }
    }

    @Override
    public void close() {
        try {
            this.closeStoreFile();
        }
        catch (IOException | IllegalStateException e) {
            throw new UnderlyingStorageException("Failed to close store file: " + this.getStorageFileName(), e);
        }
    }

    private void closeStoreFile() throws IOException {
        try {
            this.storeFile.close();
            if (this.idGenerator != null) {
                if (ArrayUtil.contains(this.openOptions, StandardOpenOption.DELETE_ON_CLOSE)) {
                    this.idGenerator.delete();
                } else {
                    this.idGenerator.close();
                }
            }
        }
        finally {
            this.storeFile = null;
        }
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.idGenerator != null ? this.idGenerator.getHighestPossibleIdInUse() : this.scanForHighId() - 1L;
    }

    @Override
    public void setHighestPossibleIdInUse(long highId) {
        this.setHighId(highId + 1L);
    }

    public long getNumberOfIdsInUse() {
        if (this.idGenerator == null) {
            throw new IllegalStateException("IdGenerator is not initialized");
        }
        return this.idGenerator.getNumberOfIdsInUse();
    }

    @Override
    public int getNumberOfReservedLowIds() {
        return this.storeHeaderFormat.numberOfReservedRecords();
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void logVersions(Logger logger) {
        logger.log("  " + this.getTypeDescriptor() + " " + this.storeVersion);
    }

    public void logIdUsage(Logger logger) {
        logger.log(String.format("  %s: used=%s high=%s", this.getTypeDescriptor(), this.getNumberOfIdsInUse(), this.getHighestPossibleIdInUse()));
    }

    public void visitStore(Visitor<CommonAbstractStore<RECORD, HEADER>, RuntimeException> visitor) {
        visitor.visit((Object)this);
    }

    final void deleteIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.delete();
            this.idGenerator = null;
            this.setStoreNotOk(new IllegalStateException("IdGenerator is not initialized"));
        }
    }

    @Override
    public long getNextRecordReference(RECORD record) {
        return this.recordFormat.getNextRecordReference(record);
    }

    @Override
    public RECORD newRecord() {
        return this.recordFormat.newRecord();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RECORD getRecord(long id, RECORD record, RecordLoad mode) {
        ((AbstractBaseRecord)record).setId(id);
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            this.readIntoRecord(id, record, mode, pageId, offset, cursor);
            RECORD RECORD = record;
            return RECORD;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void readIntoRecord(long id, RECORD record, RecordLoad mode, long pageId, int offset, PageCursor cursor) throws IOException {
        if (cursor.next(pageId)) {
            do {
                this.prepareForReading(cursor, offset, record);
                this.recordFormat.read(record, cursor, mode, this.recordSize);
            } while (cursor.shouldRetry());
            this.checkForDecodingErrors(cursor, id, mode);
            this.verifyAfterReading(record, mode);
        } else {
            this.verifyAfterNotRead(record, mode);
        }
    }

    @Override
    public void updateRecord(RECORD record) {
        long id = ((AbstractBaseRecord)record).getId();
        IdValidator.assertValidId(id, this.recordFormat.getMaxId());
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 2);){
            if (cursor.next()) {
                do {
                    cursor.setOffset(offset);
                    this.recordFormat.write(record, cursor, this.recordSize);
                } while (cursor.shouldRetry());
                this.checkForDecodingErrors(cursor, id, RecordLoad.NORMAL);
                if (!((AbstractBaseRecord)record).inUse()) {
                    this.freeId(id);
                }
                if (!(((AbstractBaseRecord)record).inUse() && ((AbstractBaseRecord)record).requiresSecondaryUnit() || !((AbstractBaseRecord)record).hasSecondaryUnitId())) {
                    this.freeId(((AbstractBaseRecord)record).getSecondaryUnitId());
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void prepareForCommit(RECORD record) {
        if (((AbstractBaseRecord)record).inUse()) {
            this.recordFormat.prepare(record, this.recordSize, this);
        }
    }

    @Override
    public <EXCEPTION extends Exception> void scanAllRecords(Visitor<RECORD, EXCEPTION> visitor) throws EXCEPTION {
        try (RecordCursor<RECORD> cursor = this.newRecordCursor(this.newRecord());){
            long highId = this.getHighId();
            cursor.acquire(this.getNumberOfReservedLowIds(), RecordLoad.CHECK);
            for (long id = (long)this.getNumberOfReservedLowIds(); id < highId; ++id) {
                if (!cursor.next(id)) continue;
                visitor.visit(cursor.get());
            }
        }
    }

    @Override
    public Collection<RECORD> getRecords(long firstId, RecordLoad mode) {
        try (RecordCursor<RECORD> cursor = this.newRecordCursor(this.newRecord());){
            cursor.acquire(firstId, mode);
            List<RECORD> list = cursor.getAll();
            return list;
        }
    }

    @Override
    public RecordCursor<RECORD> newRecordCursor(RECORD record) {
        return new RecordCursor<RECORD>((AbstractBaseRecord)record){
            private long currentId;
            private RecordLoad mode;
            private PageCursor pageCursor;
            final /* synthetic */ AbstractBaseRecord val$record;
            {
                this.val$record = abstractBaseRecord;
            }

            @Override
            public boolean next() {
                try {
                    boolean bl = this.next(this.currentId, (RECORD)this.val$record, this.mode);
                    return bl;
                }
                finally {
                    this.currentId = CommonAbstractStore.this.getNextRecordReference(this.val$record);
                }
            }

            @Override
            public boolean next(long id) {
                return this.next(id, (RECORD)this.val$record, this.mode);
            }

            @Override
            public boolean next(long id, RECORD record, RecordLoad mode) {
                assert (this.pageCursor != null) : "Not initialized";
                if (Record.NULL_REFERENCE.is(id)) {
                    ((AbstractBaseRecord)record).clear();
                    ((AbstractBaseRecord)record).setId(Record.NULL_REFERENCE.intValue());
                    return false;
                }
                try {
                    ((AbstractBaseRecord)record).setId(id);
                    long pageId = CommonAbstractStore.this.pageIdForRecord(id);
                    int offset = CommonAbstractStore.this.offsetForId(id);
                    CommonAbstractStore.this.readIntoRecord(this.currentId, record, mode, pageId, offset, this.pageCursor);
                    return ((AbstractBaseRecord)record).inUse();
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException(e);
                }
            }

            @Override
            public void placeAt(long id, RecordLoad mode) {
                this.currentId = id;
                this.mode = mode;
            }

            public void close() {
                assert (this.pageCursor != null);
                this.pageCursor.close();
                this.pageCursor = null;
            }

            public RECORD get() {
                return this.val$record;
            }

            @Override
            public RecordCursor<RECORD> acquire(long id, RecordLoad mode) {
                assert (this.pageCursor == null);
                this.currentId = id;
                this.mode = mode;
                try {
                    this.pageCursor = CommonAbstractStore.this.storeFile.io(CommonAbstractStore.this.pageIdForRecord(id), 1);
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException(e);
                }
                return this;
            }
        };
    }

    protected void verifyAfterNotRead(RECORD record, RecordLoad mode) {
        ((AbstractBaseRecord)record).clear();
        mode.verify((AbstractBaseRecord)record);
    }

    protected final void checkForDecodingErrors(PageCursor cursor, long recordId, RecordLoad mode) {
        if (mode.checkForOutOfBounds(cursor)) {
            this.throwOutOfBoundsException(recordId);
        }
        mode.clearOrThrowCursorError(cursor);
    }

    private void throwOutOfBoundsException(long recordId) {
        RECORD record = this.newRecord();
        ((AbstractBaseRecord)record).setId(recordId);
        long pageId = this.pageIdForRecord(recordId);
        int offset = this.offsetForId(recordId);
        throw new UnderlyingStorageException(CommonAbstractStore.buildOutOfBoundsExceptionMessage(record, pageId, offset, this.recordSize, this.storeFile.pageSize(), this.storageFileName.getAbsolutePath()));
    }

    protected static String buildOutOfBoundsExceptionMessage(AbstractBaseRecord record, long pageId, int offset, int recordSize, int pageSize, String filename) {
        return "Access to record " + record + " went out of bounds of the page. The record size is " + recordSize + " bytes, and the access was at offset " + offset + " bytes into page " + pageId + ", and the pages have a capacity of " + pageSize + " bytes. The mapped store file in question is " + filename;
    }

    protected final void verifyAfterReading(RECORD record, RecordLoad mode) {
        if (!mode.verify((AbstractBaseRecord)record)) {
            ((AbstractBaseRecord)record).clear();
        }
    }

    protected final void prepareForReading(PageCursor cursor, int offset, RECORD record) {
        ((AbstractBaseRecord)record).setInUse(false);
        cursor.setOffset(offset);
    }

    @Override
    public void ensureHeavy(RECORD record) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getStoreHeaderInt() {
        return ((IntStoreHeader)this.storeHeader).value();
    }

    public static abstract class Configuration {
        public static final Setting<Boolean> rebuild_idgenerators_fast = GraphDatabaseSettings.rebuild_idgenerators_fast;
    }
}

