/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;

public class LabelIdArray {
    static long[] concatAndSort(long[] existing, long additional) {
        LabelIdArray.assertNotContains(existing, additional);
        long[] result = new long[existing.length + 1];
        System.arraycopy(existing, 0, result, 0, existing.length);
        result[existing.length] = additional;
        Arrays.sort(result);
        return result;
    }

    private static void assertNotContains(long[] existingLabels, long labelId) {
        if (Arrays.binarySearch(existingLabels, labelId) >= 0) {
            throw new IllegalStateException("Label " + labelId + " already exists.");
        }
    }

    static long[] filter(long[] ids, long excludeId) {
        boolean found = false;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] != excludeId) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Label " + excludeId + " not found.");
        }
        long[] result = new long[ids.length - 1];
        int writerIndex = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == excludeId) continue;
            result[writerIndex++] = ids[i];
        }
        return result;
    }

    public static long[] prependNodeId(long nodeId, long[] labelIds) {
        long[] result = new long[labelIds.length + 1];
        System.arraycopy(labelIds, 0, result, 1, labelIds.length);
        result[0] = nodeId;
        return result;
    }

    public static long[] stripNodeId(long[] storedLongs) {
        return Arrays.copyOfRange(storedLongs, 1, storedLongs.length);
    }
}

