/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.neo4j.kernel.impl.store.kvstore.ActiveState;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueMerger;
import org.neo4j.kernel.impl.store.kvstore.PrototypeState;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;
import org.neo4j.kernel.impl.store.kvstore.State;
import org.neo4j.kernel.impl.store.kvstore.ValueSink;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

class ConcurrentMapState<Key>
extends ActiveState<Key> {
    private final ConcurrentMap<Key, byte[]> changes;
    private final File file;
    private final AtomicLong highestAppliedVersion;
    private final AtomicLong appliedChanges;
    private final AtomicBoolean hasTrackedChanges;
    private final long previousVersion;

    ConcurrentMapState(ReadableState<Key> store, File file) {
        super(store);
        this.previousVersion = store.version();
        this.file = file;
        this.highestAppliedVersion = new AtomicLong(this.previousVersion);
        this.changes = new ConcurrentHashMap<Key, byte[]>();
        this.appliedChanges = new AtomicLong();
        this.hasTrackedChanges = new AtomicBoolean();
    }

    private ConcurrentMapState(Prototype<Key> prototype, ReadableState<Key> store, File file) {
        super(store);
        this.previousVersion = store.version();
        this.file = file;
        this.hasTrackedChanges = prototype.hasTrackedChanges;
        this.changes = prototype.changes;
        this.highestAppliedVersion = prototype.highestAppliedVersion;
        this.appliedChanges = prototype.appliedChanges;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.file + "]";
    }

    @Override
    public EntryUpdater<Key> updater(long version, Lock lock) {
        if (version <= this.previousVersion) {
            return EntryUpdater.noUpdates();
        }
        ConcurrentMapState.update(this.highestAppliedVersion, version);
        this.hasTrackedChanges.set(true);
        return new Updater<Key>(lock, this.store, this.changes, this.appliedChanges);
    }

    @Override
    public EntryUpdater<Key> unsafeUpdater(Lock lock) {
        this.hasTrackedChanges.set(true);
        return new Updater<Key>(lock, this.store, this.changes, null);
    }

    @Override
    protected long storedVersion() {
        return this.previousVersion;
    }

    @Override
    protected EntryUpdater<Key> resettingUpdater(Lock lock, final Runnable closeAction) {
        if (this.hasChanges()) {
            throw new IllegalStateException("Cannot reset when there are changes!");
        }
        return new EntryUpdater<Key>(lock){

            @Override
            public void apply(Key key, ValueUpdate update) throws IOException {
                this.ensureOpen();
                ConcurrentMapState.applyUpdate(ConcurrentMapState.this.store, ConcurrentMapState.this.changes, key, update, true);
            }

            @Override
            public void close() {
                try {
                    closeAction.run();
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    protected PrototypeState<Key> prototype(long version) {
        return new Prototype(this, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static <Key> void applyUpdate(ReadableState<Key> store, ConcurrentMap<Key, byte[]> changes, Key key, ValueUpdate update, boolean reset) throws IOException {
        byte[] value = (byte[])changes.get(key);
        if (value == null) {
            byte[] proposal;
            byte[] byArray = proposal = new byte[store.keyFormat().valueSize()];
            // MONITORENTER : proposal
            value = changes.putIfAbsent(key, proposal);
            if (value == null) {
                PreviousValue lookup;
                BigEndianByteArrayBuffer buffer = new BigEndianByteArrayBuffer(proposal);
                if (!reset && !store.lookup(key, lookup = new PreviousValue(proposal))) {
                    buffer.clear();
                }
                update.update(buffer);
                // MONITOREXIT : byArray
                return;
            }
            // MONITOREXIT : byArray
        }
        byte[] byArray = value;
        // MONITORENTER : value
        BigEndianByteArrayBuffer target = new BigEndianByteArrayBuffer(value);
        if (reset) {
            target.clear();
        }
        update.update(target);
        // MONITOREXIT : byArray
    }

    private static void update(AtomicLong highestAppliedVersion, long version) {
        long high;
        do {
            if (version > (high = highestAppliedVersion.get())) continue;
            return;
        } while (!highestAppliedVersion.compareAndSet(high, version));
    }

    @Override
    protected long version() {
        return this.highestAppliedVersion.get();
    }

    @Override
    protected long applied() {
        return this.appliedChanges.get();
    }

    @Override
    protected boolean hasChanges() {
        return this.hasTrackedChanges.get() && !this.changes.isEmpty();
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    @Override
    protected File file() {
        return this.file;
    }

    @Override
    protected ActiveState.Factory factory() {
        return State.Strategy.CONCURRENT_HASH_MAP;
    }

    @Override
    protected boolean lookup(Key key, ValueSink sink) throws IOException {
        return ConcurrentMapState.performLookup(this.store, this.changes, key, sink);
    }

    private static <Key> boolean performLookup(ReadableState<Key> store, ConcurrentMap<Key, byte[]> changes, Key key, ValueSink sink) throws IOException {
        byte[] value = (byte[])changes.get(key);
        if (value != null) {
            sink.value(new BigEndianByteArrayBuffer(value));
            return true;
        }
        return store.lookup(key, sink);
    }

    @Override
    public DataProvider dataProvider() throws IOException {
        return ConcurrentMapState.dataProvider(this.store, this.changes);
    }

    private static <Key> DataProvider dataProvider(ReadableState<Key> store, ConcurrentMap<Key, byte[]> changes) throws IOException {
        if (changes.isEmpty()) {
            return store.dataProvider();
        }
        KeyFormat<Key> keys = store.keyFormat();
        return new KeyValueMerger(store.dataProvider(), new UpdateProvider(ConcurrentMapState.sortedUpdates(keys, changes)), keys.keySize(), keys.valueSize());
    }

    private static <Key> byte[][] sortedUpdates(KeyFormat<Key> keys, ConcurrentMap<Key, byte[]> changes) {
        Object[] buffer = new Entry[changes.size()];
        Iterator entries = changes.entrySet().iterator();
        for (int i = 0; i < buffer.length; ++i) {
            Map.Entry next = entries.next();
            byte[] key = new byte[keys.keySize()];
            keys.writeKey(next.getKey(), new BigEndianByteArrayBuffer(key));
            buffer[i] = new Entry(key, (byte[])next.getValue());
        }
        Arrays.sort(buffer);
        assert (!entries.hasNext()) : "We hold the lock, so we should see 'size' entries.";
        byte[][] result = new byte[buffer.length * 2][];
        for (int i = 0; i < buffer.length; ++i) {
            result[i * 2] = ((Entry)buffer[i]).key;
            result[i * 2 + 1] = ((Entry)buffer[i]).value;
        }
        return result;
    }

    private static class UpdateProvider
    implements DataProvider {
        private final byte[][] data;
        private int i;

        UpdateProvider(byte[][] data) {
            this.data = data;
        }

        @Override
        public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
            if (this.i < this.data.length) {
                key.put(0, this.data[this.i]);
                value.put(0, this.data[this.i + 1]);
                this.i += 2;
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        final byte[] key;
        final byte[] value;

        private Entry(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Entry that) {
            return BigEndianByteArrayBuffer.compare(this.key, that.key, 0);
        }
    }

    private static class PreviousValue
    extends ValueSink {
        private final byte[] proposal;

        PreviousValue(byte[] proposal) {
            this.proposal = proposal;
        }

        @Override
        protected void value(ReadableBuffer value) {
            value.get(0, this.proposal);
        }
    }

    private static class Prototype<Key>
    extends PrototypeState<Key> {
        final ConcurrentMap<Key, byte[]> changes = new ConcurrentHashMap<Key, byte[]>();
        final AtomicLong highestAppliedVersion;
        final AtomicLong appliedChanges = new AtomicLong();
        final AtomicBoolean hasTrackedChanges;
        private final long threshold;

        Prototype(ConcurrentMapState<Key> state, long version) {
            super(state);
            this.threshold = version;
            this.hasTrackedChanges = new AtomicBoolean();
            this.highestAppliedVersion = new AtomicLong(version);
        }

        @Override
        protected ActiveState<Key> create(ReadableState<Key> sub, File file) {
            return new ConcurrentMapState(this, sub, file);
        }

        @Override
        protected EntryUpdater<Key> updater(long version, Lock lock) {
            ConcurrentMapState.update(this.highestAppliedVersion, version);
            if (version > this.threshold) {
                this.hasTrackedChanges.set(true);
                return new Updater<Key>(lock, this.store, this.changes, this.appliedChanges);
            }
            return new Updater<Key>(lock, this.store, this.changes, null);
        }

        @Override
        protected EntryUpdater<Key> unsafeUpdater(Lock lock) {
            this.hasTrackedChanges.set(true);
            return new Updater<Key>(lock, this.store, this.changes, null);
        }

        @Override
        protected boolean hasChanges() {
            return this.hasTrackedChanges.get() && !this.changes.isEmpty();
        }

        @Override
        protected long version() {
            return this.highestAppliedVersion.get();
        }

        @Override
        protected boolean lookup(Key key, ValueSink sink) throws IOException {
            return ConcurrentMapState.performLookup(this.store, this.changes, key, sink);
        }

        @Override
        protected DataProvider dataProvider() throws IOException {
            return ConcurrentMapState.dataProvider(this.store, this.changes);
        }
    }

    private static class Updater<Key>
    extends EntryUpdater<Key> {
        private AtomicLong changeCounter;
        private final ReadableState<Key> store;
        private final ConcurrentMap<Key, byte[]> changes;

        Updater(Lock lock, ReadableState<Key> store, ConcurrentMap<Key, byte[]> changes, AtomicLong changeCounter) {
            super(lock);
            this.changeCounter = changeCounter;
            this.store = store;
            this.changes = changes;
        }

        @Override
        public void apply(Key key, ValueUpdate update) throws IOException {
            this.ensureOpenOnSameThread();
            ConcurrentMapState.applyUpdate(this.store, this.changes, key, update, false);
        }

        @Override
        public void close() {
            if (this.changeCounter != null) {
                this.changeCounter.incrementAndGet();
                this.changeCounter = null;
            }
            super.close();
        }
    }
}

