/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.EntryVisitor;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.Metadata;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;

abstract class MetadataCollector
extends Metadata
implements EntryVisitor<BigEndianByteArrayBuffer> {
    private static final byte[] NO_DATA = new byte[0];
    private final int entriesPerPage;
    private final HeaderField<?>[] headerFields;
    private final Map<HeaderField<?>, Integer> headerIndexes = new HashMap();
    private final Object[] headerValues;
    private int header;
    private int data;
    private State state = State.expecting_format_specifier;
    private byte[] catalogue = NO_DATA;

    public MetadataCollector(int entriesPerPage, HeaderField<?>[] headerFields) {
        this.entriesPerPage = entriesPerPage;
        headerFields = (HeaderField[])headerFields.clone();
        this.headerFields = headerFields;
        this.headerValues = new Object[headerFields.length];
        for (int i = 0; i < headerFields.length; ++i) {
            this.headerIndexes.put(Objects.requireNonNull(headerFields[i], "header field"), i);
        }
    }

    public String toString() {
        return "MetadataCollector[" + (Object)((Object)this.state) + "]";
    }

    @Override
    public Headers headers() {
        return Headers.indexedHeaders(this.headerIndexes, (Object[])this.headerValues.clone());
    }

    @Override
    public final boolean visit(BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) {
        return this.state.visit(this, key, value);
    }

    private void readHeader(int offset, BigEndianByteArrayBuffer value) {
        this.headerValues[offset] = this.headerFields[offset].read(value);
    }

    private void readData(BigEndianByteArrayBuffer key) {
        if ((this.header + this.data) % this.entriesPerPage == 1 || this.data == 1) {
            int oldLen = this.catalogue.length;
            this.catalogue = Arrays.copyOf(this.catalogue, oldLen + 2 * key.size());
            key.dataTo(this.catalogue, oldLen);
        }
        key.dataTo(this.catalogue, this.catalogue.length - key.size());
    }

    abstract boolean verifyFormatSpecifier(ReadableBuffer var1);

    @Override
    byte[] pageCatalogue() {
        return this.catalogue;
    }

    @Override
    int headerEntries() {
        return this.header;
    }

    @Override
    int totalEntries() {
        return this.header + this.data;
    }

    private static enum State {
        expecting_format_specifier{

            @Override
            boolean visit(MetadataCollector collector, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) {
                return State.readFormatSpecifier(collector, key, value);
            }
        }
        ,
        expecting_header{

            @Override
            boolean visit(MetadataCollector collector, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) {
                if (!key.allZeroes()) {
                    throw new IllegalStateException("Expecting at least one header after the format specifier.");
                }
                if (value.allZeroes()) {
                    int header = ++collector.header;
                    assert (header == 2) : "End-of-header markers are always the second header after the format specifier.";
                    if (collector.headerFields.length > 0) {
                        throw new IllegalStateException("Expected " + collector.headerFields.length + " header fields, none seen.");
                    }
                    collector.state = 2.reading_data;
                    return true;
                }
                return (collector.state = 2.reading_header).visit(collector, key, value);
            }
        }
        ,
        reading_header{

            @Override
            boolean visit(MetadataCollector collector, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) {
                if (key.allZeroes()) {
                    if (value.minusOneAtTheEnd()) {
                        collector.state = 3.done;
                        return false;
                    }
                    if (collector.header > collector.headerFields.length) {
                        throw new IllegalStateException("Too many header fields, expected only " + collector.headerFields.length);
                    }
                    int header = collector.header - 1;
                    collector.header++;
                    collector.readHeader(header, value);
                    return true;
                }
                if (collector.headerFields.length >= collector.header) {
                    throw new IllegalStateException("Expected " + collector.headerFields.length + " header fields, only " + (collector.header - 1) + " seen.");
                }
                return (collector.state = 3.reading_data).visit(collector, key, value);
            }
        }
        ,
        reading_data{

            @Override
            boolean visit(MetadataCollector collector, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) {
                if (key.allZeroes()) {
                    long entries;
                    long encodedEntries = value.getIntegerFromEnd();
                    long l = entries = encodedEntries == -1L ? 0L : encodedEntries;
                    if (entries != (long)collector.data) {
                        collector.state = 4.in_error;
                        throw new IllegalStateException("Number of data entries does not match. (counted=" + collector.data + ", trailer=" + entries + ")");
                    }
                    collector.state = 4.done;
                    return false;
                }
                collector.data++;
                collector.readData(key);
                return true;
            }
        }
        ,
        done{

            @Override
            boolean visit(MetadataCollector collector, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) {
                throw new IllegalStateException("Metadata collection has completed.");
            }
        }
        ,
        in_error{

            @Override
            boolean visit(MetadataCollector collector, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) {
                throw new IllegalStateException("Metadata collection has failed.");
            }
        };


        abstract boolean visit(MetadataCollector var1, BigEndianByteArrayBuffer var2, BigEndianByteArrayBuffer var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean readFormatSpecifier(MetadataCollector collector, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) {
            if (!key.allZeroes()) {
                throw new IllegalStateException("Expecting a valid format specifier.");
            }
            if (!collector.verifyFormatSpecifier(value)) {
                collector.state = State.in_error;
                throw new IllegalStateException("Format header/trailer has changed.");
            }
            try {
                collector.header = 1;
                boolean bl = true;
                return bl;
            }
            finally {
                collector.state = State.expecting_header;
            }
        }
    }
}

