/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;

public class StoreMigratorCheckPointer {
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;

    public StoreMigratorCheckPointer(File storeDir, FileSystemAbstraction fileSystem) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
    }

    public void checkPoint(long logVersion, long lastCommittedTx) throws IOException {
        Throwable throwable;
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.storeDir, this.fileSystem);
        File logFileForVersion = logFiles.getLogFileForVersion(logVersion);
        if (!this.fileSystem.fileExists(logFileForVersion)) {
            throwable = null;
            try (StoreChannel channel = this.fileSystem.create(logFileForVersion);){
                LogHeaderWriter.writeLogHeader(channel, logVersion, lastCommittedTx);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        throwable = null;
        try (PhysicalLogVersionedStoreChannel storeChannel = PhysicalLogFile.openForVersion(logFiles, this.fileSystem, logVersion, true);){
            long offset = storeChannel.size();
            storeChannel.position(offset);
            try (PositionAwarePhysicalFlushableChannel channel = new PositionAwarePhysicalFlushableChannel(storeChannel);){
                TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter(channel));
                writer.checkPoint(new LogPosition(logVersion, offset));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }
}

