/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.string.UTF8;

public class LegacyStoreVersionCheck {
    private final FileSystemAbstraction fs;

    public LegacyStoreVersionCheck(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StoreVersionCheck.Result hasVersion(File storeFile, String expectedVersion, boolean optional) {
        StoreChannel fileChannel = null;
        String storeFilename = storeFile.getName();
        byte[] expectedVersionBytes = UTF8.encode((String)expectedVersion);
        try {
            if (!this.fs.fileExists(storeFile)) {
                if (optional) {
                    StoreVersionCheck.Result result = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.ok, null, storeFilename);
                    return result;
                }
                StoreVersionCheck.Result result = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.missingStoreFile, null, storeFilename);
                return result;
            }
            fileChannel = this.fs.open(storeFile, "r");
            if (fileChannel.size() < (long)expectedVersionBytes.length) {
                StoreVersionCheck.Result result = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.storeVersionNotFound, null, storeFilename);
                return result;
            }
            String actualVersion = this.readVersion(fileChannel, expectedVersionBytes.length);
            if (expectedVersion.equals(actualVersion)) return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.ok, null, storeFilename);
            StoreVersionCheck.Result result = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.unexpectedStoreVersion, actualVersion, storeFilename);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String readVersion(StoreChannel fileChannel, int bytesToRead) throws IOException {
        fileChannel.position(fileChannel.size() - (long)bytesToRead);
        byte[] foundVersionBytes = new byte[bytesToRead];
        fileChannel.read(ByteBuffer.wrap(foundVersionBytes));
        return UTF8.decode((byte[])foundVersionBytes);
    }
}

