/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

class TransactionCommitment
implements Commitment {
    private final boolean hasLegacyIndexChanges;
    private final long transactionId;
    private final long transactionChecksum;
    private final long transactionCommitTimestamp;
    private final LogPosition logPosition;
    private final TransactionIdStore transactionIdStore;
    private boolean markedAsCommitted;

    TransactionCommitment(boolean hasLegacyIndexChanges, long transactionId, long transactionChecksum, long transactionCommitTimestamp, LogPosition logPosition, TransactionIdStore transactionIdStore) {
        this.hasLegacyIndexChanges = hasLegacyIndexChanges;
        this.transactionId = transactionId;
        this.transactionChecksum = transactionChecksum;
        this.transactionCommitTimestamp = transactionCommitTimestamp;
        this.logPosition = logPosition;
        this.transactionIdStore = transactionIdStore;
    }

    @Override
    public void publishAsCommitted() {
        this.markedAsCommitted = true;
        this.transactionIdStore.transactionCommitted(this.transactionId, this.transactionChecksum, this.transactionCommitTimestamp);
    }

    @Override
    public void publishAsClosed() {
        this.transactionIdStore.transactionClosed(this.transactionId, this.logPosition.getLogVersion(), this.logPosition.getByteOffset());
    }

    @Override
    public boolean markedAsCommitted() {
        return this.markedAsCommitted;
    }

    @Override
    public boolean hasLegacyIndexChanges() {
        return this.hasLegacyIndexChanges;
    }
}

