/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.udc;

import java.util.function.Supplier;
import org.neo4j.function.Suppliers;

public class UsageDataKey<Type> {
    private final String name;
    private final Supplier<Type> defaultVal;

    public static <T> UsageDataKey<T> key(String name) {
        return UsageDataKey.key(name, null);
    }

    public static <T> UsageDataKey<T> key(String name, T defaultVal) {
        return new UsageDataKey(name, Suppliers.singleton(defaultVal));
    }

    public static <T> UsageDataKey<T> key(String name, Supplier<T> defaultVal) {
        return new UsageDataKey<T>(name, defaultVal);
    }

    public UsageDataKey(String name, Supplier<Type> defaultValue) {
        this.name = name;
        this.defaultVal = defaultValue;
    }

    String name() {
        return this.name;
    }

    Type generateDefaultValue() {
        return this.defaultVal == null ? null : (Type)this.defaultVal.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageDataKey key = (UsageDataKey)o;
        return this.name.equals(key.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

