/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Receiver;

public class PerTypeRelationshipSplitter
extends PrefetchingIterator<InputIterator<InputRelationship>> {
    private static final String MINORITY_TYPE = "minority";
    private final Object[] allRelationshipTypes;
    private final InputIterator<InputRelationship> actual;
    private final Predicate<Object> minorityRelationshipTypes;
    private final ToIntFunction<Object> typeToId;
    private final InputCache inputCache;
    private int typeCursor;
    private boolean allMinority;

    public PerTypeRelationshipSplitter(InputIterator<InputRelationship> actual, Object[] allRelationshipTypes, Predicate<Object> minorityRelationshipTypes, ToIntFunction<Object> typeToId, InputCache inputCache) {
        this.actual = actual;
        this.allRelationshipTypes = allRelationshipTypes;
        this.minorityRelationshipTypes = minorityRelationshipTypes;
        this.typeToId = typeToId;
        this.inputCache = inputCache;
    }

    protected InputIterator<InputRelationship> fetchNextOrNull() {
        while (this.typeCursor < this.allRelationshipTypes.length) {
            Object type = this.allRelationshipTypes[this.typeCursor++];
            if (this.typeCursor == 1) {
                if (this.minorityRelationshipTypes.test(type)) {
                    this.allMinority = true;
                    return null;
                }
                return new FilteringAndPerTypeCachingInputIterator(this.actual, type);
            }
            if (this.minorityRelationshipTypes.test(type)) continue;
            return this.inputCache.relationships(this.cacheSubType(type), true).iterator();
        }
        return null;
    }

    String cacheSubType(Object type) {
        return String.valueOf(this.typeToId.applyAsInt(type));
    }

    public Object currentType() {
        return this.allRelationshipTypes[this.typeCursor - 1];
    }

    int highestTypeId() {
        int highest = 0;
        for (Object type : this.allRelationshipTypes) {
            highest = Integer.max(highest, this.typeToId.applyAsInt(type));
        }
        return highest;
    }

    public InputIterator<InputRelationship> getMinorityRelationships() {
        return this.allMinority ? this.actual : this.inputCache.relationships(MINORITY_TYPE, true).iterator();
    }

    public class FilteringAndPerTypeCachingInputIterator
    extends InputIterator.Delegate<InputRelationship> {
        private final Object currentType;
        private final Receiver<InputRelationship[], IOException>[] receivers;
        private final Receiver<InputRelationship[], IOException> minorityReceiver;
        private final InputRelationship[] transport;

        public FilteringAndPerTypeCachingInputIterator(InputIterator<InputRelationship> actual, Object currentType) {
            super(actual);
            this.transport = new InputRelationship[1];
            this.currentType = currentType;
            this.receivers = new Receiver[PerTypeRelationshipSplitter.this.highestTypeId() + 1];
            try {
                for (Object type : PerTypeRelationshipSplitter.this.allRelationshipTypes) {
                    if (type.equals(currentType) || PerTypeRelationshipSplitter.this.minorityRelationshipTypes.test(type)) continue;
                    int typeId = PerTypeRelationshipSplitter.this.typeToId.applyAsInt(type);
                    this.receivers[typeId] = PerTypeRelationshipSplitter.this.inputCache.cacheRelationships(PerTypeRelationshipSplitter.this.cacheSubType(type));
                }
                this.minorityReceiver = PerTypeRelationshipSplitter.this.inputCache.cacheRelationships(PerTypeRelationshipSplitter.MINORITY_TYPE);
            }
            catch (IOException e) {
                throw new InputException("Error creating a cacher", e);
            }
        }

        @Override
        protected InputRelationship fetchNextOrNull() {
            InputRelationship candidate;
            while ((candidate = (InputRelationship)super.fetchNextOrNull()) != null) {
                Object type = candidate.typeAsObject();
                if (type.equals(this.currentType)) {
                    return candidate;
                }
                try {
                    Receiver<InputRelationship[], IOException> receiver = PerTypeRelationshipSplitter.this.minorityRelationshipTypes.test(type) ? this.minorityReceiver : this.receivers[PerTypeRelationshipSplitter.this.typeToId.applyAsInt(type)];
                    this.transport[0] = candidate;
                    receiver.receive(this.transport);
                }
                catch (IOException e) {
                    throw new InputException("Error caching relationship " + candidate, e);
                }
            }
            return null;
        }

        @Override
        public void close() {
            try {
                for (Receiver<InputRelationship[], IOException> receiver : this.receivers) {
                    if (receiver == null) continue;
                    receiver.close();
                }
                this.minorityReceiver.close();
            }
            catch (IOException e) {
                throw new InputException("Error closing cacher", e);
            }
            super.close();
        }
    }
}

