/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.impl.api.index.UpdateMode;

public class IndexEntryUpdate<INDEX_KEY extends LabelSchemaSupplier> {
    private final long entityId;
    private final UpdateMode updateMode;
    private final Object[] before;
    private final Object[] values;
    private final INDEX_KEY indexKey;

    private IndexEntryUpdate(long entityId, INDEX_KEY indexKey, UpdateMode updateMode, Object ... values) {
        this(entityId, indexKey, updateMode, (Object[])null, values);
    }

    private IndexEntryUpdate(long entityId, INDEX_KEY indexKey, UpdateMode updateMode, Object[] before, Object[] values) {
        assert (indexKey.schema().getPropertyIds().length == values.length) : String.format("IndexEntryUpdate values must be of same length as index compositness. Index on %s, but got values %s", indexKey.schema().toString(), Arrays.toString(values));
        assert (before == null || before.length == values.length);
        this.entityId = entityId;
        this.indexKey = indexKey;
        this.before = before;
        this.values = values;
        this.updateMode = updateMode;
    }

    public final long getEntityId() {
        return this.entityId;
    }

    public UpdateMode updateMode() {
        return this.updateMode;
    }

    public INDEX_KEY indexKey() {
        return this.indexKey;
    }

    public Object[] values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntryUpdate that = (IndexEntryUpdate)o;
        if (this.entityId != that.entityId) {
            return false;
        }
        if (this.updateMode != that.updateMode) {
            return false;
        }
        if (!Arrays.deepEquals(this.before, that.before)) {
            return false;
        }
        if (!Arrays.deepEquals(this.values, that.values)) {
            return false;
        }
        return this.indexKey != null ? this.indexKey.schema().equals(that.indexKey.schema()) : that.indexKey == null;
    }

    public int hashCode() {
        int result = (int)(this.entityId ^ this.entityId >>> 32);
        result = 31 * result + (this.updateMode != null ? this.updateMode.hashCode() : 0);
        result = 31 * result + Arrays.deepHashCode(this.before);
        result = 31 * result + Arrays.deepHashCode(this.values);
        result = 31 * result + (this.indexKey != null ? this.indexKey.schema().hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("IndexEntryUpdate[id=%d, mode=%s, %s, values=%s]", new Object[]{this.entityId, this.updateMode, this.indexKey().schema().userDescription(SchemaUtil.idTokenNameLookup), Arrays.toString(this.values)});
    }

    public static <INDEX_KEY extends LabelSchemaSupplier> IndexEntryUpdate<INDEX_KEY> add(long nodeId, INDEX_KEY indexKey, Object ... values) {
        return new IndexEntryUpdate<INDEX_KEY>(nodeId, indexKey, UpdateMode.ADDED, values);
    }

    public static <INDEX_KEY extends LabelSchemaSupplier> IndexEntryUpdate<INDEX_KEY> remove(long nodeId, INDEX_KEY indexKey, Object ... values) {
        return new IndexEntryUpdate<INDEX_KEY>(nodeId, indexKey, UpdateMode.REMOVED, values);
    }

    public static <INDEX_KEY extends LabelSchemaSupplier> IndexEntryUpdate<INDEX_KEY> change(long nodeId, INDEX_KEY indexKey, Object before, Object after) {
        return new IndexEntryUpdate<INDEX_KEY>(nodeId, indexKey, UpdateMode.CHANGED, new Object[]{before}, new Object[]{after});
    }

    public static <INDEX_KEY extends LabelSchemaSupplier> IndexEntryUpdate<INDEX_KEY> change(long nodeId, INDEX_KEY indexKey, Object[] before, Object[] after) {
        return new IndexEntryUpdate<INDEX_KEY>(nodeId, indexKey, UpdateMode.CHANGED, before, after);
    }

    public Object[] beforeValues() {
        if (this.before == null) {
            throw new UnsupportedOperationException("beforeValues is only valid for `UpdateMode.CHANGED");
        }
        return this.before;
    }
}

