/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.CachingLegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionImplementationHandle;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationContainer;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.LegacyIndexTransactionStateImpl;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.storageengine.api.StorageEngine;

public class KernelTransactions
extends LifecycleAdapter
implements Supplier<KernelTransactionsSnapshot> {
    private final StatementLocksFactory statementLocksFactory;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StatementOperationContainer statementOperations;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final TransactionCommitProcess transactionCommitProcess;
    private final TransactionHooks hooks;
    private final TransactionMonitor transactionMonitor;
    private final AvailabilityGuard availabilityGuard;
    private final Tracers tracers;
    private final StorageEngine storageEngine;
    private final Procedures procedures;
    private final TransactionIdStore transactionIdStore;
    private final AccessCapability accessCapability;
    private final Supplier<LegacyIndexTransactionState> legacyIndexTxStateSupplier;
    private final Clock clock;
    private final ReentrantReadWriteLock newTransactionsLock = new ReentrantReadWriteLock();
    private final Set<KernelTransactionImplementation> allTransactions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Factory<KernelTransactionImplementation> factory = new KernelTransactionImplementationFactory(this.allTransactions);
    private final LinkedQueuePool<KernelTransactionImplementation> globalTxPool = new GlobalKernelTransactionPool(this.allTransactions, this.factory);
    private final MarshlandPool<KernelTransactionImplementation> localTxPool = new MarshlandPool(this.globalTxPool);
    private volatile boolean stopped = true;

    public KernelTransactions(StatementLocksFactory statementLocksFactory, ConstraintIndexCreator constraintIndexCreator, StatementOperationContainer statementOperationContainer, SchemaWriteGuard schemaWriteGuard, TransactionHeaderInformationFactory txHeaderFactory, TransactionCommitProcess transactionCommitProcess, IndexConfigStore indexConfigStore, LegacyIndexProviderLookup legacyIndexProviderLookup, TransactionHooks hooks, TransactionMonitor transactionMonitor, AvailabilityGuard availabilityGuard, Tracers tracers, StorageEngine storageEngine, Procedures procedures, TransactionIdStore transactionIdStore, Clock clock, AccessCapability accessCapability) {
        this.statementLocksFactory = statementLocksFactory;
        this.constraintIndexCreator = constraintIndexCreator;
        this.statementOperations = statementOperationContainer;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionHeaderInformationFactory = txHeaderFactory;
        this.transactionCommitProcess = transactionCommitProcess;
        this.hooks = hooks;
        this.transactionMonitor = transactionMonitor;
        this.availabilityGuard = availabilityGuard;
        this.tracers = tracers;
        this.storageEngine = storageEngine;
        this.procedures = procedures;
        this.transactionIdStore = transactionIdStore;
        this.accessCapability = accessCapability;
        this.legacyIndexTxStateSupplier = () -> new CachingLegacyIndexTransactionState(new LegacyIndexTransactionStateImpl(indexConfigStore, legacyIndexProviderLookup));
        this.clock = clock;
        this.blockNewTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelTransaction newInstance(KernelTransaction.Type type, SecurityContext securityContext, long timeout) {
        this.assertCurrentThreadIsNotBlockingNewTransactions();
        SecurityContext frozenSecurityContext = securityContext.freeze();
        while (!this.newTransactionsLock.readLock().tryLock(1L, TimeUnit.SECONDS)) {
            this.assertRunning();
        }
        try {
            this.assertRunning();
            TransactionId lastCommittedTransaction = this.transactionIdStore.getLastCommittedTransaction();
            KernelTransactionImplementation tx = (KernelTransactionImplementation)this.localTxPool.acquire();
            StatementLocks statementLocks = this.statementLocksFactory.newInstance();
            tx.initialize(lastCommittedTransaction.transactionId(), lastCommittedTransaction.commitTimestamp(), statementLocks, type, frozenSecurityContext, timeout);
            KernelTransactionImplementation kernelTransactionImplementation = tx;
            this.newTransactionsLock.readLock().unlock();
            return kernelTransactionImplementation;
        }
        catch (Throwable throwable) {
            try {
                this.newTransactionsLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                throw new TransactionFailureException("Fail to start new transaction.", (Throwable)ie);
            }
        }
    }

    public Set<KernelTransactionHandle> activeTransactions() {
        return this.allTransactions.stream().map(this::createHandle).filter(KernelTransactionHandle::isOpen).collect(Collectors.toSet());
    }

    public void disposeAll() {
        this.terminateTransactions();
        this.localTxPool.disposeAll();
        this.globalTxPool.disposeAll();
    }

    public void terminateTransactions() {
        this.markAllTransactionsAsTerminated();
    }

    private void markAllTransactionsAsTerminated() {
        this.allTransactions.forEach(tx -> tx.markForTermination((Status)Status.General.DatabaseUnavailable));
    }

    public boolean haveClosingTransaction() {
        return this.allTransactions.stream().anyMatch(KernelTransactionImplementation::isClosing);
    }

    public void start() throws Throwable {
        this.stopped = false;
        this.unblockNewTransactions();
    }

    public void stop() throws Throwable {
        this.blockNewTransactions();
        this.stopped = true;
    }

    public void shutdown() throws Throwable {
        this.disposeAll();
    }

    @Override
    public KernelTransactionsSnapshot get() {
        return new KernelTransactionsSnapshot(this.activeTransactions(), this.clock.millis());
    }

    public void blockNewTransactions() {
        this.newTransactionsLock.writeLock().lock();
    }

    public void unblockNewTransactions() {
        if (!this.newTransactionsLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("This thread did not block transactions previously");
        }
        this.newTransactionsLock.writeLock().unlock();
    }

    KernelTransactionHandle createHandle(KernelTransactionImplementation tx) {
        return new KernelTransactionImplementationHandle(tx);
    }

    Set<KernelTransactionImplementation> getAllTransactions() {
        return this.allTransactions;
    }

    private void assertRunning() {
        if (this.availabilityGuard.isShutdown()) {
            throw new DatabaseShutdownException();
        }
        if (this.stopped) {
            throw new IllegalStateException("Can't start new transaction with stopped " + this.getClass());
        }
    }

    private void assertCurrentThreadIsNotBlockingNewTransactions() {
        if (this.newTransactionsLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("Thread that is blocking new transactions from starting can't start new transaction");
        }
    }

    private class GlobalKernelTransactionPool
    extends LinkedQueuePool<KernelTransactionImplementation> {
        private final Set<KernelTransactionImplementation> transactions;

        GlobalKernelTransactionPool(Set<KernelTransactionImplementation> transactions, Factory<KernelTransactionImplementation> factory) {
            super(8, factory);
            this.transactions = transactions;
        }

        protected void dispose(KernelTransactionImplementation tx) {
            this.transactions.remove(tx);
            tx.dispose();
            super.dispose((Object)tx);
        }
    }

    private class KernelTransactionImplementationFactory
    implements Factory<KernelTransactionImplementation> {
        private final Set<KernelTransactionImplementation> transactions;

        KernelTransactionImplementationFactory(Set<KernelTransactionImplementation> transactions) {
            this.transactions = transactions;
        }

        public KernelTransactionImplementation newInstance() {
            KernelTransactionImplementation tx = new KernelTransactionImplementation(KernelTransactions.this.statementOperations, KernelTransactions.this.schemaWriteGuard, KernelTransactions.this.hooks, KernelTransactions.this.constraintIndexCreator, KernelTransactions.this.procedures, KernelTransactions.this.transactionHeaderInformationFactory, KernelTransactions.this.transactionCommitProcess, KernelTransactions.this.transactionMonitor, KernelTransactions.this.legacyIndexTxStateSupplier, (Pool<KernelTransactionImplementation>)KernelTransactions.this.localTxPool, KernelTransactions.this.clock, ((KernelTransactions)KernelTransactions.this).tracers.transactionTracer, ((KernelTransactions)KernelTransactions.this).tracers.lockTracer, ((KernelTransactions)KernelTransactions.this).tracers.pageCursorTracerSupplier, KernelTransactions.this.storageEngine, KernelTransactions.this.accessCapability);
            this.transactions.add(tx);
            return tx;
        }
    }
}

