/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemLifecycleAdapter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.api.LogRotationMonitor;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.security.URLAccessRules;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.transaction.TransactionStats;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerMonitor;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.internal.StoreLocker;
import org.neo4j.kernel.internal.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class PlatformModule {
    public final PageCache pageCache;
    public final Monitors monitors;
    public final GraphDatabaseFacade graphDatabaseFacade;
    public final Dependencies dependencies;
    public final LogService logging;
    public final LifeSupport life;
    public final File storeDir;
    public final DatabaseInfo databaseInfo;
    public final DiagnosticsManager diagnosticsManager;
    public final Tracers tracers;
    public final Config config;
    public final FileSystemAbstraction fileSystem;
    public final DataSourceManager dataSourceManager;
    public final KernelExtensions kernelExtensions;
    public final URLAccessRule urlAccessRule;
    public final JobScheduler jobScheduler;
    public final AvailabilityGuard availabilityGuard;
    public final TransactionStats transactionMonitor;
    public final SystemNanoClock clock;
    public final StoreCopyCheckPointMutex storeCopyCheckPointMutex;

    public PlatformModule(File providedStoreDir, Map<String, String> params, DatabaseInfo databaseInfo, GraphDatabaseFacadeFactory.Dependencies externalDependencies, GraphDatabaseFacade graphDatabaseFacade) {
        this(providedStoreDir, Config.embeddedDefaults(new ConfigurationValidator[0]).with(params), databaseInfo, externalDependencies, graphDatabaseFacade);
    }

    public PlatformModule(File providedStoreDir, Config config, DatabaseInfo databaseInfo, GraphDatabaseFacadeFactory.Dependencies externalDependencies, GraphDatabaseFacade graphDatabaseFacade) {
        this.databaseInfo = databaseInfo;
        this.dataSourceManager = new DataSourceManager();
        this.dependencies = new Dependencies(new DataSourceManager.DependencyResolverSupplier(this.dataSourceManager));
        this.dependencies.satisfyDependency(databaseInfo);
        this.clock = this.dependencies.satisfyDependency(this.createClock());
        this.life = this.dependencies.satisfyDependency(this.createLife());
        this.graphDatabaseFacade = this.dependencies.satisfyDependency(graphDatabaseFacade);
        this.config = this.dependencies.satisfyDependency(config.withDefaults(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.neo4j_home.name(), providedStoreDir.getAbsolutePath()})));
        this.storeDir = providedStoreDir.getAbsoluteFile();
        this.fileSystem = this.dependencies.satisfyDependency(this.createFileSystemAbstraction());
        this.life.add((Lifecycle)new FileSystemLifecycleAdapter(this.fileSystem));
        this.monitors = externalDependencies.monitors() == null ? new Monitors() : externalDependencies.monitors();
        this.dependencies.satisfyDependency(this.monitors);
        this.jobScheduler = (JobScheduler)this.life.add((Lifecycle)this.dependencies.satisfyDependency(this.createJobScheduler()));
        this.dependencies.satisfyDependency(this.life.add((Lifecycle)new UsageData(this.jobScheduler)));
        this.logging = this.dependencies.satisfyDependency(this.createLogService(externalDependencies.userLogProvider()));
        config.setLogger(this.logging.getInternalLog(Config.class));
        this.life.add((Lifecycle)this.dependencies.satisfyDependency(new StoreLockerLifecycleAdapter(new StoreLocker(this.fileSystem), this.storeDir)));
        new JvmChecker(this.logging.getInternalLog(JvmChecker.class), new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
        String desiredImplementationName = config.get(GraphDatabaseFacadeFactory.Configuration.tracer);
        this.tracers = this.dependencies.satisfyDependency(new Tracers(desiredImplementationName, this.logging.getInternalLog(Tracers.class), this.monitors, this.jobScheduler, this.clock));
        this.dependencies.satisfyDependency(this.tracers.pageCacheTracer);
        this.dependencies.satisfyDependency(this.firstImplementor(LogRotationMonitor.class, this.tracers.transactionTracer, LogRotationMonitor.NULL));
        this.dependencies.satisfyDependency(this.firstImplementor(CheckPointerMonitor.class, this.tracers.checkPointTracer, CheckPointerMonitor.NULL));
        this.pageCache = this.dependencies.satisfyDependency(this.createPageCache(this.fileSystem, config, this.logging, this.tracers));
        this.life.add((Lifecycle)new PageCacheLifecycle(this.pageCache));
        this.diagnosticsManager = (DiagnosticsManager)this.life.add((Lifecycle)this.dependencies.satisfyDependency(new DiagnosticsManager(this.logging.getInternalLog(DiagnosticsManager.class))));
        this.dependencies.satisfyDependency(this.dataSourceManager);
        this.availabilityGuard = this.dependencies.satisfyDependency(new AvailabilityGuard((Clock)this.clock, this.logging.getInternalLog(AvailabilityGuard.class)));
        this.transactionMonitor = this.dependencies.satisfyDependency(this.createTransactionStats());
        this.kernelExtensions = this.dependencies.satisfyDependency(new KernelExtensions(new SimpleKernelContext(this.storeDir, databaseInfo, this.dependencies), externalDependencies.kernelExtensions(), this.dependencies, UnsatisfiedDependencyStrategies.fail()));
        this.urlAccessRule = this.dependencies.satisfyDependency(URLAccessRules.combined(externalDependencies.urlAccessRules()));
        this.storeCopyCheckPointMutex = new StoreCopyCheckPointMutex();
        this.dependencies.satisfyDependency(this.storeCopyCheckPointMutex);
        this.publishPlatformInfo((UsageData)((Object)this.dependencies.resolveDependency(UsageData.class)));
    }

    protected SystemNanoClock createClock() {
        return Clocks.nanoClock();
    }

    private <T> T firstImplementor(Class<T> type, Object ... candidates) {
        for (Object candidate : candidates) {
            if (!type.isInstance(candidate)) continue;
            return (T)candidate;
        }
        return null;
    }

    private void publishPlatformInfo(UsageData sysInfo) {
        sysInfo.set(UsageDataKeys.version, Version.getNeo4jVersion());
        sysInfo.set(UsageDataKeys.revision, Version.getKernelVersion());
    }

    public LifeSupport createLife() {
        return new LifeSupport();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    protected LogService createLogService(LogProvider userLogProvider) {
        StoreLogService logService;
        long internalLogRotationThreshold = this.config.get(GraphDatabaseSettings.store_internal_log_rotation_threshold);
        long internalLogRotationDelay = this.config.get(GraphDatabaseSettings.store_internal_log_rotation_delay).toMillis();
        int internalLogMaxArchives = this.config.get(GraphDatabaseSettings.store_internal_log_max_archives);
        StoreLogService.Builder builder = StoreLogService.withRotation(internalLogRotationThreshold, internalLogRotationDelay, internalLogMaxArchives, this.jobScheduler);
        if (userLogProvider != null) {
            builder.withUserLogProvider(userLogProvider);
        }
        builder.withRotationListener(logProvider -> this.diagnosticsManager.dumpAll(logProvider.getLog(DiagnosticsManager.class)));
        for (String debugContext : this.config.get(GraphDatabaseSettings.store_internal_debug_contexts)) {
            builder.withLevel(debugContext, Level.DEBUG);
        }
        builder.withDefaultLevel(this.config.get(GraphDatabaseSettings.store_internal_log_level));
        File logsDir = this.config.get(GraphDatabaseSettings.logs_directory);
        try {
            logService = builder.inLogsDirectory(this.fileSystem, logsDir);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return (LogService)this.life.add((Lifecycle)logService);
    }

    protected Neo4jJobScheduler createJobScheduler() {
        return new Neo4jJobScheduler();
    }

    protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers) {
        Log pageCacheLog = logging.getInternalLog(PageCache.class);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, tracers.pageCacheTracer, tracers.pageCursorTracerSupplier, pageCacheLog);
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        if (config.get(GraphDatabaseSettings.dump_configuration).booleanValue()) {
            pageCacheFactory.dumpConfiguration();
        }
        return pageCache;
    }

    protected TransactionStats createTransactionStats() {
        return new TransactionStats();
    }
}

