/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.drivers.bolt.response.BoltGraphModelAdapter;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowModel;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.DefaultGraphRowModel;
import org.neo4j.ogm.response.model.DefaultRowModel;
import org.neo4j.ogm.result.adapter.AdapterUtils;
import org.neo4j.ogm.result.adapter.GraphModelAdapter;
import org.neo4j.ogm.result.adapter.GraphRowModelAdapter;

public class BoltGraphRowModelAdapter
extends GraphRowModelAdapter {
    private List<String> columns = new ArrayList<String>();

    public BoltGraphRowModelAdapter(BoltGraphModelAdapter graphModelAdapter) {
        super((GraphModelAdapter)graphModelAdapter);
    }

    public GraphRowModel adapt(Map<String, Object> data) {
        if (this.columns == null) {
            throw new ResultProcessingException("Column data cannot be null!");
        }
        HashSet<Long> nodeIdentities = new HashSet<Long>();
        HashSet<Long> edgeIdentities = new HashSet<Long>();
        DefaultGraphModel graphModel = new DefaultGraphModel();
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator<String> iterator = this.columns.iterator();
        this.adapt(iterator, data, (GraphModel)graphModel, variables, values, nodeIdentities, edgeIdentities);
        DefaultRowModel rowModel = new DefaultRowModel(values.toArray(new Object[0]), variables.toArray(new String[0]));
        return new DefaultGraphRowModel((GraphModel)graphModel, rowModel.getValues());
    }

    private void adapt(Iterator<String> iterator, Map<String, Object> data, GraphModel graphModel, List<String> variables, List<Object> values, Set<Long> nodeIdentities, Set<Long> edgeIdentities) {
        while (iterator.hasNext()) {
            String key = iterator.next();
            variables.add(key);
            Object value = data.get(key);
            if (value.getClass().isArray()) {
                Iterable collection = AdapterUtils.convertToIterable((Object)value);
                for (Object element : collection) {
                    this.adapt(element, graphModel, values, nodeIdentities, edgeIdentities);
                }
                continue;
            }
            this.adapt(value, graphModel, values, nodeIdentities, edgeIdentities);
        }
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }
}

