/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.ogm.drivers.bolt.driver.BoltEntityAdapter;
import org.neo4j.ogm.drivers.bolt.response.BoltResponse;
import org.neo4j.ogm.drivers.bolt.response.BoltRestModelAdapter;
import org.neo4j.ogm.drivers.bolt.response.StatisticsModelAdapter;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.response.model.DefaultRestModel;
import org.neo4j.ogm.response.model.QueryStatisticsModel;

public class RestModelResponse
extends BoltResponse<RestModel> {
    private BoltRestModelAdapter restModelAdapter;
    private final QueryStatisticsModel statisticsModel;
    private final Iterator<Record> resultProjection;

    public RestModelResponse(Result result, BoltEntityAdapter entityAdapter) {
        super(result);
        this.restModelAdapter = new BoltRestModelAdapter(entityAdapter);
        this.resultProjection = result.list().iterator();
        this.statisticsModel = new StatisticsModelAdapter().adapt(result);
    }

    @Override
    public RestModel fetchNext() {
        return DefaultRestModel.basedOn(this.buildModel()).orElse(null);
    }

    private Map<String, Object> buildModel() {
        Map<String, Object> row = new LinkedHashMap<String, Object>();
        if (this.resultProjection.hasNext()) {
            row = this.restModelAdapter.adapt(this.resultProjection.next().asMap());
        }
        return row;
    }

    public Optional<QueryStatistics> getStatistics() {
        return Optional.of(this.statisticsModel);
    }
}

