/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcWriter;
import org.netpreserve.jwarc.net.HttpServer;

public class WarcRecorder
extends HttpServer {
    private final WarcWriter warcWriter;

    public WarcRecorder(ServerSocket serverSocket, WarcWriter warcWriter) {
        super(serverSocket);
        this.warcWriter = warcWriter;
    }

    @Override
    void handle(Socket socket, String target, HttpRequest httpRequest) throws IOException, URISyntaxException {
        URI uri = new URI(target);
        String path = uri.getPath();
        if (uri.getQuery() != null) {
            path = path + "?" + uri.getQuery();
        }
        HttpRequest.Builder rb = (HttpRequest.Builder)new HttpRequest.Builder(httpRequest.method(), path).version(MessageVersion.HTTP_1_0);
        for (Map.Entry<String, List<String>> e : httpRequest.headers().map().entrySet()) {
            if (e.getKey().equalsIgnoreCase("TE") || e.getKey().equalsIgnoreCase("Accept-Encoding") || e.getKey().equalsIgnoreCase("Connection")) continue;
            for (String v : e.getValue()) {
                rb.addHeader(e.getKey(), v);
            }
        }
        this.warcWriter.fetch(uri, rb.build(), socket.getOutputStream());
        socket.close();
    }
}

