/*
 * Copyright 1999-2101 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.nlpcn.commons.lang.util.logging;

public class NoLoggingImpl implements Log {

    private String loggerName;

    public NoLoggingImpl(String loggerName){
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void error(String s, Throwable e) {
        error(s);

        if (e != null) {
            e.printStackTrace();
        }
    }

    public void error(String s) {
        if (s != null) {
            System.err.println(loggerName + " : " + s);
        }
    }

    public void debug(String s) {
    	System.out.println(s);
    }

    public void debug(String s, Throwable e) {
    	System.out.println(s+e!=null?e.getMessage():"");
    }

    public void warn(String s) {
    	System.out.println(s);
    }

    @Override
    public void warn(String s, Throwable e) {
    	System.out.println(s+","+e!=null?e.getMessage():"");
    }


    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public void info(String s) {
    	System.out.println(s);
    }

    @Override
    public boolean isWarnEnabled() {
        return false;
    }
}
