/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.tire.library;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.tire.domain.Value;
import org.nlpcn.commons.lang.util.IOUtil;

public class Library {
    public static Forest makeForest(String path) throws Exception {
        return Library.makeForest(new FileInputStream(path));
    }

    public static Forest makeForest(String path, String encoding) throws Exception {
        return Library.makeForest(new FileInputStream(path), encoding);
    }

    public static Forest makeForest(InputStream inputStream) throws Exception {
        return Library.makeForest(IOUtil.getReader(inputStream, "UTF-8"));
    }

    public static Forest makeForest(InputStream inputStream, String encoding) throws Exception {
        return Library.makeForest(IOUtil.getReader(inputStream, encoding));
    }

    public static Forest makeForest(BufferedReader br) throws Exception {
        return Library.makeLibrary(br, new Forest());
    }

    public static Forest makeForest(List<Value> values) {
        Forest forest = new Forest();
        for (Value value : values) {
            Library.insertWord(forest, value.toString());
        }
        return forest;
    }

    private static Forest makeLibrary(BufferedReader br, Forest forest) throws Exception {
        if (br == null) {
            return forest;
        }
        try {
            String temp = null;
            while ((temp = br.readLine()) != null) {
                Library.insertWord(forest, temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            br.close();
        }
        return forest;
    }

    public static void insertWord(Forest forest, Value value) {
        Library.insertWord(forest, value.getKeyword(), value.getParamers());
    }

    public static void insertWord(Forest forest, String temp) {
        String[] param = temp.split("\t");
        temp = param[0];
        String[] resultParams = new String[param.length - 1];
        for (int j = 1; j < param.length; ++j) {
            resultParams[j - 1] = param[j];
        }
        Library.insertWord(forest, temp, resultParams);
    }

    private static void insertWord(Forest forest, String temp, String ... param) {
        SmartForest branch = forest;
        char[] chars = temp.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars.length == i + 1) {
                branch.add(new Forest(chars[i], 3, param));
            } else {
                branch.add(new Forest(chars[i], 1, null));
            }
            branch = ((SmartForest)branch).getBranch(chars[i]);
        }
    }

    public static void removeWord(Forest forest, String word) {
        SmartForest branch = forest;
        char[] chars = word.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (branch == null) {
                return;
            }
            if (chars.length == i + 1) {
                branch.add(new Forest(chars[i], -1, null));
            }
            branch = ((SmartForest)branch).getBranch(chars[i]);
        }
    }
}

