/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.noear.redisx.RedisClient;
import org.noear.redisx.utils.AssertUtil;
import org.noear.redisx.utils.TextUtil;

public class RedisHash
implements Map<String, String> {
    private final RedisClient client;
    private final String hashName;
    private final int inSeconds;

    public RedisHash(RedisClient client, String hashName) {
        this(client, hashName, -1);
    }

    public RedisHash(RedisClient client, String hashName, int inSeconds) {
        this.client = client;
        this.hashName = hashName;
        this.inSeconds = inSeconds;
    }

    @Override
    public int size() {
        return this.client.openAndGet(s -> s.key(this.hashName).hashLen()).intValue();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object field) {
        return this.client.openAndGet(s -> s.key(this.hashName).hashHas(field.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public <T> T getAndDeserialize(String field) {
        String val = this.client.openAndGet(s -> s.key(this.hashName).hashGet(field));
        if (val == null) {
            return null;
        }
        return (T)this.client.serializer().decode(val);
    }

    @Override
    public String get(Object field) {
        return this.client.openAndGet(s -> s.key(this.hashName).hashGet(field.toString()));
    }

    public int getAsInt(String field) {
        String tmp = this.get(field);
        return TextUtil.isEmpty(tmp) ? 0 : Integer.parseInt(tmp);
    }

    public long getAsLong(String field) {
        String tmp = this.get(field);
        return TextUtil.isEmpty(tmp) ? 0L : Long.parseLong(tmp);
    }

    public float getAsFloat(String field) {
        String tmp = this.get(field);
        return TextUtil.isEmpty(tmp) ? 0.0f : Float.parseFloat(tmp);
    }

    public double getAsDouble(String field) {
        String tmp = this.get(field);
        return TextUtil.isEmpty(tmp) ? 0.0 : Double.parseDouble(tmp);
    }

    public void putAndSerialize(String field, Object obj) {
        AssertUtil.notNull(obj, "redis hash value cannot be null");
        String value = this.client.serializer().encode(obj);
        this.client.open(s -> s.key(this.hashName).expire(this.inSeconds).hashSet(field, value));
    }

    @Override
    public String put(String field, String value) {
        this.client.open(s -> s.key(this.hashName).expire(this.inSeconds).hashSet(field, value));
        return value;
    }

    @Override
    public void put(String field, int value) {
        this.put(field, String.valueOf(value));
    }

    @Override
    public void put(String field, long value) {
        this.put(field, String.valueOf(value));
    }

    @Override
    public void put(String field, float value) {
        this.put(field, String.valueOf(value));
    }

    @Override
    public void put(String field, double value) {
        this.put(field, String.valueOf(value));
    }

    @Override
    public String remove(Object field) {
        return this.client.openAndGet(s -> {
            String val = s.key(this.hashName).hashGet(field.toString());
            if (val != null) {
                s.key(this.hashName).hashDel(field.toString());
            }
            return val;
        });
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.client.open(s -> s.key(this.hashName).hashSetAll(m));
    }

    @Override
    public void clear() {
        this.client.open(s -> s.key(this.hashName).delete());
    }

    @Override
    public Set<String> keySet() {
        return this.client.openAndGet(s -> s.key(this.hashName).hashGetAllKeys());
    }

    @Override
    public Collection<String> values() {
        return this.client.openAndGet(s -> s.key(this.hashName).hashGetAllValues());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.client.openAndGet(s -> s.key(this.hashName).hashGetAll()).entrySet();
    }

    public void delay(int seconds) {
        this.client.open(s -> s.key(this.hashName).delay(seconds));
    }
}

