/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;

public class ActionExecutorDefault
implements ActionExecutor {
    @Override
    public boolean matched(Context ctx, String ct) {
        return true;
    }

    @Override
    public Object execute(Context ctx, Object obj, MethodWrap mWrap) throws Throwable {
        List<Object> args = this.buildArgs(ctx, mWrap.getParamWraps());
        return mWrap.invokeByAspect(obj, args.toArray());
    }

    protected List<Object> buildArgs(Context ctx, ParamWrap[] pSet) throws Exception {
        ArrayList<Object> args = new ArrayList<Object>(pSet.length);
        Object bodyObj = this.changeBody(ctx);
        int len = pSet.length;
        for (int i = 0; i < len; ++i) {
            ParamWrap p = pSet[i];
            Class<?> pt = p.getType();
            if (Context.class.isAssignableFrom(pt)) {
                args.add(ctx);
                continue;
            }
            if (ModelAndView.class.isAssignableFrom(pt)) {
                args.add(new ModelAndView());
                continue;
            }
            if (Locale.class.isAssignableFrom(pt)) {
                args.add(ctx.getLocale());
                continue;
            }
            if (UploadedFile.class == pt) {
                args.add(ctx.file(p.getName()));
                continue;
            }
            if (pt.getTypeName().equals("javax.servlet.http.HttpServletRequest")) {
                args.add(ctx.request());
                continue;
            }
            if (pt.getTypeName().equals("javax.servlet.http.HttpServletResponse")) {
                args.add(ctx.response());
                continue;
            }
            Object tv = null;
            if (p.requireBody()) {
                if (String.class.equals(pt)) {
                    tv = ctx.bodyNew();
                } else if (InputStream.class.equals(pt)) {
                    tv = ctx.bodyAsStream();
                }
            }
            if (tv == null) {
                tv = this.changeValue(ctx, p, i, pt, bodyObj);
            }
            if (tv == null && pt.isPrimitive()) {
                if (pt == Short.TYPE) {
                    tv = (short)0;
                } else if (pt == Integer.TYPE) {
                    tv = 0;
                } else if (pt == Long.TYPE) {
                    tv = 0L;
                } else if (pt == Double.TYPE) {
                    tv = 0.0;
                } else if (pt == Float.TYPE) {
                    tv = Float.valueOf(0.0f);
                } else if (pt == Boolean.TYPE) {
                    tv = false;
                } else {
                    throw new IllegalArgumentException("Please enter a valid parameter @" + p.getName());
                }
            }
            if (tv == null && p.required()) {
                ctx.status(400);
                throw new IllegalArgumentException("Required parameter @" + p.getName());
            }
            args.add(tv);
        }
        return args;
    }

    protected Object changeBody(Context ctx) throws Exception {
        return null;
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        String pn = p.getName();
        String pv = null;
        Object tv = null;
        pv = p.requireHeader() ? ctx.header(pn) : ctx.param(pn);
        if (pv == null) {
            pv = p.defaultValue();
        }
        tv = pv == null ? (UploadedFile.class == pt ? ctx.file(pn) : (pn.startsWith("$") ? ctx.attr(pn) : (pt.getName().startsWith("java.") || pt.isArray() || pt.isPrimitive() ? null : this.changeEntityDo(ctx, pn, pt)))) : ConvertUtil.to(p.getParameter(), pt, pn, pv, ctx);
        return tv;
    }

    private Object changeEntityDo(Context ctx, String name, Class<?> type) throws Exception {
        ClassWrap clzW = ClassWrap.get(type);
        NvMap map = ctx.paramMap();
        return clzW.newBy(map::get, ctx);
    }
}

