/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.message;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Function;
import org.noear.solon.annotation.Note;

public class Message {
    private final int flag;
    private final String key;
    private final String resourceDescriptor;
    private final String header;
    private final byte[] body;
    private static final byte[] EMPTY_B = new byte[0];
    private static final String EMPTY_S = "";
    private Charset charset = StandardCharsets.UTF_8;
    private boolean isString;
    private boolean _handled;

    @Note(value="1.\u6d88\u606f\u6807\u5fd7")
    public int flag() {
        return this.flag;
    }

    @Note(value="2.\u6d88\u606fkey")
    public String key() {
        return this.key;
    }

    @Note(value="3.\u8d44\u6e90\u63cf\u8ff0")
    public String resourceDescriptor() {
        return this.resourceDescriptor;
    }

    @Note(value="4.\u6d88\u606f\u5934")
    public String header() {
        return this.header;
    }

    @Note(value="5.\u6d88\u606f\u4e3b\u4f53")
    public byte[] body() {
        return this.body;
    }

    public String bodyAsString() {
        if (this.body == null) {
            return null;
        }
        return new String(this.body, this.charset);
    }

    public <T> T map(Function<Message, T> mapper) {
        return mapper.apply(this);
    }

    public Message(int flag, String key, String resourceDescriptor, String header, byte[] body) {
        this.flag = flag;
        this.key = key == null ? EMPTY_S : key;
        this.resourceDescriptor = resourceDescriptor == null ? EMPTY_S : resourceDescriptor;
        this.header = header == null ? EMPTY_S : header;
        this.body = body == null ? EMPTY_B : body;
    }

    public Message(int flag, String key, String resourceDescriptor, byte[] body) {
        this(flag, key, resourceDescriptor, null, body);
    }

    public Message(int flag, String key, byte[] body) {
        this(flag, key, null, null, body);
    }

    public Message(int flag, byte[] body) {
        this(flag, null, null, null, body);
    }

    public String toString() {
        return "Message{flag=" + this.flag() + ", key='" + this.key() + '\'' + ", resourceDescriptor='" + this.resourceDescriptor() + '\'' + ", header='" + this.header() + '\'' + ", body='" + this.bodyAsString() + '\'' + '}';
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
    }

    public boolean isString() {
        return this.isString;
    }

    public Message isString(boolean isString) {
        this.isString = isString;
        return this;
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public boolean getHandled() {
        return this._handled;
    }

    public static String guid() {
        return UUID.randomUUID().toString();
    }

    public static Message wrap(byte[] body) {
        return new Message(10, Message.guid(), body);
    }

    public static Message wrap(String body) {
        return Message.wrap(body.getBytes(StandardCharsets.UTF_8));
    }

    public static Message wrap(String resourceDescriptor, String header, byte[] body) {
        return new Message(10, Message.guid(), resourceDescriptor, header, body);
    }

    public static Message wrap(String resourceDescriptor, String header, String body) {
        return Message.wrap(resourceDescriptor, header, body.getBytes(StandardCharsets.UTF_8));
    }

    public static Message wrapContainer(byte[] body) {
        return new Message(1, body);
    }

    public static Message wrapHeartbeat() {
        return new Message(11, Message.guid(), null);
    }

    public static Message wrapHandshake(String header, byte[] body) {
        return new Message(12, Message.guid(), EMPTY_S, header, body);
    }

    public static Message wrapHandshake(String header) {
        return Message.wrapHandshake(header, null);
    }

    public static Message wrapResponse(Message request, byte[] body) {
        return new Message(13, request.key(), body);
    }

    public static Message wrapResponse(Message request, String body) {
        return new Message(13, request.key(), body.getBytes(StandardCharsets.UTF_8));
    }
}

