/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.util.DruidPasswordCallback;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.security.auth.callback.PasswordCallback;
import javax.sql.DataSource;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.starter.jdbc.DynaDataSource;
import org.nutz.dao.impl.SimpleDataSource;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean(depose="depose")
public class DataSourceStarter {
    private static final Log log = Logs.get();
    protected static String PRE = "jdbc.";
    @PropDoc(group="jdbc", value="\u8fde\u63a5\u6c60\u7c7b\u578b", possible={"druid", "simple", "hikari"}, defaultValue="druid")
    public static final String PROP_TYPE = PRE + "type";
    @PropDoc(group="jdbc", value="JDBC URL", need=true)
    public static final String PROP_URL = PRE + "url";
    @PropDoc(group="jdbc", value="\u6570\u636e\u5e93\u7528\u6237\u540d")
    public static final String PROP_USERNAME = PRE + "username";
    @PropDoc(group="jdbc", value="\u6570\u636e\u5e93\u5bc6\u7801")
    public static final String PROP_PASSWORD = PRE + "password";
    @Inject
    protected PropertiesProxy conf;
    @Inject(value="refer:$ioc")
    protected Ioc ioc;
    protected static List<DataSource> slaves = new ArrayList<DataSource>();

    @IocBean
    public DataSource getDataSource() throws Exception {
        return DataSourceStarter.createDataSource(this.ioc, this.conf, PRE);
    }

    @IocBean(name="druidDataSource", depose="close")
    public DataSource createDruidDataSource() throws Exception {
        if (Strings.isBlank((CharSequence)this.conf.get(PROP_URL))) {
            throw new RuntimeException("need jdbc.url");
        }
        return DataSourceStarter.createDruidDataSource(this.conf, PRE);
    }

    @IocBean(name="hikariDataSource", depose="close")
    public DataSource createHikariCPDataSource() throws Exception {
        if (Strings.isBlank((CharSequence)this.conf.get(PROP_URL))) {
            throw new RuntimeException("need jdbc.url");
        }
        return DataSourceStarter.createHikariCPDataSource(this.conf, PRE);
    }

    protected static boolean isDruid(PropertiesProxy conf) {
        String type = conf.get(PROP_TYPE, "druid");
        return "druid".equals(type) || "com.alibaba.druid.pool.DruidDataSource".equals(type);
    }

    public static DataSource createDataSource(Ioc ioc, PropertiesProxy conf, String prefix) {
        switch (conf.get(prefix + "type", "druid")) {
            case "simple": 
            case "org.nutz.dao.impl.SimpleDataSource": {
                SimpleDataSource simpleDataSource = new SimpleDataSource();
                String jdbcUrl = conf.get(PRE + "jdbcUrl", conf.get(PRE + "url"));
                if (Strings.isBlank((CharSequence)jdbcUrl)) {
                    throw new RuntimeException("need " + PRE + ".url");
                }
                simpleDataSource.setJdbcUrl(jdbcUrl);
                simpleDataSource.setUsername(conf.get(PROP_USERNAME));
                simpleDataSource.setPassword(conf.get(PROP_PASSWORD));
                return simpleDataSource;
            }
            case "druid": 
            case "com.alibaba.druid.pool.DruidDataSource": {
                String[] tmp;
                DataSource ds = (DataSource)ioc.get(DataSource.class, "druidDataSource");
                for (String beanName : tmp = ioc.getNamesByType(DruidPasswordCallback.class)) {
                    if (Strings.isBlank((CharSequence)beanName)) continue;
                    ((DruidDataSource)ds).setPasswordCallback((PasswordCallback)ioc.get(DruidPasswordCallback.class, beanName));
                }
                return ds;
            }
            case "hikari": 
            case "com.zaxxer.hikari.HikariDataSource": {
                return (DataSource)ioc.get(DataSource.class, "hikariDataSource");
            }
        }
        throw new RuntimeException("not supported jdbc.type=" + conf.get("jdbc.type"));
    }

    public static DataSource createManyDataSource(Ioc ioc, PropertiesProxy conf, String prefix) {
        try {
            return DataSourceStarter.createSlaveDataSource(ioc, conf, prefix);
        }
        catch (Exception e) {
            throw new RuntimeException("datasource init error", e);
        }
    }

    public static DataSource createSlaveDataSource(Ioc ioc, PropertiesProxy conf, String prefix) throws Exception {
        switch (conf.get(prefix + "type", "druid")) {
            case "simple": 
            case "org.nutz.dao.impl.SimpleDataSource": {
                SimpleDataSource simpleDataSource = new SimpleDataSource();
                String jdbcUrl = conf.get(PRE + "jdbcUrl", conf.get(PRE + "url"));
                if (Strings.isBlank((CharSequence)jdbcUrl)) {
                    throw new RuntimeException("need " + PRE + ".url");
                }
                simpleDataSource.setJdbcUrl(jdbcUrl);
                simpleDataSource.setUsername(conf.get(PROP_USERNAME));
                simpleDataSource.setPassword(conf.get(PROP_PASSWORD));
                return simpleDataSource;
            }
            case "druid": 
            case "com.alibaba.druid.pool.DruidDataSource": {
                return DataSourceStarter.createDruidDataSource(conf, prefix);
            }
            case "hikari": 
            case "com.zaxxer.hikari.HikariDataSource": {
                return DataSourceStarter.createHikariCPDataSource(conf, prefix);
            }
        }
        throw new RuntimeException("not supported jdbc.type=" + conf.get("jdbc.type"));
    }

    public static DataSource createDruidDataSource(PropertiesProxy conf, String prefix) throws Exception {
        Map map = Lang.filter(new HashMap(conf.toMap()), (String)prefix, null, null, null);
        DruidDataSource dataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Map)map);
        if (!conf.has(prefix + "filters")) {
            dataSource.setFilters("stat");
        }
        return dataSource;
    }

    public static DataSource createHikariCPDataSource(PropertiesProxy conf, String prefix) throws Exception {
        Properties properties = new Properties();
        for (String key : conf.keys()) {
            if (!key.startsWith(prefix) || key.equals(prefix + "type")) continue;
            if (key.equals(prefix + "url")) {
                if (conf.has(prefix + "jdbcUrl")) continue;
                properties.put("jdbcUrl", conf.get(key));
                continue;
            }
            properties.put(key.substring(5), conf.get(key));
        }
        return new HikariDataSource(new HikariConfig(properties));
    }

    public static DataSource getSlaveDataSource(Ioc ioc, PropertiesProxy conf, String prefix) {
        if (ioc.has("slaveDataSource")) {
            return (DataSource)ioc.get(DataSource.class, "slaveDataSource");
        }
        return DataSourceStarter._getSlaveDataSource(ioc, conf, prefix);
    }

    public static DataSource getManySlaveDataSource(Ioc ioc, PropertiesProxy conf, String prefix) {
        if (ioc.has(prefix + "slaveDataSource")) {
            return (DataSource)ioc.get(DataSource.class, prefix + "slaveDataSource");
        }
        return DataSourceStarter._getSlaveDataSource(ioc, conf, prefix);
    }

    private static DataSource _getSlaveDataSource(Ioc ioc, PropertiesProxy conf, String prefix) {
        ArrayList<DataSource> slaveDataSources = new ArrayList<DataSource>();
        for (String key : conf.keys()) {
            if (!key.startsWith(prefix) || !key.endsWith(".url")) continue;
            String slaveName = key.substring(prefix.length(), key.length() - ".url".length());
            log.debug((Object)("found Slave DataSource name=" + slaveName));
            try {
                DataSource slaveDataSource = DataSourceStarter.createSlaveDataSource(ioc, conf, prefix + slaveName + ".");
                slaveDataSources.add(slaveDataSource);
                slaves.add(slaveDataSource);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (slaveDataSources.size() > 0) {
            if (slaveDataSources.size() == 1) {
                return (DataSource)slaveDataSources.get(0);
            }
            return new DynaDataSource(new DynaDataSourceSeletor(slaveDataSources));
        }
        return null;
    }

    public void depose() {
        log.debug((Object)("shutdown slave datasource count=" + slaves.size()));
        for (DataSource ds : slaves) {
            try {
                if (!(ds instanceof Closeable)) continue;
                ((Closeable)((Object)ds)).close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected static class DynaDataSourceSeletor
    implements Iterator<DataSource>,
    Closeable {
        protected Random random = new Random(System.currentTimeMillis());
        protected DataSource[] ds;

        public DynaDataSourceSeletor(List<DataSource> slaveDataSources) {
            this.ds = slaveDataSources.toArray(new DataSource[slaveDataSources.size()]);
        }

        @Override
        public DataSource next() {
            return this.ds[this.random.nextInt(this.ds.length)];
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public void close() throws IOException {
            for (DataSource dataSource : this.ds) {
                try {
                    if (!(dataSource instanceof Closeable)) continue;
                    ((Closeable)((Object)dataSource)).close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

