/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.export;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.ItextMaker;
import org.ofdrw.converter.export.OFDExporter;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;

public class PDFExporterIText
implements OFDExporter {
    final PdfWriter pdfWriter;
    final PdfDocument pdfDoc;
    final OFDReader ofdReader;
    final ItextMaker pdfMaker;
    private boolean closed = false;

    public PDFExporterIText(Path ofdFilePath, Path pdfFilePath) throws IOException {
        this.ofdReader = new OFDReader(ofdFilePath);
        this.pdfMaker = new ItextMaker(this.ofdReader);
        if (pdfFilePath == null) {
            throw new IllegalArgumentException("\u5bfc\u51faPDF\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!Files.exists(pdfFilePath = pdfFilePath.toAbsolutePath(), new LinkOption[0])) {
            Path parent = pdfFilePath.getParent();
            if (Files.exists(parent, new LinkOption[0])) {
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                }
            } else {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(pdfFilePath, new FileAttribute[0]);
        }
        this.pdfWriter = new PdfWriter(pdfFilePath.toAbsolutePath().toString());
        this.pdfDoc = new PdfDocument(this.pdfWriter);
    }

    public PDFExporterIText(InputStream ofdInStream, OutputStream pdfOutStream) throws IOException {
        this.ofdReader = new OFDReader(ofdInStream);
        this.pdfMaker = new ItextMaker(this.ofdReader);
        if (pdfOutStream == null) {
            throw new IllegalArgumentException("\u5bfc\u51faPDF\u6d41\u4e3a\u7a7a");
        }
        this.pdfWriter = new PdfWriter(pdfOutStream);
        this.pdfDoc = new PdfDocument(this.pdfWriter);
    }

    @Override
    public void export(int ... indexes) throws GeneralConvertException {
        try {
            List<PageInfo> targetPages = new LinkedList();
            if (indexes == null || indexes.length == 0) {
                targetPages.addAll(this.ofdReader.getPageList());
            } else {
                int maxPageIndex = this.ofdReader.getNumberOfPages();
                for (int index : indexes) {
                    if (index < 0 || index >= maxPageIndex) continue;
                    targetPages.add(this.ofdReader.getPageInfo(index));
                }
            }
            targetPages = this.ofdReader.getPageList();
            for (PageInfo pageInfo : targetPages) {
                this.pdfMaker.makePage(this.pdfDoc, pageInfo);
            }
        }
        catch (IOException e) {
            throw new GeneralConvertException("OFD\u8f6c\u6362PDF\u5931\u8d25 ", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.pdfMaker != null && this.pdfDoc != null && this.ofdReader != null) {
            this.pdfMaker.addAttachments(this.pdfDoc, this.ofdReader);
        }
        if (this.pdfDoc != null) {
            this.pdfDoc.close();
        }
        if (this.pdfWriter != null) {
            this.pdfWriter.close();
        }
        if (this.ofdReader != null) {
            this.ofdReader.close();
        }
    }
}

