/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.openjdk.jmh.generators.annotations.APFieldInfo;
import org.openjdk.jmh.generators.annotations.APMetadataInfo;
import org.openjdk.jmh.generators.annotations.APMethodInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.MethodInfo;

public class APClassInfo
extends APMetadataInfo
implements ClassInfo {
    private final TypeElement el;

    public APClassInfo(ProcessingEnvironment processEnv, TypeElement element) {
        super(processEnv, element);
        this.el = element;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.el.getAnnotation(annClass);
    }

    public Collection<MethodInfo> getConstructors() {
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (ExecutableElement e : ElementFilter.constructorsIn(this.el.getEnclosedElements())) {
            mis.add(new APMethodInfo(this.processEnv, this, e));
        }
        return mis;
    }

    public String getName() {
        return this.el.getSimpleName().toString();
    }

    public String getQualifiedName() {
        return this.el.getQualifiedName().toString();
    }

    public Collection<FieldInfo> getFields() {
        ArrayList<FieldInfo> ls = new ArrayList<FieldInfo>();
        for (VariableElement e : ElementFilter.fieldsIn(this.el.getEnclosedElements())) {
            ls.add(new APFieldInfo(this.processEnv, e));
        }
        return ls;
    }

    public Collection<MethodInfo> getMethods() {
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (ExecutableElement e : ElementFilter.methodsIn(this.el.getEnclosedElements())) {
            mis.add(new APMethodInfo(this.processEnv, this, e));
        }
        return mis;
    }

    public String getPackageName() {
        Element walk = this.el;
        while (walk.getKind() != ElementKind.PACKAGE) {
            walk = walk.getEnclosingElement();
        }
        return ((PackageElement)walk).getQualifiedName().toString();
    }

    public ClassInfo getSuperClass() {
        TypeMirror superclass = this.el.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        TypeElement element = (TypeElement)this.processEnv.getTypeUtils().asElement(superclass);
        return new APClassInfo(this.processEnv, element);
    }

    public ClassInfo getDeclaringClass() {
        Element enclosingElement = this.el.getEnclosingElement();
        if (enclosingElement.getKind() == ElementKind.CLASS) {
            return new APClassInfo(this.processEnv, (TypeElement)enclosingElement);
        }
        return null;
    }

    public boolean isAbstract() {
        return this.el.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isPublic() {
        return this.el.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isStrictFP() {
        return this.el.getModifiers().contains((Object)Modifier.STRICTFP);
    }

    public boolean isFinal() {
        return this.el.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isInner() {
        return this.getDeclaringClass() != null && !this.el.getModifiers().contains((Object)Modifier.STATIC);
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

