/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.cdi;

import aQute.bnd.cdi.BeanDef;
import aQute.bnd.cdi.Discover;
import aQute.bnd.cdi.PackageDef;
import aQute.bnd.cdi.ReferenceDef;
import aQute.bnd.component.annotations.ReferenceCardinality;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.signatures.ClassResolver;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.FieldResolver;
import aQute.bnd.signatures.FieldSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.MethodResolver;
import aQute.bnd.signatures.MethodSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Result;
import aQute.bnd.signatures.VoidDescriptor;
import aQute.bnd.version.Version;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CDIAnnotationReader
extends ClassDataCollector {
    public static final Version V1_0 = new Version(1, 0, 0);
    public static final Version CDI_ARCHIVE_VERSION = new Version(1, 1, 0);
    private static final Instruction COMPONENTSCOPED_INSTR = new Instruction("org.osgi.service.cdi.annotations.ComponentScoped");
    private static final Instruction DEPENDENT_INSTR = new Instruction("javax.enterprise.context.Dependent");
    private static final Instruction EXTENSION_INSTR = new Instruction("javax.enterprise.inject.spi.Extension");
    private static final Instruction INTERCEPTOR_INSTR = new Instruction("javax.interceptor.Interceptor");
    private static final Instruction NORMALSCOPE_INSTR = new Instruction("javax.enterprise.context.NormalScope");
    private static final Instruction STEREOTYPE_INSTR = new Instruction("javax.enterprise.inject.Stereotype");
    private static final Instruction VETOED_INSTR = new Instruction("javax.enterprise.inject.Vetoed");
    final Analyzer analyzer;
    final Clazz clazz;
    final ClassSignature classSig;
    final EnumSet<Discover> options;
    final Map<Descriptors.PackageRef, PackageDef> packageInfos = new HashMap<Descriptors.PackageRef, PackageDef>();
    final List<BeanDef> definitions = new ArrayList<BeanDef>();
    boolean baseclass = true;
    Descriptors.TypeRef extendsClass;
    Descriptors.TypeRef[] interfaces;
    Clazz.FieldDef member;
    int parameter = -1;
    ReferenceDef referenceDef;
    int targetIndex = -1;

    CDIAnnotationReader(Analyzer analyzer, Clazz clazz, EnumSet<Discover> options) {
        this.analyzer = Objects.requireNonNull(analyzer);
        this.clazz = clazz;
        this.options = options;
        this.definitions.add(new BeanDef());
        String signature = clazz.getClassSignature();
        this.classSig = analyzer.getClassSignature(signature != null ? signature : "Ljava/lang/Object;");
    }

    public static List<BeanDef> getDefinition(Clazz c, Analyzer analyzer, EnumSet<Discover> options) throws Exception {
        CDIAnnotationReader r = new CDIAnnotationReader(analyzer, c, options);
        return r.getDefs();
    }

    private List<BeanDef> getDefs() throws Exception {
        if (this.options.contains((Object)Discover.annotated)) {
            if (this.clazz.is(Clazz.QUERY.ANNOTATED, VETOED_INSTR, this.analyzer) || !this.clazz.is(Clazz.QUERY.INDIRECTLY_ANNOTATED, COMPONENTSCOPED_INSTR, this.analyzer) && !this.clazz.is(Clazz.QUERY.INDIRECTLY_ANNOTATED, NORMALSCOPE_INSTR, this.analyzer) && !this.clazz.is(Clazz.QUERY.INDIRECTLY_ANNOTATED, STEREOTYPE_INSTR, this.analyzer) && !this.clazz.is(Clazz.QUERY.ANNOTATED, DEPENDENT_INSTR, this.analyzer) && !this.clazz.is(Clazz.QUERY.ANNOTATED, INTERCEPTOR_INSTR, this.analyzer) || this.clazz.is(Clazz.QUERY.IMPLEMENTS, EXTENSION_INSTR, this.analyzer)) {
                return null;
            }
            Clazz packageClazz = this.analyzer.getPackageInfo(this.clazz.getClassName().getPackageRef());
            if (packageClazz != null && packageClazz.is(Clazz.QUERY.ANNOTATED, VETOED_INSTR, this.analyzer)) {
                return null;
            }
        }
        this.clazz.parseClassFileWithCollector(this);
        if (this.options.contains((Object)Discover.annotated_by_bean) && !this.definitions.get((int)0).marked) {
            return null;
        }
        return this.definitions;
    }

    @Override
    public void annotation(Annotation annotation) {
        try {
            switch (annotation.getName().getFQN()) {
                case "org.osgi.service.cdi.annotations.Bean": {
                    this.definitions.get((int)0).marked = true;
                    break;
                }
                case "org.osgi.service.cdi.annotations.Service": {
                    this.doService(annotation);
                    break;
                }
                case "org.osgi.service.cdi.annotations.MinimumCardinality": {
                    int minimumCardinality = (Integer)annotation.get("value");
                    if (minimumCardinality <= 0) break;
                    if (this.referenceDef == null) {
                        this.referenceDef = new ReferenceDef();
                    }
                    this.referenceDef.cardinality = ReferenceCardinality.AT_LEAST_ONE;
                    break;
                }
                case "org.osgi.service.cdi.annotations.Reference": {
                    this.doReference(annotation, this.parameter);
                }
            }
        }
        catch (Exception e) {
            this.analyzer.exception(e, "During bean processing on class %s, exception %s", this.clazz, e);
        }
    }

    @Override
    public void classBegin(int access, Descriptors.TypeRef name) {
        this.definitions.get((int)0).implementation = name;
        PackageDef packageDef = this.packageInfos.computeIfAbsent(name.getPackageRef(), k -> new PackageDef(this.analyzer.getPackageInfo((Descriptors.PackageRef)k)));
        if (packageDef.marked != null) {
            this.definitions.get((int)0).marked = packageDef.marked.matches(name.getFQN());
        }
    }

    @Override
    public void classEnd() throws Exception {
        this.member = null;
        this.referenceDef = null;
    }

    @Override
    public void extendsClass(Descriptors.TypeRef name) {
        this.extendsClass = name;
    }

    @Override
    public void field(Clazz.FieldDef field) {
        this.member = field;
    }

    @Override
    public void implementsInterfaces(Descriptors.TypeRef[] interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public void memberEnd() {
        this.member = null;
        this.referenceDef = null;
        this.parameter = -1;
    }

    @Override
    public void method(Clazz.MethodDef method) {
        if (method.isAbstract() || method.isBridge() || method.isSynthetic()) {
            this.member = null;
            return;
        }
        if (!this.baseclass && method.isPrivate()) {
            this.member = null;
            return;
        }
        this.member = method;
        String signature = this.member.getSignature() != null ? this.member.getSignature() : this.member.descriptor();
        MethodSignature methodSig = this.analyzer.getMethodSignature(signature);
        MethodResolver resolver = new MethodResolver(this.classSig, methodSig);
        if (methodSig.parameterTypes.length != 1) {
            return;
        }
        JavaTypeSignature parameterSig = resolver.resolveParameter(0);
        if (!(parameterSig instanceof ClassTypeSignature)) {
            return;
        }
        ClassTypeSignature param = (ClassTypeSignature)parameterSig;
        switch (param.binary) {
            case "org/osgi/service/cdi/reference/BindService": 
            case "org/osgi/service/cdi/reference/BindBeanServiceObjects": 
            case "org/osgi/service/cdi/reference/BindServiceReference": {
                if (param.classType.typeArguments.length != 1) {
                    this.analyzer.error("In bean %s, Bind parameter has wrong type arguments: %s", this.clazz, param);
                    return;
                }
                ReferenceTypeSignature inferred = resolver.resolveType(param.classType.typeArguments[0]);
                if (!(inferred instanceof ClassTypeSignature)) {
                    this.analyzer.error("In bean %s, Bind parameter has unresolvable type argument: %s", this.clazz, inferred);
                    return;
                }
                ClassTypeSignature classSig = (ClassTypeSignature)inferred;
                Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(classSig.binary);
                ReferenceDef referenceDef = new ReferenceDef();
                referenceDef.service = typeRef.getFQN();
                referenceDef.cardinality = ReferenceCardinality.MULTIPLE;
                this.definitions.get((int)0).references.add(referenceDef);
                break;
            }
        }
    }

    @Override
    public void parameter(int p) {
        this.parameter = p;
    }

    @Override
    public void typeuse(int target_type, int target_index, byte[] target_info, byte[] type_path) {
        if (target_type != 16) {
            this.targetIndex = -1;
            return;
        }
        this.targetIndex = target_index;
    }

    private void doReference(Annotation reference, int targetIndex) {
        ReferenceTypeSignature inferred;
        ClassTypeSignature type;
        ClassResolver resolver;
        Object value = reference.get("value");
        if (value != null) {
            Descriptors.TypeRef typeRef = (Descriptors.TypeRef)value;
            this.referenceDef = new ReferenceDef();
            this.referenceDef.service = typeRef.getFQN();
            this.referenceDef.cardinality = ReferenceCardinality.MANDATORY;
            this.definitions.get((int)0).references.add(this.referenceDef);
            return;
        }
        switch (reference.elementType()) {
            case PARAMETER: {
                String signature = this.member.getSignature() != null ? this.member.getSignature() : this.member.descriptor();
                MethodSignature methodSig = this.analyzer.getMethodSignature(signature);
                resolver = new MethodResolver(this.classSig, methodSig);
                JavaTypeSignature parameterType = ((MethodResolver)resolver).resolveParameter(this.parameter);
                if (!(parameterType instanceof ClassTypeSignature)) {
                    this.analyzer.error("In bean %s, method %s, parameter %s with @Reference has unresolved type %s", this.classSig, this.member.getName(), targetIndex, parameterType);
                    return;
                }
                type = (ClassTypeSignature)parameterType;
                break;
            }
            default: {
                FieldSignature fieldSig;
                String signature = this.member.getSignature();
                if (signature == null) {
                    try {
                        fieldSig = this.analyzer.getFieldSignature(this.member.descriptor());
                    }
                    catch (IllegalArgumentException iae) {
                        fieldSig = null;
                    }
                } else {
                    fieldSig = this.analyzer.getFieldSignature(signature);
                }
                if (fieldSig == null) {
                    this.analyzer.error("In bean %s, field %s has an incompatible type for @Reference: %s", this.clazz, this.member.getName(), this.member.descriptor());
                    return;
                }
                resolver = new FieldResolver(this.classSig, fieldSig);
                ReferenceTypeSignature inferred2 = ((FieldResolver)resolver).resolveField();
                if (!(inferred2 instanceof ClassTypeSignature)) {
                    this.analyzer.error("In bean %s, field %s with @Reference has unresolved type: %s", this.classSig, this.member.getName(), inferred2);
                    return;
                }
                type = (ClassTypeSignature)inferred2;
                break;
            }
        }
        ReferenceCardinality cardinality = ReferenceCardinality.MANDATORY;
        Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(type.binary);
        String fqn = typeRef.getFQN();
        if (fqn.equals("javax.inject.Provider")) {
            inferred = resolver.resolveType(type.classType.typeArguments[0]);
            if (!(inferred instanceof ClassTypeSignature)) {
                this.analyzer.error("In bean %s, in member %s with @Reference the type argument of Provider can't be resolved: %s", this.clazz, this.member.getName(), inferred);
                return;
            }
            type = (ClassTypeSignature)inferred;
            fqn = Descriptors.binaryToFQN(type.binary);
        }
        if (fqn.equals("java.util.Collection") || fqn.equals("java.util.List")) {
            inferred = resolver.resolveType(type.classType.typeArguments[0]);
            if (!(inferred instanceof ClassTypeSignature)) {
                this.analyzer.error("In bean %s, in member %s with @Reference the type argument of Collection or List can't be resolved: %s", this.clazz, this.member.getName(), inferred);
                return;
            }
            type = (ClassTypeSignature)inferred;
            fqn = Descriptors.binaryToFQN(type.binary);
            cardinality = ReferenceCardinality.MULTIPLE;
        } else if (fqn.equals("java.util.Optional")) {
            inferred = resolver.resolveType(type.classType.typeArguments[0]);
            if (!(inferred instanceof ClassTypeSignature)) {
                this.analyzer.error("In bean %s, in member %s with @Reference the type argument of Optional can't be resolved: %s", this.clazz, this.member.getName(), inferred);
                return;
            }
            type = (ClassTypeSignature)inferred;
            fqn = Descriptors.binaryToFQN(type.binary);
            cardinality = ReferenceCardinality.OPTIONAL;
        }
        if (fqn.equals("org.osgi.service.cdi.reference.BeanServiceObjects") || fqn.equals("org.osgi.framework.ServiceReference")) {
            inferred = resolver.resolveType(type.classType.typeArguments[0]);
            if (!(inferred instanceof ClassTypeSignature)) {
                this.analyzer.error("In bean %s, in member %s with @Reference the type argument of BeanServiceObjects or ServiceReference can't be resolved: %s", this.clazz, this.member.getName(), inferred);
                return;
            }
            type = (ClassTypeSignature)inferred;
            fqn = Descriptors.binaryToFQN(type.binary);
        } else if (fqn.equals("java.util.Map$Entry")) {
            inferred = resolver.resolveType(type.innerTypes[0].typeArguments[1]);
            if (!(inferred instanceof ClassTypeSignature)) {
                this.analyzer.error("In bean %s, in member %s with @Reference the second type argument of Map.Entry can't be resolved: %s", this.clazz, this.member.getName(), inferred);
                return;
            }
            type = (ClassTypeSignature)inferred;
            fqn = Descriptors.binaryToFQN(type.binary);
        }
        this.referenceDef = new ReferenceDef();
        this.referenceDef.service = fqn;
        this.referenceDef.cardinality = cardinality;
        this.definitions.get((int)0).references.add(this.referenceDef);
    }

    private void doService(Annotation annotation) {
        switch (annotation.elementType()) {
            case FIELD: {
                FieldSignature fieldSig;
                Clazz.FieldDef fieldDef = this.member;
                String signature = this.member.getSignature();
                if (signature == null) {
                    try {
                        fieldSig = this.analyzer.getFieldSignature(this.member.descriptor());
                    }
                    catch (IllegalArgumentException iae) {
                        fieldSig = null;
                    }
                } else {
                    fieldSig = this.analyzer.getFieldSignature(signature);
                }
                if (fieldSig == null) {
                    this.analyzer.error("In bean %s, field %s has an incompatible type for @Service: %s", this.clazz, fieldDef.getName(), this.member.descriptor());
                    return;
                }
                FieldResolver resolver = new FieldResolver(this.classSig, fieldSig);
                ReferenceTypeSignature type = resolver.resolveField();
                if (!(type instanceof ClassTypeSignature)) {
                    this.analyzer.error("In bean %s, field %s has an incompatible type for @Service: %s", this.clazz, fieldDef.getName(), this.member.descriptor());
                    return;
                }
                ClassTypeSignature returnType = (ClassTypeSignature)type;
                Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(returnType.binary);
                BeanDef beanDef = new BeanDef();
                beanDef.service.add(typeRef);
                this.definitions.add(beanDef);
                break;
            }
            case METHOD: {
                Clazz.MethodDef methodDef = (Clazz.MethodDef)this.member;
                String signature = this.member.getSignature() != null ? this.member.getSignature() : this.member.descriptor();
                MethodSignature methodSig = this.analyzer.getMethodSignature(signature);
                MethodResolver resolver = new MethodResolver(this.classSig, methodSig);
                Result result = resolver.resolveResult();
                if (result instanceof VoidDescriptor) {
                    this.analyzer.error("In bean %s, method %s has @Service and returns void: %s", this.clazz, methodDef.getName(), this.member.descriptor());
                    return;
                }
                if (!(result instanceof ClassTypeSignature)) {
                    this.analyzer.error("In bean %s, method %s has an incompatible return type for @Service: %s", this.clazz, methodDef.getName(), this.member.descriptor());
                    return;
                }
                ClassTypeSignature returnType = (ClassTypeSignature)result;
                Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(returnType.binary);
                BeanDef producer = new BeanDef();
                producer.service.add(typeRef);
                this.definitions.add(producer);
                break;
            }
            case TYPE_USE: {
                if (this.definitions.get((int)0).serviceOrigin != null && this.definitions.get((int)0).serviceOrigin == Annotation.ElementType.TYPE) {
                    this.analyzer.error("In bean %s, @Service cannot be used both on TYPE and TYPE_USE: %s", this.clazz, this.classSig);
                    break;
                }
                this.definitions.get((int)0).serviceOrigin = Annotation.ElementType.TYPE_USE;
                if (this.targetIndex == 65535) {
                    this.definitions.get((int)0).service.add(this.extendsClass);
                    break;
                }
                if (this.targetIndex == -1) break;
                Objects.requireNonNull(this.interfaces);
                this.definitions.get((int)0).service.add(this.interfaces[this.targetIndex]);
                break;
            }
            case TYPE: {
                if (this.definitions.get((int)0).serviceOrigin != null && this.definitions.get((int)0).serviceOrigin == Annotation.ElementType.TYPE_USE) {
                    this.analyzer.error("In bean %s, @Service cannot be used both on TYPE and TYPE_USE: %s", this.clazz, this.classSig);
                    break;
                }
                this.definitions.get((int)0).serviceOrigin = Annotation.ElementType.TYPE;
                Object[] serviceClasses = (Object[])annotation.get("value");
                if (serviceClasses != null && serviceClasses.length > 0) {
                    for (Object serviceClass : serviceClasses) {
                        this.definitions.get((int)0).service.add((Descriptors.TypeRef)serviceClass);
                    }
                    break;
                }
                if (this.interfaces != null && this.interfaces.length > 0) {
                    for (Descriptors.TypeRef inter : this.interfaces) {
                        this.definitions.get((int)0).service.add(inter);
                    }
                    break;
                }
                this.definitions.get((int)0).service.add(this.clazz.getClassName());
                break;
            }
        }
    }
}

